/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormListboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormOptionElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.odftoolkit.simple.form.FormTypeDefinition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListBox
extends FormControl {
    private ArrayList<String> entries;

    ListBox(FormListboxElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static ListBox getInstanceOf(FormListboxElement element) {
        ListBox listbox = new ListBox(element);
        try {
            listbox.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e) {
            Logger.getLogger(ListBox.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this listbox.");
        }
        return listbox;
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormListboxElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormListboxElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public String getId() {
        return ((FormListboxElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setId(String id) {
        ((FormListboxElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    public String getName() {
        return ((FormListboxElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormListboxElement)this.mElement).setFormNameAttribute(name);
    }

    public void setFormMultiSelection(boolean isMultiSelection) {
        ((FormListboxElement)this.mElement).setFormMultipleAttribute(Boolean.valueOf(isMultiSelection));
    }

    public boolean getFormMultiSelection() {
        return ((FormListboxElement)this.mElement).getFormMultipleAttribute();
    }

    public void setFormDropdown(boolean isDropDown) {
        ((FormListboxElement)this.mElement).setFormDropdownAttribute(Boolean.valueOf(isDropDown));
    }

    public boolean getFormDropdown() {
        return ((FormListboxElement)this.mElement).getFormDropdownAttribute();
    }

    public void addItem(String item) {
        if (item == null) {
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ((FormListboxElement)this.mElement).newFormOptionElement().setFormLabelAttribute(item);
        this.entries.add(item);
    }

    public ArrayList<String> getEntries() {
        NodeList items;
        if ((this.entries == null || this.entries.size() == 0) && (items = this.mElement.getElementsByTagName("form:option")) != null && items.getLength() > 0) {
            for (int i = 0; i < items.getLength(); ++i) {
                if (this.entries == null) {
                    this.entries = new ArrayList();
                }
                this.entries.add(((FormOptionElement)items.item(i)).getFormLabelAttribute());
            }
            return this.entries;
        }
        return null;
    }

    public void addItems(String[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            this.addItem(items[i]);
        }
    }

    public void setListSourceType(FormTypeDefinition.FormListSourceType type) {
        ((FormListboxElement)this.mElement).setFormListSourceTypeAttribute(type.toString());
    }

    public FormTypeDefinition.FormListSourceType getListSourceType() {
        String aValue = ((FormListboxElement)this.mElement).getFormListSourceTypeAttribute();
        return FormTypeDefinition.FormListSourceType.enumValueOf(aValue);
    }

    public void setListSource(String listSource) {
        ((FormListboxElement)this.mElement).setFormListSourceAttribute(listSource);
    }

    public String getListSource() {
        return ((FormListboxElement)this.mElement).getFormListSourceAttribute();
    }

    public void setDataField(String dataField) {
        ((FormListboxElement)this.mElement).setFormDataFieldAttribute(dataField);
    }

    public String getDataField() {
        return ((FormListboxElement)this.mElement).getFormDataFieldAttribute();
    }

    public static Iterator<FormControl> getSimpleIterator(Form container) {
        return new SimpleListBoxIterator(container);
    }

    private static class SimpleListBoxIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private ListBox nextElement = null;
        private ListBox tempElement = null;

        private SimpleListBoxIterator(Form container) {
            this.containerElement = container.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public ListBox next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private ListBox findNext(ListBox thisListBox) {
            FormListboxElement nextListBox = null;
            nextListBox = thisListBox == null ? (FormListboxElement)OdfElement.findFirstChildNode(FormListboxElement.class, (Node)this.containerElement) : (FormListboxElement)OdfElement.findNextChildNode(FormListboxElement.class, (Node)thisListBox.getOdfElement());
            if (nextListBox != null) {
                return ListBox.getInstanceOf(nextListBox);
            }
            return null;
        }
    }
}

