/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawControlElement;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.Control;
import org.odftoolkit.simple.style.DefaultStyleHandler;
import org.odftoolkit.simple.style.GraphicProperties;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class ControlStyleHandler
extends DefaultStyleHandler {
    private Control mControl;

    public ControlStyleHandler(Control control) {
        super((OdfStylableElement)control.getOdfElement());
        this.mControl = control;
    }

    public void setAchorType(StyleTypeDefinitions.AnchorType achorType) {
        if (!this.mDocument.getMediaTypeString().equals(Document.OdfMediaType.TEXT.getMediaTypeString()) && !this.mDocument.getMediaTypeString().equals(Document.OdfMediaType.TEXT_TEMPLATE.getMediaTypeString())) {
            return;
        }
        GraphicProperties graphicPropertiesForWrite = this.getGraphicPropertiesForWrite();
        DrawControlElement controlElement = (DrawControlElement)this.mOdfElement;
        controlElement.setTextAnchorTypeAttribute(achorType.toString());
        switch (achorType) {
            case AS_CHARACTER: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.BASELINE);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                break;
            }
            case TO_CHARACTER: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                break;
            }
            case TO_PAGE: {
                controlElement.setTextAnchorPageNumberAttribute(Integer.valueOf(1));
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PAGE);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.FROMTOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.FROMLEFT);
                break;
            }
            case TO_PARAGRAPH: {
                graphicPropertiesForWrite.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                graphicPropertiesForWrite.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                graphicPropertiesForWrite.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                break;
            }
        }
    }
}

