/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.util.List;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.comparator.AbstractComplexComparator;
import org.silverpeas.kernel.util.StringUtil;

public class MediaLogicalComparator
extends AbstractComplexComparator<Media> {
    private final List<MediaCriteria.QUERY_ORDER_BY> logicalOrderBy;
    private static final Integer EMPTY_DIMENSION_ASC = Integer.MAX_VALUE;
    private static final Integer EMPTY_DIMENSION_DESC = Integer.MIN_VALUE;

    private MediaLogicalComparator(List<MediaCriteria.QUERY_ORDER_BY> logicalOrderBy) {
        this.logicalOrderBy = logicalOrderBy;
    }

    public static MediaLogicalComparator on(MediaCriteria.QUERY_ORDER_BY ... logicalOrderBy) {
        return MediaLogicalComparator.on(CollectionUtil.asList((Object[])logicalOrderBy));
    }

    public static MediaLogicalComparator on(List<MediaCriteria.QUERY_ORDER_BY> logicalOrderBy) {
        return new MediaLogicalComparator(logicalOrderBy);
    }

    protected AbstractComplexComparator.ValueBuffer getValuesToCompare(Media media) {
        AbstractComplexComparator.ValueBuffer valueBuffer = new AbstractComplexComparator.ValueBuffer((AbstractComplexComparator)this);
        for (MediaCriteria.QUERY_ORDER_BY queryOrderBy : this.logicalOrderBy) {
            this.setValueToCompare(media, valueBuffer, queryOrderBy);
        }
        return valueBuffer;
    }

    private void setValueToCompare(Media media, AbstractComplexComparator.ValueBuffer valueBuffer, MediaCriteria.QUERY_ORDER_BY queryOrderBy) {
        switch (queryOrderBy) {
            case TITLE_DESC: 
            case TITLE_ASC: {
                this.setTitle(media, valueBuffer, queryOrderBy);
                break;
            }
            case COMPONENT_INSTANCE_ASC: 
            case COMPONENT_INSTANCE_DESC: {
                valueBuffer.append((Object)media.getComponentInstanceId(), queryOrderBy.isAsc());
                break;
            }
            case IDENTIFIER_ASC: 
            case IDENTIFIER_DESC: {
                valueBuffer.append((Object)media.getId(), queryOrderBy.isAsc());
                break;
            }
            case CREATE_DATE_ASC: 
            case CREATE_DATE_DESC: {
                valueBuffer.append((Object)media.getCreationDate(), queryOrderBy.isAsc());
                break;
            }
            case LAST_UPDATE_DATE_ASC: 
            case LAST_UPDATE_DATE_DESC: {
                valueBuffer.append((Object)media.getLastUpdateDate(), queryOrderBy.isAsc());
                break;
            }
            case AUTHOR_ASC_EMPTY_END: 
            case AUTHOR_DESC_EMPTY_END: {
                String author = this.getAuthor(media);
                valueBuffer.append((Object)new AbstractComplexComparator.StringWrapper((AbstractComplexComparator)this, author, queryOrderBy.isAsc(), true), queryOrderBy.isAsc());
                break;
            }
            case AUTHOR_ASC: 
            case AUTHOR_DESC: {
                String author = this.getAuthor(media);
                valueBuffer.append((Object)author, queryOrderBy.isAsc());
                break;
            }
            case SIZE_ASC: 
            case SIZE_DESC: {
                this.setSize(media, valueBuffer, queryOrderBy);
                break;
            }
            case DIMENSION_ASC: 
            case DIMENSION_DESC: {
                this.setDimensions(media, valueBuffer, queryOrderBy);
                break;
            }
            default: {
                throw new UnsupportedOperationException("You must add a new logical data order by management...");
            }
        }
    }

    private void setDimensions(Media media, AbstractComplexComparator.ValueBuffer valueBuffer, MediaCriteria.QUERY_ORDER_BY queryOrderBy) {
        if (media.getType().isPhoto()) {
            Photo photo = media.getPhoto();
            if (photo.getDefinition().isDefined()) {
                valueBuffer.append((Object)Math.max(photo.getDefinition().getWidth(), photo.getDefinition().getHeight()), queryOrderBy.isAsc());
                valueBuffer.append((Object)Math.min(photo.getDefinition().getWidth(), photo.getDefinition().getHeight()), queryOrderBy.isAsc());
            }
        } else if (media.getType().isVideo()) {
            Video video = media.getVideo();
            if (video.getDefinition().isDefined()) {
                valueBuffer.append((Object)Math.max(video.getDefinition().getWidth(), video.getDefinition().getHeight()), queryOrderBy.isAsc());
                valueBuffer.append((Object)Math.min(video.getDefinition().getWidth(), video.getDefinition().getHeight()), queryOrderBy.isAsc());
            }
        } else {
            valueBuffer.append((Object)(queryOrderBy.isAsc() ? EMPTY_DIMENSION_ASC : EMPTY_DIMENSION_DESC), queryOrderBy.isAsc());
        }
    }

    private void setSize(Media media, AbstractComplexComparator.ValueBuffer valueBuffer, MediaCriteria.QUERY_ORDER_BY queryOrderBy) {
        if (media instanceof InternalMedia) {
            valueBuffer.append((Object)((InternalMedia)media).getFileSize(), queryOrderBy.isAsc());
        } else {
            valueBuffer.append((Object)(queryOrderBy.isAsc() ? (long)EMPTY_DIMENSION_ASC.intValue() : (long)EMPTY_DIMENSION_DESC.intValue()), queryOrderBy.isAsc());
        }
    }

    private String getAuthor(Media media) {
        String author = media.getAuthor();
        if (StringUtil.isDefined((String)author)) {
            author = author.toLowerCase();
        }
        return author;
    }

    private void setTitle(Media media, AbstractComplexComparator.ValueBuffer valueBuffer, MediaCriteria.QUERY_ORDER_BY queryOrderBy) {
        String titre = media.getTitle();
        if (StringUtil.isDefined((String)titre)) {
            titre = titre.toLowerCase();
        }
        valueBuffer.append((Object)titre, queryOrderBy.isAsc());
    }
}

