/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.classifieds.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.model.Subscribe;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class ClassifiedsDAO {
    private ClassifiedsDAO() {
        throw new IllegalAccessError("Utility class");
    }

    public static String createClassified(Connection con, ClassifiedDetail classified) throws SQLException {
        String query = "insert into SC_Classifieds_Classifieds (classifiedId, instanceId, title, description, price, creatorId, creationDate, updateDate, status, validatorId, validateDate) values (?,?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            int newId = DBUtil.getNextId((String)"SC_Classifieds_Classifieds", (String)"classifiedId");
            String id = Integer.toString(newId);
            ClassifiedsDAO.initParam(prepStmt, newId, classified);
            prepStmt.executeUpdate();
            String string = id;
            return string;
        }
    }

    public static void updateClassified(Connection con, ClassifiedDetail classified) throws SQLException {
        String query = "update SC_Classifieds_Classifieds set title = ? , description = ? , price = ? , status = ?  , updateDate = ? , validatorId = ? , validateDate = ?  where classifiedId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, classified.getTitle());
            prepStmt.setString(2, classified.getDescription());
            prepStmt.setInt(3, classified.getPrice());
            prepStmt.setString(4, classified.getStatus());
            if (classified.getUpdateDate() != null) {
                prepStmt.setString(5, Long.toString(classified.getUpdateDate().getTime()));
            } else {
                prepStmt.setString(5, null);
            }
            prepStmt.setString(6, classified.getValidatorId());
            if (classified.getValidateDate() != null) {
                prepStmt.setString(7, Long.toString(classified.getValidateDate().getTime()));
            } else {
                prepStmt.setString(7, null);
            }
            prepStmt.setInt(8, classified.getClassifiedId());
            prepStmt.executeUpdate();
        }
    }

    public static void deleteClassified(Connection con, String classifiedId) throws SQLException {
        String query = "delete from SC_Classifieds_Classifieds where classifiedId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(classifiedId));
            prepStmt.executeUpdate();
        }
    }

    public static ClassifiedDetail getClassified(Connection con, String classifiedId) throws SQLException {
        String query = "select * from SC_Classifieds_Classifieds where classifiedId = ? ";
        ClassifiedDetail classified = null;
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(classifiedId));
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    classified = ClassifiedsDAO.fetchClassified(rs);
                }
            }
        }
        return classified;
    }

    public static Collection<ClassifiedDetail> getAllClassifieds(Connection con, String instanceId) throws SQLException {
        ArrayList<ClassifiedDetail> listClassifieds = new ArrayList<ClassifiedDetail>();
        String query = "select * from SC_Classifieds_Classifieds where instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    ClassifiedDetail classified = ClassifiedsDAO.fetchClassified(rs);
                    listClassifieds.add(classified);
                }
            }
        }
        return listClassifieds;
    }

    public static String getNbTotalClassifieds(Connection con, String instanceId) throws SQLException {
        String nb = "";
        String query = "select count(classifiedId) from SC_Classifieds_Classifieds where instanceId = ? and status = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, "Valid");
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    nb = rs.getString(1);
                }
            }
        }
        return nb;
    }

    public static List<ClassifiedDetail> getClassifiedsByUser(Connection con, String instanceId, String userId) throws SQLException {
        ArrayList<ClassifiedDetail> listClassifieds = new ArrayList<ClassifiedDetail>();
        String query = "SELECT * FROM SC_Classifieds_Classifieds WHERE instanceId = ? AND creatorId = ? ORDER BY CASE WHEN updatedate IS NULL THEN creationdate ELSE updatedate END DESC, classifiedId DESC";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, userId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    ClassifiedDetail classified = ClassifiedsDAO.fetchClassified(rs);
                    listClassifieds.add(classified);
                }
            }
        }
        return listClassifieds;
    }

    public static List<ClassifiedDetail> getClassifiedsWithStatus(Connection con, String instanceId, String status, int firstItemIndex, int elementsPerPage) throws SQLException {
        ArrayList<ClassifiedDetail> listClassifieds = new ArrayList<ClassifiedDetail>();
        String query = "select * from SC_Classifieds_Classifieds where instanceId = ? and status = ?  order by CASE WHEN validatedate IS NULL THEN  CASE WHEN updatedate IS NULL THEN creationdate ELSE updatedate END  ELSE validatedate END DESC,  validatedate DESC, updatedate DESC, creationdate DESC";
        int lastIndexResult = firstItemIndex + elementsPerPage - 1;
        boolean displayAllElements = elementsPerPage == -1;
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, status);
            try (ResultSet rs = prepStmt.executeQuery();){
                int index = 0;
                while (rs.next()) {
                    if (displayAllElements || index >= firstItemIndex && index <= lastIndexResult) {
                        ClassifiedDetail classified = ClassifiedsDAO.fetchClassified(rs);
                        listClassifieds.add(classified);
                    }
                    ++index;
                }
            }
        }
        return listClassifieds;
    }

    public static List<ClassifiedDetail> getAllClassifiedsToUnpublish(Connection con, int nbDays, String instanceId) throws SQLException {
        ArrayList<ClassifiedDetail> listClassifieds = new ArrayList<ClassifiedDetail>();
        Calendar calendar = Calendar.getInstance(Locale.FRENCH);
        calendar.add(5, -nbDays);
        Date date = calendar.getTime();
        String query = "select * from SC_Classifieds_Classifieds where ( (updateDate is null and creationDate < ?) or (updateDate is not null and updateDate < ?) ) and instanceId = ? and status = 'Valid'";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, Long.toString(date.getTime()));
            prepStmt.setString(2, Long.toString(date.getTime()));
            prepStmt.setString(3, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    ClassifiedDetail classified = ClassifiedsDAO.fetchClassified(rs);
                    listClassifieds.add(classified);
                }
            }
        }
        return listClassifieds;
    }

    public static String createSubscribe(Connection con, Subscribe subscribe) throws SQLException {
        String id;
        String query = "insert into SC_Classifieds_Subscribes (subscribeId, userId, instanceId, field1, field2) values (?,?,?,?,?)";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            int newId = DBUtil.getNextId((String)"SC_Classifieds_Subscribes", (String)"subscribeId");
            id = Integer.toString(newId);
            ClassifiedsDAO.initParamSubscribe(prepStmt, newId, subscribe);
            prepStmt.executeUpdate();
        }
        return id;
    }

    public static void deleteSubscribe(Connection con, String subscribeId) throws SQLException {
        String query = "delete from SC_Classifieds_Subscribes where subscribeId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(subscribeId));
            prepStmt.executeUpdate();
        }
    }

    public static Collection<Subscribe> getAllSubscribes(Connection con, String instanceId) throws SQLException {
        ArrayList<Subscribe> listSubscribes = new ArrayList<Subscribe>();
        String query = "select * from SC_Classifieds_Subscribes where instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    Subscribe subscribe = ClassifiedsDAO.fetchSubscribe(rs);
                    listSubscribes.add(subscribe);
                }
            }
        }
        return listSubscribes;
    }

    public static Collection<Subscribe> getSubscribesByUser(Connection con, String instanceId, String userId) throws SQLException {
        ArrayList<Subscribe> listSubscribes = new ArrayList<Subscribe>();
        String query = "select * from SC_Classifieds_Subscribes where instanceId = ? and userId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, userId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    Subscribe subscribe = ClassifiedsDAO.fetchSubscribe(rs);
                    listSubscribes.add(subscribe);
                }
            }
        }
        return listSubscribes;
    }

    public static Collection<String> getUsersBySubscribe(Connection con, String instanceId, String field1, String field2) throws SQLException {
        ArrayList<String> listUsers = new ArrayList<String>();
        String query = "select userId from SC_Classifieds_Subscribes where ((field1 = ? and field2 = ?) or (field1 = ? and field2 = '') or (field1 = '' and field2 = ?)) and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setString(1, field1);
            prepStmt.setString(2, field2);
            prepStmt.setString(3, field1);
            prepStmt.setString(4, field2);
            prepStmt.setString(5, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    String userId = rs.getString("userId");
                    listUsers.add(userId);
                }
            }
        }
        return listUsers;
    }

    private static ClassifiedDetail fetchClassified(ResultSet rs) throws SQLException {
        ClassifiedDetail classified = new ClassifiedDetail();
        int classifiedId = rs.getInt("classifiedId");
        String instanceId = rs.getString("instanceId");
        String title = rs.getString("title");
        String description = rs.getString("description");
        int price = 0;
        if (rs.getString("price") != null) {
            price = Integer.parseInt(rs.getString("price"));
        }
        String creatorId = rs.getString("creatorId");
        Date creationDate = new Date(Long.parseLong(rs.getString("creationDate")));
        Date updateDate = null;
        if (rs.getString("updateDate") != null) {
            updateDate = new Date(Long.parseLong(rs.getString("updateDate")));
        }
        String status = rs.getString("status");
        String validatorId = rs.getString("validatorId");
        Date validateDate = null;
        if (rs.getString("validateDate") != null) {
            validateDate = new Date(Long.parseLong(rs.getString("validateDate")));
        }
        classified.setClassifiedId(classifiedId);
        classified.setInstanceId(instanceId);
        classified.setTitle(title);
        classified.setDescription(description);
        classified.setPrice(price);
        classified.setCreatorId(creatorId);
        classified.setCreationDate(creationDate);
        classified.setUpdateDate(updateDate);
        classified.setStatus(status);
        classified.setValidatorId(validatorId);
        classified.setValidateDate(validateDate);
        return classified;
    }

    private static void initParam(PreparedStatement prepStmt, int classifiedId, ClassifiedDetail classified) throws SQLException {
        prepStmt.setInt(1, classifiedId);
        prepStmt.setString(2, classified.getInstanceId());
        prepStmt.setString(3, classified.getTitle());
        prepStmt.setString(4, classified.getDescription());
        prepStmt.setInt(5, classified.getPrice());
        prepStmt.setString(6, classified.getCreatorId());
        prepStmt.setString(7, Long.toString(classified.getCreationDate().getTime()));
        if (classified.getUpdateDate() != null) {
            prepStmt.setString(8, Long.toString(classified.getUpdateDate().getTime()));
        } else {
            prepStmt.setString(8, null);
        }
        prepStmt.setString(9, classified.getStatus());
        prepStmt.setString(10, classified.getValidatorId());
        if (classified.getValidateDate() != null) {
            prepStmt.setString(11, Long.toString(classified.getValidateDate().getTime()));
        } else {
            prepStmt.setString(11, null);
        }
    }

    private static Subscribe fetchSubscribe(ResultSet rs) throws SQLException {
        Subscribe subscribe = new Subscribe();
        int subscribeId = rs.getInt("subscribeId");
        String userId = rs.getString("userId");
        String instanceId = rs.getString("instanceId");
        String field1 = rs.getString("field1");
        String field2 = rs.getString("field2");
        subscribe.setSubscribeId(Integer.toString(subscribeId));
        subscribe.setUserId(userId);
        subscribe.setInstanceId(instanceId);
        subscribe.setField1(field1);
        subscribe.setField2(field2);
        return subscribe;
    }

    private static void initParamSubscribe(PreparedStatement prepStmt, int subscribeId, Subscribe subscribe) throws SQLException {
        prepStmt.setInt(1, subscribeId);
        prepStmt.setString(2, subscribe.getUserId());
        prepStmt.setString(3, subscribe.getInstanceId());
        prepStmt.setString(4, subscribe.getField1());
        prepStmt.setString(5, subscribe.getField2());
    }
}

