/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriter;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriterPool;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;
import org.jetbrains.annotations.NotNull;

public final class DefaultSegmentWriterBuilder {
    @NotNull
    private final String name;
    @NotNull
    private Supplier<GCGeneration> generation = Suppliers.ofInstance((Object)GCGeneration.NULL);
    private boolean pooled = false;
    @NotNull
    private WriterCacheManager cacheManager = new WriterCacheManager.Default();

    private DefaultSegmentWriterBuilder(@NotNull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @NotNull
    public static DefaultSegmentWriterBuilder defaultSegmentWriterBuilder(@NotNull String name) {
        return new DefaultSegmentWriterBuilder(name);
    }

    @NotNull
    public DefaultSegmentWriterBuilder withGeneration(@NotNull Supplier<GCGeneration> generation) {
        this.generation = (Supplier)Preconditions.checkNotNull(generation);
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withGeneration(@NotNull GCGeneration generation) {
        this.generation = Suppliers.ofInstance((Object)((GCGeneration)Preconditions.checkNotNull((Object)generation)));
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withWriterPool() {
        this.pooled = true;
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withoutWriterPool() {
        this.pooled = false;
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder with(WriterCacheManager cacheManager) {
        this.cacheManager = (WriterCacheManager)Preconditions.checkNotNull((Object)cacheManager);
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withoutCache() {
        this.cacheManager = WriterCacheManager.Empty.INSTANCE;
        return this;
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull FileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled), store.getBinariesInlineThreshold());
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull ReadOnlyFileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, new WriteOperationHandler(){

            @Override
            @NotNull
            public GCGeneration getGCGeneration() {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            @NotNull
            public RecordId execute(@NotNull GCGeneration gcGeneration, @NotNull WriteOperationHandler.WriteOperation writeOperation) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            public void flush(@NotNull SegmentStore store) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }
        }, store.getBinariesInlineThreshold());
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull MemoryStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled), 16512);
    }

    @NotNull
    private WriteOperationHandler createWriter(@NotNull FileStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store.getSegmentIdProvider(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store.getSegmentIdProvider(), store.getReader(), this.name, (GCGeneration)this.generation.get());
    }

    @NotNull
    private WriteOperationHandler createWriter(@NotNull MemoryStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store.getSegmentIdProvider(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store.getSegmentIdProvider(), store.getReader(), this.name, (GCGeneration)this.generation.get());
    }
}

