/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.BinaryUtils;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.jetbrains.annotations.NotNull;

public final class RecordId
implements Comparable<RecordId> {
    public static final RecordId NULL = new RecordId(SegmentId.NULL, 0);
    private static final Pattern PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(:(0|[1-9][0-9]*)|\\.([0-9a-f]{8}))");
    static final int SERIALIZED_RECORD_ID_BYTES = 20;
    public static RecordId[] EMPTY_ARRAY = new RecordId[0];
    private final SegmentId segmentId;
    private final int offset;

    public static RecordId fromString(SegmentIdProvider idProvider, String id) {
        Matcher matcher = PATTERN.matcher(id);
        if (matcher.matches()) {
            UUID uuid = UUID.fromString(matcher.group(1));
            SegmentId segmentId = idProvider.newSegmentId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            int offset = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : Integer.parseInt(matcher.group(4), 16);
            return new RecordId(segmentId, offset);
        }
        throw new IllegalArgumentException("Bad record identifier: " + id);
    }

    public RecordId(SegmentId segmentId, int offset) {
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId);
        this.offset = offset;
    }

    public SegmentId getSegmentId() {
        return this.segmentId;
    }

    public int getRecordNumber() {
        return this.offset;
    }

    public UUID asUUID() {
        return this.segmentId.asUUID();
    }

    @NotNull
    public Segment getSegment() {
        return this.segmentId.getSegment();
    }

    @NotNull
    Buffer getBytes() {
        byte[] buffer = new byte[20];
        BinaryUtils.writeLong(buffer, 0, this.segmentId.getMostSignificantBits());
        BinaryUtils.writeLong(buffer, 8, this.segmentId.getLeastSignificantBits());
        BinaryUtils.writeInt(buffer, 16, this.offset);
        return Buffer.wrap((byte[])buffer);
    }

    @Override
    public int compareTo(@NotNull RecordId that) {
        Preconditions.checkNotNull((Object)that);
        int diff = this.segmentId.compareTo(that.segmentId);
        if (diff == 0) {
            diff = this.offset - that.offset;
        }
        return diff;
    }

    public String toString() {
        return String.format("%s.%08x", this.segmentId, this.offset);
    }

    public String toString10() {
        return String.format("%s:%d", this.segmentId, this.offset);
    }

    public int hashCode() {
        return this.segmentId.hashCode() ^ this.offset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RecordId) {
            RecordId that = (RecordId)object;
            return this.offset == that.offset && this.segmentId.equals(that.segmentId);
        }
        return false;
    }

    public int estimateMemoryUsage() {
        return 28 + this.segmentId.estimateMemoryUsage();
    }
}

