/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;

public class FormInstanceValidations
extends ArrayList<FormInstanceValidation> {
    private static final long serialVersionUID = 17226772888377972L;
    private final transient Map<FormInstanceValidationType, Optional<FormInstanceValidation>> byType = new ConcurrentHashMap<FormInstanceValidationType, Optional<FormInstanceValidation>>();

    public FormInstanceValidations() {
        super(3);
        this.resetCache();
    }

    public Optional<FormInstanceValidation> getHierarchicalValidation() {
        return this.getValidationOfType(FormInstanceValidationType.HIERARCHICAL);
    }

    public Optional<FormInstanceValidation> getIntermediateValidation() {
        return this.getValidationOfType(FormInstanceValidationType.INTERMEDIATE);
    }

    public Optional<FormInstanceValidation> getFinalValidation() {
        return this.getValidationOfType(FormInstanceValidationType.FINAL);
    }

    public Optional<FormInstanceValidation> getValidationOfType(FormInstanceValidationType type) {
        return this.byType.computeIfAbsent(type, t -> this.stream().filter(v -> v.getValidationType() == type).findFirst());
    }

    public Optional<FormInstanceValidation> getLatestValidation() {
        return Optional.ofNullable(this.getFinalValidation().orElseGet(() -> this.getIntermediateValidation().orElseGet(() -> this.getHierarchicalValidation().orElse(null))));
    }

    private void resetCache() {
        this.byType.clear();
    }

    @Override
    public FormInstanceValidation set(int index, FormInstanceValidation element) {
        this.resetCache();
        return super.set(index, element);
    }

    @Override
    public boolean add(FormInstanceValidation formInstanceValidation) {
        this.resetCache();
        return super.add(formInstanceValidation);
    }

    @Override
    public void add(int index, FormInstanceValidation element) {
        this.resetCache();
        super.add(index, element);
    }

    @Override
    public FormInstanceValidation remove(int index) {
        this.resetCache();
        return (FormInstanceValidation)((Object)super.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        this.resetCache();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.resetCache();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends FormInstanceValidation> c) {
        this.resetCache();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends FormInstanceValidation> c) {
        this.resetCache();
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.resetCache();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.resetCache();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.resetCache();
        return super.retainAll(c);
    }

    @Override
    public List<FormInstanceValidation> subList(int fromIndex, int toIndex) {
        this.resetCache();
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public boolean removeIf(Predicate<? super FormInstanceValidation> filter) {
        this.resetCache();
        return super.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<FormInstanceValidation> operator) {
        this.resetCache();
        super.replaceAll(operator);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

