/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.io.temp.TemporaryDataManagementSetting;
import org.silverpeas.core.io.temp.TemporaryWorkspaceTranslation;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.core.viewer.service.ViewerContext;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractViewerService {
    public static final String PDF_DOCUMENT_EXTENSION = "pdf";
    private static final Object OBJECT_FOR_SYNC = new Object();
    private static final ConcurrentMap<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private static final Object EXECUTION_SEM_MUTEX = new Object();
    private static int executionSemCount = ViewerSettings.nbMaxConversionsAtSameInstant();
    private static final Semaphore EXECUTION_SEM = new Semaphore(executionSemCount);

    protected File generateTmpFile(ViewerContext viewerContext, String fileExtension) {
        boolean created;
        TemporaryWorkspaceTranslation workspace = viewerContext.getWorkspace();
        if (!workspace.exists() && !(created = workspace.getRootPath().mkdirs())) {
            throw new SilverpeasRuntimeException("Unable to create the root directory of the temporary workspace " + workspace.getRootPath());
        }
        return new File(workspace.getRootPath(), "file." + fileExtension);
    }

    protected File changeFileExtension(File file, String fileExtension) {
        return new File(FilenameUtils.getFullPath((String)file.getPath()) + FilenameUtils.getBaseName((String)file.getPath()) + "." + fileExtension);
    }

    protected <R extends Serializable> ViewerProcess<R> process(String processName, ViewerTreatment<R> viewerTreatment) {
        return new ViewerProcess<R>(processName, viewerTreatment);
    }

    protected static final class ViewerProcess<R extends Serializable> {
        private static final String CACHE_WORKSPACE_KEY_PREFIX = "workspace_viewer_services_";
        private static final String CACHE_RESULT_KEY = "cache_result";
        private final String processName;
        private final ViewerTreatment<R> viewerTreatment;

        private ViewerProcess(String processName, ViewerTreatment<R> viewerTreatment) {
            this.processName = processName;
            this.viewerTreatment = viewerTreatment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Pair<TemporaryWorkspaceTranslation, Semaphore> initialize(ViewerContext viewerContext) {
            Object object = OBJECT_FOR_SYNC;
            synchronized (object) {
                String workspaceCacheKey = CACHE_WORKSPACE_KEY_PREFIX + viewerContext.getViewId();
                SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("initializing workspace of view context {0}", viewerContext.getViewId()));
                TemporaryWorkspaceTranslation workspace = (TemporaryWorkspaceTranslation)cache.computeIfAbsent(workspaceCacheKey, k -> viewerContext.getWorkspace());
                if (workspace.exists()) {
                    SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("workspace of view context {0} exists already", viewerContext.getViewId()));
                    if (!workspace.isWorkInProgress() && workspace.empty()) {
                        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("workspace is empty for view context {0}, create it again", viewerContext.getViewId()));
                        workspace.remove();
                    } else if (workspace.lastModified() >= viewerContext.getOriginalSourceFile().lastModified()) {
                        Semaphore currentProcessing = (Semaphore)cache.get(workspace.getRootPath().getPath());
                        if (currentProcessing != null) {
                            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("semaphore exists already for view context {0}", viewerContext.getViewId()));
                            return Pair.of((Object)workspace, (Object)currentProcessing);
                        }
                        if (workspace.get(CACHE_RESULT_KEY) != null) {
                            return this.renewSemaphore(workspaceCacheKey, workspace);
                        }
                        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("no conversion result in cache, removing workspace of view context {0} for new creation", viewerContext.getViewId()));
                        workspace.remove();
                    } else {
                        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("remove workspace of view context {0} because file {1} has been modified", viewerContext.getViewId(), viewerContext.getOriginalSourceFile().getName()));
                        workspace.remove();
                    }
                }
                SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("creating workspace of view context {0} with its semaphore", viewerContext.getViewId()));
                viewerContext.processingCache();
                workspace.markWorkInProgress();
                workspace.create();
                Semaphore newSemaphore = new Semaphore(1);
                cache.put(workspace.getRootPath().getPath(), newSemaphore);
                return Pair.of((Object)workspace, (Object)newSemaphore);
            }
        }

        private Pair<TemporaryWorkspaceTranslation, Semaphore> renewSemaphore(String workspaceCacheKey, TemporaryWorkspaceTranslation workspace) {
            if (ViewerSettings.isTimeToLiveEnabled()) {
                long fileAgeThreshold = DateUtil.getNow().getTime() - (long)((double)TemporaryDataManagementSetting.getTimeAfterThatFilesMustBeDeleted() * 0.25);
                if (workspace.lastModified() < fileAgeThreshold) {
                    workspace.updateLastModifiedDate();
                }
            }
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("creating semaphore for workspace {0}", workspaceCacheKey));
            return Pair.of((Object)workspace, (Object)new Semaphore(1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performAtExecutionEnd(ViewerContext viewerContext, Pair<TemporaryWorkspaceTranslation, Semaphore> init) {
            Object object = OBJECT_FOR_SYNC;
            synchronized (object) {
                String workspaceCacheKey = CACHE_WORKSPACE_KEY_PREFIX + viewerContext.getViewId();
                cache.remove(workspaceCacheKey);
                cache.remove(viewerContext.getWorkspace().getRootPath().getPath());
            }
            SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("releasing semaphore dedicated to workspace of view context {0}", viewerContext.getViewId()));
            ((Semaphore)init.getValue()).release();
        }

        public R execute(ViewerContext viewerContext) {
            Object returnValue;
            viewerContext.fromInitializerProcessName(this.processName);
            if (!viewerContext.isCacheRequired()) {
                SilverLogger.getLogger((Object)this).debug(() -> "no cache required, performing document conversion");
                R returnValue2 = this.doConversion();
                return (R)((Serializable)this.viewerTreatment.performAfterSuccess(returnValue2));
            }
            Pair<TemporaryWorkspaceTranslation, Semaphore> init = this.initialize(viewerContext);
            TemporaryWorkspaceTranslation workspace = (TemporaryWorkspaceTranslation)init.getKey();
            Semaphore semaphore = (Semaphore)init.getValue();
            try {
                SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("acquiring semaphore dedicated to workspace of view context {0}", viewerContext.getViewId()));
                semaphore.acquire();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            try {
                if (viewerContext.isProcessingCache()) {
                    SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("performing document conversion into workspace of view context {0}", viewerContext.getViewId()));
                    returnValue = this.doConversion();
                    workspace.put(CACHE_RESULT_KEY, returnValue);
                } else {
                    SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("getting document conversion from workspace cache of view context {0}", viewerContext.getViewId()));
                    returnValue = workspace.get(CACHE_RESULT_KEY);
                }
            }
            catch (RuntimeException re) {
                SilverLogger.getLogger((Object)this).error((Throwable)re);
                workspace.put(CACHE_RESULT_KEY, null);
                throw re;
            }
            finally {
                this.performAtExecutionEnd(viewerContext, init);
            }
            return (R)((Serializable)this.viewerTreatment.performAfterSuccess(returnValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R doConversion() {
            try {
                EXECUTION_SEM.acquire();
                Object object = EXECUTION_SEM_MUTEX;
                synchronized (object) {
                    --executionSemCount;
                    SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("acquiring access (new count of {0})", executionSemCount));
                }
                object = (Serializable)this.viewerTreatment.execute();
                return (R)object;
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new SilverpeasRuntimeException((Throwable)e);
            }
            finally {
                EXECUTION_SEM.release();
                Object object = EXECUTION_SEM_MUTEX;
                synchronized (object) {
                    ++executionSemCount;
                    SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("releasing access (new count of {0})", executionSemCount));
                }
            }
        }
    }

    protected static interface ViewerTreatment<R> {
        public R execute();

        default public R performAfterSuccess(R result) {
            return result;
        }
    }
}

