/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.jetbrains.annotations.NotNull;

public class MembershipWriter {
    public static final int DEFAULT_MEMBERSHIP_THRESHOLD = 100;
    private int membershipSizeThreshold = 100;

    void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.membershipSizeThreshold = membershipSizeThreshold;
    }

    boolean addMember(@NotNull Tree groupTree, @NotNull String memberContentId) {
        HashMap m = Maps.newHashMapWithExpectedSize((int)1);
        m.put(memberContentId, "-");
        return this.addMembers(groupTree, m).isEmpty();
    }

    @NotNull
    Set<String> addMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), membersList.getChildren().iterator());
        HashSet<String> failed = new HashSet<String>(memberIds.size());
        int bestCount = this.membershipSizeThreshold;
        PropertyState bestProperty = null;
        Tree bestTree = null;
        while (trees.hasNext() && !memberIds.isEmpty()) {
            Tree t = (Tree)trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null) continue;
            int numRefs = 0;
            for (String ref : (Iterable)refs.getValue(Type.WEAKREFERENCES)) {
                String id = memberIds.remove(ref);
                if (id != null) {
                    failed.add(id);
                    if (memberIds.isEmpty()) break;
                }
                ++numRefs;
            }
            if (numRefs >= bestCount) continue;
            bestCount = numRefs;
            bestProperty = refs;
            bestTree = t;
        }
        if (!memberIds.isEmpty()) {
            int propCnt;
            PropertyBuilder propertyBuilder;
            if (bestProperty == null) {
                bestTree = !groupTree.hasProperty("rep:members") ? groupTree : MembershipWriter.createMemberRefTree(groupTree, membersList);
                propertyBuilder = PropertyBuilder.array((Type)Type.WEAKREFERENCE, (String)"rep:members");
                propCnt = 0;
            } else {
                propertyBuilder = PropertyBuilder.copy((Type)Type.WEAKREFERENCE, bestProperty);
                propCnt = bestCount;
            }
            if (propCnt + memberIds.size() > this.membershipSizeThreshold) {
                while (!memberIds.isEmpty()) {
                    HashSet<String> s = new HashSet<String>();
                    Iterator<String> it = memberIds.keySet().iterator();
                    while (propCnt < this.membershipSizeThreshold && it.hasNext()) {
                        s.add(it.next());
                        it.remove();
                        ++propCnt;
                    }
                    propertyBuilder.addValues(s);
                    bestTree.setProperty(propertyBuilder.getPropertyState());
                    if (!it.hasNext()) continue;
                    propCnt = 0;
                    bestTree = MembershipWriter.createMemberRefTree(groupTree, membersList);
                    propertyBuilder = PropertyBuilder.array((Type)Type.WEAKREFERENCE, (String)"rep:members");
                }
            } else {
                propertyBuilder.addValues(memberIds.keySet());
                bestTree.setProperty(propertyBuilder.getPropertyState());
            }
        }
        return failed;
    }

    @NotNull
    private static Tree createMemberRefTree(@NotNull Tree groupTree, @NotNull Tree membersList) {
        if (!membersList.exists()) {
            membersList = groupTree.addChild("rep:membersList");
            membersList.setProperty("jcr:primaryType", (Object)"rep:MemberReferencesList", Type.NAME);
        }
        Tree refTree = membersList.addChild(MembershipWriter.nextRefNodeName(membersList));
        refTree.setProperty("jcr:primaryType", (Object)"rep:MemberReferences", Type.NAME);
        return refTree;
    }

    @NotNull
    private static String nextRefNodeName(@NotNull Tree membersList) {
        int i = 0;
        String name = String.valueOf(i);
        while (membersList.hasChild(name)) {
            name = String.valueOf(++i);
        }
        return name;
    }

    boolean removeMember(@NotNull Tree groupTree, @NotNull String memberContentId) {
        HashMap m = Maps.newHashMapWithExpectedSize((int)1);
        m.put(memberContentId, "-");
        return this.removeMembers(groupTree, m).isEmpty();
    }

    @NotNull
    Set<String> removeMembers(@NotNull Tree groupTree, @NotNull Map<String, String> memberIds) {
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator trees = Iterators.concat((Iterator)Iterators.singletonIterator((Object)groupTree), membersList.getChildren().iterator());
        while (trees.hasNext() && !memberIds.isEmpty()) {
            Tree t = (Tree)trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null) continue;
            PropertyBuilder prop = PropertyBuilder.copy((Type)Type.WEAKREFERENCE, (PropertyState)refs);
            Iterator<Map.Entry<String, String>> it = memberIds.entrySet().iterator();
            while (it.hasNext() && !prop.isEmpty()) {
                String memberContentId = it.next().getKey();
                if (!prop.hasValue((Object)memberContentId)) continue;
                prop.removeValue((Object)memberContentId);
                it.remove();
            }
            if (prop.isEmpty()) {
                if (t == groupTree) {
                    t.removeProperty("rep:members");
                    continue;
                }
                t.remove();
                continue;
            }
            t.setProperty(prop.getPropertyState());
        }
        return Sets.newHashSet(memberIds.values());
    }
}

