/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization;

import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.jetbrains.annotations.NotNull;

final class AuthorizationContext
implements Context,
AccessControlConstants,
PermissionConstants {
    private static final String[] NODE_NAMES = POLICY_NODE_NAMES.toArray(new String[0]);
    private static final String[] PROPERTY_NAMES = ACE_PROPERTY_NAMES.toArray(new String[0]);
    private static final String[] NT_NAMES = (String[])Iterables.toArray((Iterable)Iterables.concat((Iterable)AC_NODETYPE_NAMES, (Iterable)PERMISSION_NODETYPE_NAMES), String.class);
    private static final Context INSTANCE = new AuthorizationContext();

    private AuthorizationContext() {
    }

    static Context getInstance() {
        return INSTANCE;
    }

    public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
        return this.definesTree(parent);
    }

    public boolean definesContextRoot(@NotNull Tree tree) {
        String name = tree.getName();
        if (AuthorizationContext.isNodeName(name)) {
            return "rep:ACL".equals(TreeUtil.getPrimaryTypeName((Tree)tree));
        }
        return "rep:permissionStore".equals(name);
    }

    public boolean definesTree(@NotNull Tree tree) {
        String ntName = TreeUtil.getPrimaryTypeName((Tree)tree);
        return ntName != null && AuthorizationContext.isNtName(ntName);
    }

    public boolean definesLocation(@NotNull TreeLocation location) {
        Tree tree;
        PropertyState p = location.getProperty();
        Tree tree2 = tree = p == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            return p == null ? this.definesTree(tree) : this.definesProperty(tree, p);
        }
        return AuthorizationContext.isItemName(location.getName()) || location.getPath().startsWith("/jcr:system/rep:permissionStore");
    }

    public boolean definesInternal(@NotNull Tree tree) {
        return "rep:permissionStore".equals(tree.getName());
    }

    private static boolean isNodeName(@NotNull String name) {
        for (String n : NODE_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isItemName(@NotNull String name) {
        if (AuthorizationContext.isNodeName(name)) {
            return true;
        }
        for (String n : PROPERTY_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNtName(@NotNull String name) {
        for (String n : NT_NAMES) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }
}

