/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites.service;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.websites.WebSitesContentManager;
import org.silverpeas.components.websites.dao.SiteDAO;
import org.silverpeas.components.websites.model.FolderDetail;
import org.silverpeas.components.websites.model.IconDetail;
import org.silverpeas.components.websites.model.SiteDetail;
import org.silverpeas.components.websites.model.SitePK;
import org.silverpeas.components.websites.model.WebSitesRuntimeException;
import org.silverpeas.components.websites.service.WebSiteService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.SilverpeasList;

@Service
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultWebSiteService
implements WebSiteService {
    private static final String NO_ID = "useless";
    @Inject
    private NodeService nodeService;
    @Inject
    private PublicationService publicationService;
    @Inject
    private WebSitesContentManager webSitesContentManager = null;

    DefaultWebSiteService() {
    }

    @Override
    public FolderDetail goTo(NodePK pk) {
        Collection pubDetails;
        NodeDetail nodeDetail;
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        try {
            nodeDetail = this.nodeService.getDetail(pk);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
        try {
            pubDetails = this.publicationService.getDetailsByFatherPK(nodeDetail.getNodePK());
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
        if (nodeDetail.getNodePK().isRoot()) {
            newPath.add(nodeDetail);
        } else {
            newPath = this.getPathFromAToZ(nodeDetail);
        }
        Collection childrenPKs = nodeDetail.getChildrenDetails();
        ArrayList<Integer> nbPubByTopic = new ArrayList<Integer>();
        for (NodeDetail child : childrenPKs) {
            int nbPub;
            NodePK childPK = child.getNodePK();
            String childPath = child.getPath();
            try {
                nbPub = this.publicationService.getNbPubByFatherPath(childPK, childPath);
            }
            catch (Exception re) {
                throw new WebSitesRuntimeException(re);
            }
            nbPubByTopic.add(nbPub);
        }
        return new FolderDetail(newPath, nodeDetail, pubDetails, nbPubByTopic);
    }

    private Collection<NodeDetail> getPathFromAToZ(NodeDetail nd) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        try {
            NodePath pathInReverse = this.nodeService.getPath(nd.getNodePK());
            for (int i = pathInReverse.size() - 1; i >= 0; --i) {
                newPath.add((NodeDetail)pathInReverse.get(i));
            }
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
        return newPath;
    }

    public void addToFolder(NodePK fatherId, NodeDetail subTopic) {
        try {
            NodeDetail father = this.nodeService.getDetail(fatherId);
            this.nodeService.createNode(subTopic, father);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public void addFolder(NodeDetail subFolder, NodePK fatherId, UserDetail currentUser) {
        if (subFolder == null) {
            throw new WebSitesRuntimeException("Non existing subfolder node detail to add");
        }
        subFolder.getNodePK().setComponentName(fatherId.getInstanceId());
        subFolder.setCreationDate(new Date());
        subFolder.setCreatorId(currentUser.getId());
        this.addToFolder(fatherId, subFolder);
    }

    @Override
    public void updateFolder(NodeDetail topic, NodePK fatherPK) {
        try {
            NodeDetail father = this.nodeService.getDetail(fatherPK);
            topic.setLevel(father.getLevel());
            topic.setFatherPK(fatherPK);
            topic.getNodePK().setComponentName(fatherPK.getComponentName());
            this.nodeService.setDetail(topic);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public NodeDetail getFolderDetail(NodePK pk) {
        try {
            return this.nodeService.getDetail(pk);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteFolder(NodePK pkToDelete) {
        try {
            Collection nodesToDelete = this.nodeService.getDescendantPKs(pkToDelete);
            nodesToDelete.add(pkToDelete);
            for (NodePK oneNodeToDelete : nodesToDelete) {
                Collection pubsToCheck = this.publicationService.getPubPKsInFatherPK(oneNodeToDelete);
                for (PublicationPK onePubToCheck : pubsToCheck) {
                    this.publicationService.removeFather(onePubToCheck, oneNodeToDelete);
                }
            }
            this.nodeService.removeNode(pkToDelete);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    private int getIndexOfNode(String nodeId, List<NodeDetail> nodes) {
        int index = 0;
        if (nodes != null) {
            for (NodeDetail node : nodes) {
                if (nodeId.equals(node.getNodePK().getId())) {
                    return index;
                }
                ++index;
            }
        }
        return index;
    }

    @Override
    public void changeTopicsOrder(String way, NodePK topicPK, NodePK fatherPK) {
        List subTopics = (List)this.nodeService.getChildrenDetails(fatherPK);
        if (subTopics != null && !subTopics.isEmpty()) {
            int indexOfTopic = this.getIndexOfNode(topicPK.getId(), subTopics);
            NodeDetail node2move = (NodeDetail)subTopics.get(indexOfTopic);
            subTopics.remove(indexOfTopic);
            if ("up".equals(way)) {
                subTopics.add(indexOfTopic - 1, node2move);
            } else {
                subTopics.add(indexOfTopic + 1, node2move);
            }
            for (int i = 0; i < subTopics.size(); ++i) {
                NodeDetail nodeDetail = (NodeDetail)subTopics.get(i);
                try {
                    nodeDetail.setOrder(i);
                    this.nodeService.setDetail(nodeDetail);
                    continue;
                }
                catch (Exception e) {
                    throw new WebSitesRuntimeException(e);
                }
            }
        }
    }

    @Override
    public PublicationDetail getPublicationDetail(PublicationPK pk) {
        try {
            return this.publicationService.getDetail(pk);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createPublication(String componentId, PublicationDetail pubDetail) {
        pubDetail.setPk(new PublicationPK("-1", componentId));
        pubDetail.setStatus("Valid");
        try {
            PublicationPK pubPK = this.publicationService.createPublication(pubDetail);
            pubDetail.getPK().setId(pubPK.getId());
            return pubPK.getId();
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail, String componentId) {
        pubDetail.getPK().setComponentName(componentId);
        try {
            this.publicationService.setDetail(pubDetail);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deletePublication(PublicationPK pubPK) {
        try {
            this.publicationService.removeAllFathers(pubPK);
            this.publicationService.removePublication(pubPK);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public void addPublicationToTopic(PublicationPK pubPK, NodePK fatherPK) {
        try {
            this.publicationService.addFather(pubPK, fatherPK);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public void removePublicationFromTopic(PublicationPK pubPK, NodePK fatherPK) {
        try {
            this.publicationService.removeFather(pubPK, fatherPK);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public Collection<NodePK> getAllFatherPK(PublicationPK pubPK) {
        try {
            return this.publicationService.getAllFatherPKInSamePublicationComponentInstance(pubPK);
        }
        catch (Exception re) {
            throw new WebSitesRuntimeException(re);
        }
    }

    @Override
    public String getIdPublication(String componentId, String idSite) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getIdPublication(idSite);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void updateClassification(PublicationPK pubPK, List<String> arrayTopic) {
        List oldFathersColl = this.publicationService.getAllFatherPKInSamePublicationComponentInstance(pubPK);
        ArrayList<NodePK> oldFathers = new ArrayList<NodePK>();
        ArrayList<NodePK> newFathers = new ArrayList<NodePK>();
        ArrayList<NodePK> remFathers = new ArrayList<NodePK>();
        for (NodePK nodePK : oldFathersColl) {
            if (arrayTopic.indexOf(nodePK.getId()) == -1) {
                remFathers.add(new NodePK(nodePK.getId(), (ResourceReference)pubPK));
            }
            oldFathers.add(nodePK);
        }
        for (String topicId : arrayTopic) {
            NodePK nodePK = new NodePK(topicId, (ResourceReference)pubPK);
            if (oldFathers.indexOf(nodePK) != -1) continue;
            newFathers.add(nodePK);
        }
        for (NodePK newFather : newFathers) {
            this.publicationService.addFather(pubPK, newFather);
        }
        for (NodePK remFather : remFathers) {
            this.publicationService.removeFather(pubPK, remFather);
        }
    }

    @Override
    public void changePubsOrder(PublicationPK pubPK, NodePK nodePK, int direction) {
        this.publicationService.changePublicationOrder(pubPK, nodePK, direction);
    }

    @Override
    public Collection<SiteDetail> getAllWebSite(String componentId) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getAllWebSite();
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public SiteDetail getWebSite(String componentId, String id) {
        SitePK pk = new SitePK(id, componentId);
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getWebSite(pk);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public List<SiteDetail> getWebSites(String componentId, List<String> ids) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getWebSites(ids);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public Collection<IconDetail> getIcons(String componentId, String id) {
        SitePK pk = new SitePK(id, componentId);
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getIcons(pk);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public String getNextId(String componentId) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getNextId();
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public Collection<IconDetail> getAllIcons(String componentId) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            return dao.getAllIcons();
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createWebSite(String componentId, SiteDetail description, UserDetail currentUser) {
        String string;
        block8: {
            Connection con = this.getConnection();
            try {
                SiteDAO dao = new SiteDAO(componentId);
                dao.createWebSite(description);
                String pubPk = this.createPublication(componentId, description);
                this.createSilverContent(con, description, currentUser.getId());
                string = pubPk;
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WebSitesRuntimeException(e);
                }
            }
            con.close();
        }
        return string;
    }

    @Override
    public void associateIcons(String componentId, String id, Collection<String> liste) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            dao.associateIcons(id, liste);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void publish(String componentId, Collection<String> liste) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            dao.publish(liste);
            for (String siteId : liste) {
                SiteDetail siteDetail = this.getWebSite(componentId, siteId);
                this.updateSilverContentVisibility(siteDetail);
            }
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void dePublish(String componentId, Collection<String> liste) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            dao.dePublish(liste);
            for (String siteId : liste) {
                SiteDetail siteDetail = this.getWebSite(componentId, siteId);
                this.updateSilverContentVisibility(siteDetail);
            }
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void deleteWebSites(String componentId, Collection<String> liste) {
        try (Connection con = this.getConnection();){
            SiteDAO dao = new SiteDAO(componentId);
            dao.deleteWebSites(liste);
            for (String siteId : liste) {
                SitePK sitePK = new SitePK(siteId, componentId);
                this.deleteSilverContent(con, sitePK);
            }
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void index(String componentId) {
        try {
            NodePK rootPK = new NodePK("0", NO_ID, componentId);
            List tree = this.nodeService.getSubTree(rootPK);
            for (NodeDetail node : tree) {
                this.nodeService.createIndex(node);
            }
            SilverpeasList publications = this.publicationService.getPublicationsByCriteria(PublicationCriteria.onComponentInstanceIds((String[])new String[]{componentId}));
            for (PublicationDetail pub : publications) {
                this.publicationService.createIndex(pub);
            }
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public void updateWebSite(String componentId, SiteDetail description) {
        try {
            SiteDAO dao = new SiteDAO(componentId);
            dao.updateWebSite(description);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    @Override
    public int getSilverObjectId(String componentId, String id) {
        int silverObjectId;
        try {
            silverObjectId = this.getWebSitesContentManager().getSilverContentId(id, componentId);
            if (silverObjectId == -1) {
                SiteDetail siteDetail = this.getWebSite(componentId, id);
                silverObjectId = this.createSilverContent(null, siteDetail, "-1");
            }
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
        return silverObjectId;
    }

    private int createSilverContent(Connection con, SiteDetail siteDetail, String creator) {
        try {
            return this.getWebSitesContentManager().createSilverContent(con, (Contribution)siteDetail, creator);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    private void deleteSilverContent(Connection con, SitePK sitePK) {
        try {
            this.getWebSitesContentManager().deleteSilverContent(con, sitePK);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    private void updateSilverContentVisibility(SiteDetail siteDetail) {
        try {
            this.getWebSitesContentManager().updateSilverContentVisibility((Contribution)siteDetail);
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }

    private WebSitesContentManager getWebSitesContentManager() {
        return this.webSitesContentManager;
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new WebSitesRuntimeException(e);
        }
    }
}

