/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs.aspect;

import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.util.annotation.AnnotationUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.web.rs.aspect.WebEntityMustBeValid;

@Interceptor
@WebEntityMustBeValid
@Priority(value=2000)
public class WebEntityValidationAspect {
    @AroundInvoke
    public <T extends WebEntity> Object processAuthorization(InvocationContext context) throws Exception {
        Map methodAnnotations = AnnotationUtil.extractMethodAnnotations((InvocationContext)context);
        if (methodAnnotations.containsKey(POST.class) || methodAnnotations.containsKey(PUT.class)) {
            for (Object parameterValue : context.getParameters()) {
                if (!(parameterValue instanceof WebEntity)) continue;
                WebEntity webEntity = (WebEntity)parameterValue;
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                Validator validator = factory.getValidator();
                Set violations = validator.validate((Object)webEntity, new Class[0]);
                if (violations.isEmpty()) continue;
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        return context.proceed();
    }
}

