/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process;

import java.lang.annotation.Annotation;
import org.silverpeas.components.gallery.GalleryContentManager;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.components.gallery.service.MediaServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.process.management.AbstractDataProcess;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractGalleryDataProcess
extends AbstractDataProcess<ProcessExecutionContext> {
    private final Media media;
    private GalleryContentManager galleryContentManager;
    private OrganizationController organizationController;

    protected AbstractGalleryDataProcess(Media media) {
        this.media = media;
    }

    public final void process(ProcessExecutionContext processExecutionContext, ProcessSession session) throws Exception {
        this.processData(processExecutionContext, session);
    }

    protected abstract void processData(ProcessExecutionContext var1, ProcessSession var2) throws Exception;

    protected GalleryService getGalleryBm() {
        return MediaServiceProvider.getMediaService();
    }

    protected Media getMedia() {
        return this.media;
    }

    protected GalleryContentManager getGalleryContentManager() {
        if (this.galleryContentManager == null) {
            this.galleryContentManager = (GalleryContentManager)ServiceProvider.getService(GalleryContentManager.class, (Annotation[])new Annotation[0]);
        }
        return this.galleryContentManager;
    }

    protected GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }

    protected PublicationTemplateManager getPublicationTemplateManager() {
        return PublicationTemplateManager.getInstance();
    }

    protected String getXMLFormName(ProcessExecutionContext context) {
        String formName = this.getOrganisationController().getComponentParameterValue(context.getComponentInstanceId(), "XMLFormName");
        if (StringUtil.isDefined((String)formName)) {
            try {
                String xmlFormShortName = formName.substring(formName.indexOf("/") + 1, formName.indexOf("."));
                this.getPublicationTemplateManager().getPublicationTemplate(context.getComponentInstanceId() + ":" + xmlFormShortName, formName);
            }
            catch (PublicationTemplateException e) {
                SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
                formName = null;
            }
        }
        return formName;
    }

    protected void createMedia(String albumId, ProcessExecutionContext context) throws Exception {
        this.getMedia().setMediaPK(new MediaPK("unknown", context.getComponentInstanceId()));
        this.getMedia().setCreator((User)context.getUser());
        this.getMedia().getMediaPK().setId(MediaDAO.saveMedia(OperationContext.fromUser((User)context.getUser()), this.getMedia()));
        MediaDAO.saveMediaPath(this.getMedia(), albumId);
    }

    protected void updateMedia(boolean updateTechnicalDataRequired, ProcessExecutionContext context) throws Exception {
        if (this.getMedia() instanceof InternalMedia && !StringUtil.isDefined((String)this.getMedia().getTitle())) {
            this.getMedia().setTitle(((InternalMedia)this.getMedia()).getFileName());
        }
        MediaDAO.saveMedia(OperationContext.fromUser((User)context.getUser()).setUpdatingInCaseOfCreation(!updateTechnicalDataRequired), this.getMedia());
    }

    protected OrganizationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganizationControllerProvider.getOrganisationController();
        }
        return this.organizationController;
    }
}

