/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.prefetch;

import java.util.LinkedList;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheWarming {
    private static final Logger LOG = LoggerFactory.getLogger(CacheWarming.class);
    private final DocumentStore store;

    public CacheWarming(DocumentStore store) {
        this.store = store;
    }

    public void prefetch(@NotNull Iterable<String> paths, @NotNull DocumentNodeState rootState) {
        Objects.requireNonNull(paths);
        Objects.requireNonNull(rootState);
        LinkedList<String> ids = new LinkedList<String>();
        for (String aPath : paths) {
            if (this.isCached(aPath, rootState)) continue;
            String id = Utils.getIdFromPath(aPath);
            ids.add(id);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prefetch {} nodes", (Object)ids.size());
        }
        this.store.prefetch(Collection.NODES, ids);
    }

    private boolean isCached(String path, DocumentNodeState rootState) {
        if (rootState == null) {
            return false;
        }
        DocumentNodeState n = rootState;
        for (String e : PathUtils.elements((String)path)) {
            if (!n.exists() || n.hasNoChildren()) break;
            if ((n = n.getChildIfCached(e)) != null) continue;
            return false;
        }
        return true;
    }
}

