/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDecoder
extends MessageToMessageDecoder<String> {
    private static final Logger log = LoggerFactory.getLogger(RequestDecoder.class);

    protected void decode(ChannelHandlerContext ctx, String msg, List<Object> out) throws Exception {
        String request = Messages.extractMessageFrom(msg);
        if (request == null) {
            log.debug("Received invalid message {}, ignoring", (Object)msg);
            ctx.fireChannelRead((Object)msg);
        } else if (request.startsWith("b.")) {
            log.debug("Parsed 'get blob' request");
            out.add(new GetBlobRequest(Messages.extractClientFrom(msg), request.substring("b.".length())));
        } else if (request.equalsIgnoreCase("h")) {
            log.debug("Parsed 'get head' message");
            out.add(new GetHeadRequest(Messages.extractClientFrom(msg)));
        } else if (request.startsWith("s.")) {
            log.debug("Parsed 'get segment' message");
            out.add(new GetSegmentRequest(Messages.extractClientFrom(msg), request.substring("s.".length())));
        } else if (request.startsWith("r.")) {
            log.debug("Parsed 'get references' message");
            out.add(new GetReferencesRequest(Messages.extractClientFrom(msg), request.substring("r.".length())));
        } else {
            log.debug("Received unrecognizable message {}, dropping", (Object)msg);
        }
    }
}

