/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.service;

import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.model.Reservation;
import org.silverpeas.components.resourcesmanager.model.ReservedResource;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.repository.ReservationRepository;
import org.silverpeas.components.resourcesmanager.repository.ReservedResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceValidatorRepository;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;

@Service
@Transactional
public class ReservationService {
    @Inject
    private ReservationRepository repository;
    @Inject
    private ReservedResourceRepository reservedResourceRepository;
    @Inject
    private ResourceRepository resourceRepository;
    @Inject
    private ResourceValidatorRepository resourceValidatorRepository;

    public void createReservation(Reservation reservation, List<Long> resourceIds) {
        reservation.setStatus("V");
        this.repository.save((IdentifiableEntity)reservation);
        for (Long resourceId : resourceIds) {
            ReservedResource reservedResource = new ReservedResource();
            reservedResource.setReservedResourceId(Long.toString(resourceId), reservation.getId());
            Resource resource = (Resource)this.resourceRepository.getById(Long.toString(resourceId));
            if (!resource.getManagers().isEmpty()) {
                if (this.resourceValidatorRepository.getResourceValidator(resourceId, Long.parseLong(reservation.getUserId())) == null) {
                    reservedResource.setStatus("A");
                } else {
                    reservedResource.setStatus("V");
                }
            } else {
                reservedResource.setStatus(reservation.getStatus());
            }
            this.reservedResourceRepository.save((IdentifiableEntity)reservedResource);
        }
        reservation.setStatus(this.computeReservationStatus(reservation));
        this.repository.save((IdentifiableEntity)reservation);
    }

    public String computeReservationStatus(Reservation reservation) {
        boolean validated = true;
        List<ReservedResource> reservedResources = this.reservedResourceRepository.findAllReservedResourcesForReservation(reservation.getIdAsLong());
        for (ReservedResource reservedResource : reservedResources) {
            String status = reservedResource.getStatus();
            if ("A".equals(status)) {
                validated = false;
            }
            if (!"R".equals(status)) continue;
            return "R";
        }
        if (!validated) {
            return "A";
        }
        return "V";
    }

    public void updateReservation(Reservation reservation) {
        this.repository.saveAndFlush((IdentifiableEntity)reservation);
    }

    public Reservation getReservation(long id) {
        return (Reservation)this.repository.getById(Long.toString(id));
    }

    public void deleteReservation(long id) {
        this.reservedResourceRepository.deleteAllReservedResourcesForReservation(id);
        this.repository.deleteById(new String[]{Long.toString(id)});
    }

    public List<Reservation> findAllReservations(String instanceId) {
        return this.repository.findAllReservations(instanceId);
    }

    public List<Reservation> findAllReservationsForUser(String instanceId, Integer userId) {
        return this.repository.findAllReservationsForUser(instanceId, userId);
    }

    public List<Reservation> findAllReservationsForValidation(String instanceId, Long userId, String startPeriod, String endPeriod) {
        return this.repository.findAllReservationsForValidation(instanceId, userId, startPeriod, endPeriod);
    }

    public List<Reservation> findAllReservationsInRange(String instanceId, Integer userId, String startPeriod, String endPeriod) {
        if (userId == null) {
            return this.repository.findAllReservationsInRange(instanceId, startPeriod, endPeriod);
        }
        return this.repository.findAllReservationsForUserInRange(instanceId, userId, startPeriod, endPeriod);
    }

    public List<Reservation> findAllReservationsForCategoryInRange(String instanceId, Integer userId, Long categoryId, String startPeriod, String endPeriod) {
        if (userId == null) {
            return this.repository.findAllReservationsForCategoryInRange(instanceId, categoryId, startPeriod, endPeriod);
        }
        return this.repository.findAllReservationsForUserAndCategoryInRange(instanceId, userId, categoryId, startPeriod, endPeriod);
    }

    public List<Reservation> findAllReservationsForResourceInRange(String instanceId, Integer userId, Long resourceId, String startPeriod, String endPeriod) {
        if (userId == null) {
            return this.repository.findAllReservationsForResourceInRange(instanceId, resourceId, startPeriod, endPeriod);
        }
        return this.repository.findAllReservationsForUserAndResourceInRange(instanceId, userId, resourceId, startPeriod, endPeriod);
    }
}

