/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.index;

import java.text.ParseException;
import java.util.Collection;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.components.questionreply.model.Reply;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
public class QuestionIndexer {
    public void createIndex(Question question, Collection<Reply> replies) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(question.getInstanceId(), "Question", question.getPK().getId()));
        indexEntry.setTitle(question.getTitle());
        indexEntry.setPreview(question.getContent());
        try {
            indexEntry.setCreationDate(DateUtil.parse((String)question.getCreationDate()));
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        indexEntry.setCreationUser(question.getCreatorId());
        indexEntry.addTextContent(question.getContent());
        indexEntry.addTextContent(question.getTitle());
        for (Reply reply : replies) {
            indexEntry.addTextContent(reply.getTitle());
            indexEntry.addTextContent(reply.loadWysiwygContent());
        }
        IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
    }

    public void updateIndex(Question question, Collection<Reply> replies) {
        this.deleteIndex(question);
        this.createIndex(question, replies);
    }

    public void deleteIndex(Question question) {
        IndexEntryKey indexEntry = new IndexEntryKey(question.getInstanceId(), "Question", question.getPK().getId());
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }
}

