/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.Collection;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.uri.IRIResolver;
import org.odftoolkit.odfdom.pkg.rdfa.JenaSink;
import org.odftoolkit.odfdom.pkg.rdfa.RDFaParser;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractor;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractorImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXRDFaParser
extends RDFaParser {
    public static SAXRDFaParser createInstance(JenaSink sink) {
        URIExtractorImpl extractor = new URIExtractorImpl((Resolver)new IRIResolver(), true);
        sink.setExtractor(extractor);
        return new SAXRDFaParser(sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), extractor);
    }

    private SAXRDFaParser(JenaSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor) {
        super(sink, outputFactory, eventFactory, extractor);
    }

    public void emitTriples(String subj, Collection<String> props, String obj) {
        for (String prop : props) {
            this.sink.addObject(subj, prop, obj);
        }
    }

    public void emitTriplesPlainLiteral(String subj, Collection<String> props, String lex, String language) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, language, null);
        }
    }

    public void emitTriplesDatatypeLiteral(String subj, Collection<String> props, String lex, String datatype) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, null, datatype);
        }
    }

    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        if (this.locator.getSystemId() != null) {
            this.setBase(arg0.getSystemId());
        }
    }

    public void startDocument() throws SAXException {
        this.sink.start();
    }

    public void endDocument() throws SAXException {
        this.sink.end();
        this.sink.setContext(this.context);
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.context.setNamespaceURI(arg0, arg1);
        this.extractor.setNamespaceURI(arg0, arg1);
        this.sink.addPrefix(arg0, arg1);
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void startElement(String arg0, String localname, String qname, Attributes arg3) throws SAXException {
        super.beginRDFaElement(arg0, localname, qname, arg3);
    }

    public void endElement(String arg0, String localname, String qname) throws SAXException {
        super.endRDFaElement(arg0, localname, qname);
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        super.writeCharacters(String.valueOf(arg0, arg1, arg2));
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.literalCollector.isCollecting()) {
            Characters e = this.eventFactory.createIgnorableSpace(String.valueOf(arg0, arg1, arg2));
            this.literalCollector.handleEvent((XMLEvent)e);
        }
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public void skippedEntity(String arg0) throws SAXException {
    }
}

