/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.util.Map;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapFactory {
    static final Logger LOG = LoggerFactory.getLogger(MapFactory.class);
    private int openCount = 1;

    synchronized int reopenStoreIfNeeded(int oldOpenCount) {
        if (oldOpenCount == this.openCount) {
            this.closeStore();
            ++this.openCount;
            this.openStore();
        }
        return this.openCount;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    abstract void openStore();

    abstract void closeStore();

    abstract <K, V> Map<K, V> openMap(String var1, MVMap.Builder<K, V> var2);

    abstract long getFileSize();
}

