/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.guava.common.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.annotations.Beta;
import org.apache.jackrabbit.guava.common.annotations.GwtIncompatible;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.io.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

