/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadConcernLevel;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.MoreObjects;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;

public class MongoConnection {
    private static final int DEFAULT_MAX_WAIT_TIME = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final int DEFAULT_HEARTBEAT_FREQUENCY_MS = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final WriteConcern WC_UNKNOWN = new WriteConcern("unknown");
    private static final Set<ReadConcernLevel> REPLICA_RC = ImmutableSet.of((Object)ReadConcernLevel.MAJORITY, (Object)ReadConcernLevel.LINEARIZABLE);
    private final MongoClientURI mongoURI;
    private final MongoClient mongo;

    public MongoConnection(String uri) throws MongoException {
        this(uri, MongoConnection.getDefaultBuilder());
    }

    public MongoConnection(String uri, MongoClientOptions.Builder builder) throws MongoException {
        this.mongoURI = new MongoClientURI(uri, builder);
        this.mongo = new MongoClient(this.mongoURI);
    }

    public MongoConnection(String host, int port, String database) throws MongoException {
        this("mongodb://" + host + ":" + port + "/" + database);
    }

    public MongoConnection(String uri, MongoClient client) {
        this.mongoURI = new MongoClientURI(uri, MongoConnection.getDefaultBuilder());
        this.mongo = client;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }

    public MongoDatabase getDatabase() {
        return this.mongo.getDatabase(this.mongoURI.getDatabase());
    }

    public MongoDatabase getDatabase(@NotNull String name) {
        return this.mongo.getDatabase(name);
    }

    public String getDBName() {
        return this.mongoURI.getDatabase();
    }

    public void close() {
        this.mongo.close();
    }

    public static MongoClientOptions.Builder getDefaultBuilder() {
        return new MongoClientOptions.Builder().description("MongoConnection for Oak DocumentMK").maxWaitTime(DEFAULT_MAX_WAIT_TIME).heartbeatFrequency(DEFAULT_HEARTBEAT_FREQUENCY_MS).threadsAllowedToBlockForConnectionMultiplier(100);
    }

    public static String toString(MongoClientOptions opts) {
        return MoreObjects.toStringHelper((Object)opts).add("connectionsPerHost", opts.getConnectionsPerHost()).add("connectTimeout", opts.getConnectTimeout()).add("socketTimeout", opts.getSocketTimeout()).add("socketKeepAlive", opts.isSocketKeepAlive()).add("maxWaitTime", opts.getMaxWaitTime()).add("heartbeatFrequency", opts.getHeartbeatFrequency()).add("threadsAllowedToBlockForConnectionMultiplier", opts.getThreadsAllowedToBlockForConnectionMultiplier()).add("readPreference", (Object)opts.getReadPreference().getName()).add("writeConcern", (Object)opts.getWriteConcern()).toString();
    }

    public static boolean hasWriteConcern(@NotNull String uri) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.writeConcern(WC_UNKNOWN);
        WriteConcern wc = new MongoClientURI((String)Preconditions.checkNotNull((Object)uri), builder).getOptions().getWriteConcern();
        return !WC_UNKNOWN.equals((Object)wc);
    }

    public static boolean hasReadConcern(@NotNull String uri) {
        ReadConcern rc = new MongoClientURI((String)Preconditions.checkNotNull((Object)uri)).getOptions().getReadConcern();
        return MongoConnection.readConcernLevel(rc) != null;
    }

    public static WriteConcern getDefaultWriteConcern(@NotNull MongoClient client) {
        WriteConcern w = client.getReplicaSetStatus() != null ? WriteConcern.MAJORITY : WriteConcern.ACKNOWLEDGED;
        return w;
    }

    public static ReadConcern getDefaultReadConcern(@NotNull MongoClient client, @NotNull MongoDatabase db) {
        ReadConcern r = ((MongoClient)Preconditions.checkNotNull((Object)client)).getReplicaSetStatus() != null && MongoConnection.isMajorityWriteConcern(db) ? ReadConcern.MAJORITY : ReadConcern.LOCAL;
        return r;
    }

    public static boolean isMajorityWriteConcern(@NotNull MongoDatabase db) {
        return WriteConcern.MAJORITY.getWString().equals(db.getWriteConcern().getWObject());
    }

    public static boolean isSufficientWriteConcern(@NotNull MongoClient client, @NotNull WriteConcern wc) {
        int w;
        Object wObj = ((WriteConcern)Preconditions.checkNotNull((Object)wc)).getWObject();
        if (wObj instanceof Number) {
            w = ((Number)wObj).intValue();
        } else if (wObj == null) {
            w = 1;
        } else if (WriteConcern.MAJORITY.getWString().equals(wObj)) {
            w = 2;
        } else {
            throw new IllegalArgumentException("Unknown write concern: " + wc);
        }
        if (client.getReplicaSetStatus() != null) {
            return w >= 2;
        }
        return w >= 1;
    }

    public static boolean isSufficientReadConcern(@NotNull MongoClient client, @NotNull ReadConcern rc) {
        ReadConcernLevel r = MongoConnection.readConcernLevel((ReadConcern)Preconditions.checkNotNull((Object)rc));
        if (client.getReplicaSetStatus() == null) {
            return true;
        }
        return REPLICA_RC.contains(r);
    }

    public static ReadConcernLevel readConcernLevel(ReadConcern readConcern) {
        if (readConcern.isServerDefault()) {
            return null;
        }
        return ReadConcernLevel.fromString((String)readConcern.asDocument().getString((Object)"level").getValue());
    }
}

