/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCOptions;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.util.TimeInterval;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionGCRecommendations {
    private static final Logger log = LoggerFactory.getLogger(VersionGCRecommendations.class);
    private final VersionGCSupport vgc;
    private final GCMonitor gcmon;
    final boolean ignoreDueToCheckPoint;
    final TimeInterval scope;
    final long maxCollect;
    final long deleteCandidateCount;
    final long lastOldestTimestamp;
    final long originalCollectLimit;
    private final long precisionMs;
    final long suggestedIntervalMs;
    private final boolean scopeIsComplete;

    public VersionGCRecommendations(long maxRevisionAgeMs, Checkpoints checkpoints, Clock clock, VersionGCSupport vgc, VersionGCOptions options, GCMonitor gcMonitor) {
        Revision checkpoint;
        long oldestPossible;
        boolean ignoreDueToCheckPoint = false;
        long deletedOnceCount = 0L;
        long collectLimit = options.collectLimit;
        this.vgc = vgc;
        this.gcmon = gcMonitor;
        this.originalCollectLimit = options.collectLimit;
        TimeInterval keep = new TimeInterval(clock.getTime() - maxRevisionAgeMs, Long.MAX_VALUE);
        Map<String, Long> settings = this.getLongSettings();
        this.lastOldestTimestamp = settings.get("lastOldestTimeStamp");
        if (this.lastOldestTimestamp == 0L) {
            log.debug("No lastOldestTimestamp found, querying for the oldest deletedOnce candidate");
            oldestPossible = vgc.getOldestDeletedOnceTimestamp(clock, options.precisionMs) - 1L;
            log.debug("lastOldestTimestamp found: {}", (Object)Utils.timestampToString(oldestPossible));
        } else {
            oldestPossible = this.lastOldestTimestamp - 1L;
        }
        TimeInterval scope = new TimeInterval(oldestPossible, Long.MAX_VALUE);
        scope = scope.notLaterThan(keep.fromMs);
        long suggestedIntervalMs = settings.get("recommendedIntervalMs");
        if (suggestedIntervalMs > 0L) {
            if ((suggestedIntervalMs = Math.max(suggestedIntervalMs, options.precisionMs)) < scope.getDurationMs()) {
                scope = scope.startAndDuration(suggestedIntervalMs);
                log.debug("previous runs recommend a {} sec duration, scope now {}", (Object)TimeUnit.MILLISECONDS.toSeconds(suggestedIntervalMs), (Object)scope);
            }
        } else if (scope.getDurationMs() <= options.precisionMs) {
            log.debug("scope <= precision ({} ms)", (Object)options.precisionMs);
        } else {
            try {
                long preferredLimit = Math.min(collectLimit, (long)Math.ceil((double)options.overflowToDiskThreshold * 0.95));
                deletedOnceCount = vgc.getDeletedOnceCount();
                if (deletedOnceCount > preferredLimit) {
                    double chunks = (double)deletedOnceCount / (double)preferredLimit;
                    suggestedIntervalMs = (long)Math.floor((double)(scope.getDurationMs() + maxRevisionAgeMs) / chunks);
                    if (suggestedIntervalMs < scope.getDurationMs()) {
                        scope = scope.startAndDuration(suggestedIntervalMs);
                        log.debug("deletedOnce candidates: {} found, {} preferred, scope now {}", new Object[]{deletedOnceCount, preferredLimit, scope});
                    }
                }
            }
            catch (UnsupportedOperationException ex) {
                log.debug("check on upper bounds of delete candidates not supported, skipped");
            }
        }
        if ((checkpoint = checkpoints.getOldestRevisionToKeep()) != null && scope.endsAfter(checkpoint.getTimestamp())) {
            TimeInterval minimalScope = scope.startAndDuration(options.precisionMs);
            if (minimalScope.endsAfter(checkpoint.getTimestamp())) {
                log.warn("Ignoring RGC run because a valid checkpoint [{}] exists inside minimal scope {}.", (Object)checkpoint.toReadableString(), (Object)minimalScope);
                ignoreDueToCheckPoint = true;
            } else {
                scope = scope.notLaterThan(checkpoint.getTimestamp() - 1L);
                log.debug("checkpoint at [{}] found, scope now {}", (Object)Utils.timestampToString(checkpoint.getTimestamp()), (Object)scope);
            }
        }
        if (scope.getDurationMs() <= options.precisionMs) {
            collectLimit = 0L;
            log.debug("time interval <= precision ({} ms), disabling collection limits", (Object)options.precisionMs);
        }
        this.precisionMs = options.precisionMs;
        this.ignoreDueToCheckPoint = ignoreDueToCheckPoint;
        this.scope = scope;
        this.scopeIsComplete = scope.toMs >= keep.fromMs;
        this.maxCollect = collectLimit;
        this.suggestedIntervalMs = suggestedIntervalMs;
        this.deleteCandidateCount = deletedOnceCount;
    }

    public void evaluate(VersionGarbageCollector.VersionGCStats stats) {
        if (stats.limitExceeded) {
            long nextDuration = Math.max(this.precisionMs, this.scope.getDurationMs() / 2L);
            this.gcmon.info("Limit {} documents exceeded, reducing next collection interval to {} seconds", new Object[]{this.maxCollect, TimeUnit.MILLISECONDS.toSeconds(nextDuration)});
            this.setLongSetting("recommendedIntervalMs", nextDuration);
            stats.needRepeat = true;
        } else if (!stats.canceled && !stats.ignoredGCDueToCheckPoint) {
            this.setLongSetting("lastOldestTimeStamp", this.scope.toMs);
            int count = stats.deletedDocGCCount - stats.deletedLeafDocGCCount;
            double allowedFraction = 0.66;
            double usedFraction = this.maxCollect <= 0L ? (double)count / (double)this.originalCollectLimit : (double)count / (double)this.maxCollect;
            if (this.scope.getDurationMs() == this.suggestedIntervalMs) {
                if (usedFraction < allowedFraction) {
                    long nextDuration = (long)Math.ceil((double)this.suggestedIntervalMs * 1.5);
                    log.debug("successful run using {}% of limit, raising recommended interval to {} seconds", (Object)((double)Math.round(usedFraction * 1000.0) / 10.0), (Object)TimeUnit.MILLISECONDS.toSeconds(nextDuration));
                    this.setLongSetting("recommendedIntervalMs", nextDuration);
                } else {
                    log.debug("not increasing limit: collected {} documents ({}% >= {}% limit)", new Object[]{count, usedFraction, allowedFraction});
                }
            } else {
                log.debug("successful run not following recommendations, keeping them");
            }
            stats.needRepeat = !this.scopeIsComplete;
        }
    }

    private Map<String, Long> getLongSettings() {
        Document versionGCDoc = this.vgc.getDocumentStore().find(Collection.SETTINGS, "versionGC", 0);
        HashMap settings = Maps.newHashMap();
        settings.put("lastOldestTimeStamp", 0L);
        settings.put("recommendedIntervalMs", 0L);
        if (versionGCDoc != null) {
            for (String k : versionGCDoc.keySet()) {
                Object value = versionGCDoc.get(k);
                if (!(value instanceof Number)) continue;
                settings.put(k, ((Number)value).longValue());
            }
        }
        return settings;
    }

    private void setLongSetting(String propName, long val) {
        UpdateOp updateOp = new UpdateOp("versionGC", true);
        updateOp.set(propName, val);
        this.vgc.getDocumentStore().createOrUpdate(Collection.SETTINGS, updateOp);
    }
}

