/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.jetbrains.annotations.NotNull;

final class Range {
    final Revision high;
    final Revision low;
    final int height;

    Range(@NotNull Revision high, @NotNull Revision low, int height) {
        this.high = (Revision)Preconditions.checkNotNull((Object)high);
        this.low = (Revision)Preconditions.checkNotNull((Object)low);
        this.height = height;
        Preconditions.checkArgument((high.getClusterId() == low.getClusterId() ? 1 : 0) != 0, (Object)"Revisions from have the same clusterId");
        Preconditions.checkArgument((high.compareRevisionTime(low) >= 0 ? 1 : 0) != 0, (String)"High Revision must be later than low Revision, high=%s low=%s", (Object)high, (Object)low);
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0);
    }

    @NotNull
    static Range fromEntry(Revision rev, String value) {
        int height;
        Revision low;
        int idx = value.indexOf(47);
        if (idx == -1) {
            low = Revision.fromString(value);
            height = 0;
        } else {
            low = Revision.fromString(value.substring(0, idx));
            height = Integer.parseInt(value.substring(idx + 1));
        }
        return new Range(rev, low, height);
    }

    @NotNull
    String getLowValue() {
        return this.low + "/" + this.height;
    }

    boolean includes(@NotNull Revision r) {
        return this.high.getClusterId() == r.getClusterId() && this.high.compareRevisionTime(r) >= 0 && this.low.compareRevisionTime(r) <= 0;
    }

    int getHeight() {
        return this.height;
    }

    public String toString() {
        return this.high.toString() + " : " + this.low.toString() + "/" + this.height;
    }

    public int hashCode() {
        return this.high.hashCode() ^ this.low.hashCode() ^ this.height;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return this.high.equals(other.high) && this.low.equals(other.low) && this.height == other.height;
        }
        return false;
    }
}

