/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;

class JcrAllCommitHook
implements PostValidationHook,
PrivilegeConstants {
    JcrAllCommitHook() {
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) {
        NodeBuilder builder = after.builder();
        after.compareAgainstBaseState(before, (NodeStateDiff)new PrivilegeDiff(builder));
        return builder.getNodeState();
    }

    public String toString() {
        return "JcrAllCommitHook";
    }

    private static final class PrivilegeDiff
    extends DefaultNodeStateDiff {
        private static final String ROOT_PATH = "";
        private final String path;
        private final NodeBuilder nodeBuilder;

        private PrivilegeDiff(@NotNull NodeBuilder nodeBuilder) {
            this.path = ROOT_PATH;
            this.nodeBuilder = nodeBuilder;
        }

        private PrivilegeDiff(@NotNull PrivilegeDiff parentDiff, @NotNull String nodeName, @NotNull NodeBuilder nodeBuilder) {
            this.path = parentDiff.path + "/" + nodeName;
            this.nodeBuilder = nodeBuilder;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            if ("/jcr:system/rep:privileges".equals(this.path)) {
                if (!"jcr:all".equals(name)) {
                    this.updateJcrAll(name, after);
                }
            } else {
                String p = this.path + "/" + name;
                if (Text.isDescendantOrEqual((String)p, (String)"/jcr:system/rep:privileges")) {
                    EmptyNodeState.compareAgainstEmptyState((NodeState)after, (NodeStateDiff)new PrivilegeDiff(this, name, this.nodeBuilder.child(name)));
                }
            }
            return true;
        }

        private void updateJcrAll(@NotNull String name, @NotNull NodeState after) {
            NodeBuilder jcrAll = this.nodeBuilder.child("jcr:all");
            PropertyState aggregates = jcrAll.getProperty("rep:aggregates");
            PropertyBuilder propertyBuilder = aggregates == null ? PropertyBuilder.array((Type)Type.NAME, (String)"rep:aggregates") : PropertyBuilder.copy((Type)Type.NAME, (PropertyState)aggregates);
            if (!propertyBuilder.hasValue((Object)name)) {
                propertyBuilder.addValue((Object)name);
                jcrAll.setProperty(propertyBuilder.getPropertyState());
            }
            if (!after.hasProperty("rep:aggregates")) {
                PrivilegeBits bits = PrivilegeBits.getInstance((PropertyState)after.getProperty("rep:bits"));
                PrivilegeBits all = PrivilegeBits.getInstance((PropertyState)jcrAll.getProperty("rep:bits"));
                jcrAll.setProperty(PrivilegeBits.getInstance((PrivilegeBits[])new PrivilegeBits[]{all}).add(bits).asPropertyState("rep:bits"));
            }
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (ROOT_PATH.equals(this.path) || Text.isDescendant((String)this.path, (String)"/jcr:system/rep:privileges")) {
                after.compareAgainstBaseState(before, (NodeStateDiff)new PrivilegeDiff(this, name, this.nodeBuilder.child(name)));
            }
            return true;
        }
    }
}

