/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class ChildNodeImpl
extends ConstraintImpl {
    private final String selectorName;
    private final String parentPath;
    private SelectorImpl selector;

    public ChildNodeImpl(String selectorName, String parentPath) {
        this.selectorName = selectorName;
        this.parentPath = parentPath;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "ischildnode(" + this.quote(this.selectorName) + ", " + this.quote(this.parentPath) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public boolean evaluate() {
        String p = this.selector.currentPath();
        String local = this.getLocalPath(p);
        if (local == null) {
            return false;
        }
        if (PathUtils.denotesRoot((String)local)) {
            return false;
        }
        String path = this.normalizePath(this.parentPath);
        return PathUtils.getParentPath((String)local).equals(path);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (this.selector.equals(f.getSelector())) {
            String path = this.normalizePath(this.parentPath);
            f.restrictPath(path, Filter.PathRestriction.DIRECT_CHILDREN);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public AstElement copyOf() {
        return new ChildNodeImpl(this.selectorName, this.parentPath);
    }
}

