/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.reference;

import java.util.ArrayList;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.Cursors;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class ReferenceIndex
implements QueryIndex {
    private static final double COST = 1.0;
    private final MountInfoProvider mountInfoProvider;

    ReferenceIndex() {
        this(Mounts.defaultMountInfoProvider());
    }

    ReferenceIndex(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    public double getMinimumCost() {
        return 1.0;
    }

    public String getIndexName() {
        return "reference";
    }

    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() != null) {
            return Double.POSITIVE_INFINITY;
        }
        if (filter.containsNativeConstraint()) {
            return Double.POSITIVE_INFINITY;
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (!ReferenceIndex.isEqualityRestrictionOnType(pr, 9) && !ReferenceIndex.isEqualityRestrictionOnType(pr, 10)) continue;
            return 1.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    private static boolean isEqualityRestrictionOnType(Filter.PropertyRestriction pr, int propertyType) {
        if (pr.propertyType != propertyType) {
            return false;
        }
        return pr.first != null && pr.first == pr.last;
    }

    public Cursor query(Filter filter, NodeState root) {
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (ReferenceIndex.isEqualityRestrictionOnType(pr, 9)) {
                String uuid = (String)pr.first.getValue(Type.STRING);
                String name = pr.propertyName;
                return this.lookup(root, uuid, name, ":references", filter);
            }
            if (!ReferenceIndex.isEqualityRestrictionOnType(pr, 10)) continue;
            String uuid = (String)pr.first.getValue(Type.STRING);
            String name = pr.propertyName;
            return this.lookup(root, uuid, name, ":weakreferences", filter);
        }
        return Cursors.newPathCursor(new ArrayList<String>(), filter.getQueryLimits());
    }

    private Cursor lookup(NodeState root, String uuid, final String name, String index, Filter filter) {
        NodeState indexRoot = root.getChildNode("oak:index").getChildNode("reference");
        if (!indexRoot.exists()) {
            return Cursors.newPathCursor(new ArrayList<String>(), filter.getQueryLimits());
        }
        ArrayList iterables = Lists.newArrayList();
        for (IndexStoreStrategy s : ReferenceIndex.getStrategies(indexRoot, this.mountInfoProvider, index)) {
            iterables.add(s.query(filter, index + "(" + uuid + ")", indexRoot, (Iterable<String>)ImmutableSet.of((Object)uuid)));
        }
        Iterable paths = Iterables.concat((Iterable)iterables);
        if (!"*".equals(name)) {
            paths = Iterables.filter((Iterable)paths, (Predicate)new Predicate<String>(){

                public boolean apply(String path) {
                    return name.equals(PathUtils.getName((String)path));
                }
            });
        }
        paths = Iterables.transform((Iterable)paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return PathUtils.getParentPath((String)path);
            }
        });
        return Cursors.newPathCursor(paths, filter.getQueryLimits());
    }

    private static Set<IndexStoreStrategy> getStrategies(NodeState definition, MountInfoProvider mountInfoProvider, String index) {
        return Multiplexers.getStrategies(false, mountInfoProvider, definition, index);
    }

    public String getPlan(Filter filter, NodeState root) {
        StringBuilder buff = new StringBuilder("reference");
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            if (pr.propertyType == 9) {
                buff.append(" PROPERTY([");
                buff.append(pr.propertyName);
                buff.append("], 'Reference') = ");
                buff.append((String)pr.first.getValue(Type.STRING));
                return buff.toString();
            }
            if (pr.propertyType != 10) continue;
            buff.append(" PROPERTY([");
            buff.append(pr.propertyName);
            buff.append("], 'WeakReference') = ");
            buff.append((String)pr.first.getValue(Type.STRING));
            return buff.toString();
        }
        return buff.toString();
    }
}

