/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.api.jmx;

import org.apache.jackrabbit.oak.api.jmx.Description;
import org.apache.jackrabbit.oak.api.jmx.Name;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface QueryEngineSettingsMBean {
    public static final String TYPE = "QueryEngineSettings";

    @Description(value="Get the limit on how many nodes a query may read at most into memory, for \"order by\" and \"distinct\" queries. If this limit is exceeded, the query throws an exception.")
    public long getLimitInMemory();

    public void setLimitInMemory(long var1);

    @Description(value="Get the limit on how many nodes a query may read at most (raw read operations, including skipped nodes). If this limit is exceeded, the query throws an exception.")
    public long getLimitReads();

    public void setLimitReads(long var1);

    public void setPrefetchCount(int var1);

    @Description(value="Get the prefetch count. This is the number of entries pre-fetched from the node store at a time.")
    public int getPrefetchCount();

    public void setAutoOptionsMappingJson(String var1);

    @Description(value="Get the automatic query options mapping, in Json format.")
    public String getAutoOptionsMappingJson();

    @Description(value="Whether queries that don't use an index will fail (throw an exception). The default is false.")
    public boolean getFailTraversal();

    public void setFailTraversal(boolean var1);

    @Description(value="Whether the query result size should return an estimation for large queries.")
    public boolean isFastQuerySize();

    public void setFastQuerySize(boolean var1);

    public String getStrictPathRestriction();

    @Description(value="Set path restriction: Expected value is either of ENABLE/DISABLE/WARN.   ENABLE: enable path restriction- Index won't be used if index definition path restrictions are not compatible with query's path restriction.  DISABLE: path restrictions are not taken into account while querying.  WARN: path restrictions are not taken into account but a warning will be logged if query path restrictions are not compatible with index path restrictions.")
    public void setStrictPathRestriction(@Name(value="pathRestriction") String var1);

    @Description(value="Set or remove a query validator pattern.")
    public void setQueryValidatorPattern(@Description(value="the key") @Name(value="key") String var1, @Description(value="the regular expression pattern (empty to remove the pattern)") @Name(value="pattern") String var2, @Description(value="a comment") @Name(value="comment") String var3, @Description(value="whether matching queries should fail (true) or just log a warning (false)") @Name(value="failQuery") boolean var4);

    @Description(value="Get the query validator data as a JSON string.")
    public String getQueryValidatorJson();

    @Description(value="Set or remove Java package / fully qualified class names to ignore in Call Trace analysis")
    public void setIgnoredClassNamesInCallTrace(@Description(value="package or fully qualified class names") @Name(value="class names") @NotNull String[] var1);

    @NotNull
    public String[] getIgnoredClassNamesInCallTrace();
}

