/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.Buffer;

abstract class FileAccess {
    FileAccess() {
    }

    abstract boolean isMemoryMapped();

    abstract int length() throws IOException;

    abstract Buffer read(int var1, int var2) throws IOException;

    abstract void close() throws IOException;

    static class RandomOffHeap
    extends Random {
        RandomOffHeap(RandomAccessFile file) {
            super(file);
        }

        @Override
        public synchronized Buffer read(int position, int length) throws IOException {
            Buffer entry = Buffer.allocateDirect((int)length);
            if (entry.readFully(this.channel, position) < length) {
                throw new EOFException();
            }
            entry.flip();
            return entry;
        }
    }

    static class Random
    extends FileAccess {
        private final RandomAccessFile file;
        protected final FileChannel channel;

        Random(RandomAccessFile file) {
            this.file = file;
            this.channel = file.getChannel();
        }

        @Override
        boolean isMemoryMapped() {
            return false;
        }

        @Override
        public synchronized int length() throws IOException {
            long length = this.file.length();
            Preconditions.checkState((length < Integer.MAX_VALUE ? 1 : 0) != 0);
            return (int)length;
        }

        @Override
        public synchronized Buffer read(int position, int length) throws IOException {
            Buffer entry = Buffer.allocate((int)length);
            if (entry.readFully(this.channel, position) < length) {
                throw new EOFException();
            }
            entry.flip();
            return entry;
        }

        @Override
        public synchronized void close() throws IOException {
            this.file.close();
        }
    }

    static class Mapped
    extends FileAccess {
        private final RandomAccessFile file;
        private Buffer buffer;

        Mapped(RandomAccessFile file) throws IOException {
            this.file = file;
            this.buffer = Buffer.map((FileChannel)file.getChannel(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY, (long)0L, (long)file.length());
        }

        @Override
        boolean isMemoryMapped() {
            return true;
        }

        @Override
        public int length() {
            return this.buffer.remaining();
        }

        @Override
        public Buffer read(int position, int length) {
            Buffer entry = this.buffer.asReadOnlyBuffer();
            entry.position(entry.position() + position);
            entry.limit(entry.position() + length);
            return entry.slice();
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
            this.file.close();
        }
    }
}

