/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

class PrefixedGCListener
implements GCListener {
    private final GCListener listener;
    private final AtomicInteger counter;

    PrefixedGCListener(GCListener listener, AtomicInteger counter) {
        this.listener = listener;
        this.counter = counter;
    }

    private String prefixed(String message) {
        return String.format("TarMK GC #%s: %s", this.counter, message);
    }

    @Override
    public void compactionSucceeded(@NotNull GCGeneration newGeneration) {
        this.listener.compactionSucceeded(newGeneration);
    }

    @Override
    public void compactionFailed(@NotNull GCGeneration failedGeneration) {
        this.listener.compactionFailed(failedGeneration);
    }

    public void info(String message, Object ... arguments) {
        this.listener.info(this.prefixed(message), arguments);
    }

    public void warn(String message, Object ... arguments) {
        this.listener.warn(this.prefixed(message), arguments);
    }

    public void error(String message, Exception exception) {
        this.listener.error(this.prefixed(message), exception);
    }

    public void skipped(String reason, Object ... arguments) {
        this.listener.skipped(this.prefixed(reason), arguments);
    }

    public void compacted() {
        this.listener.compacted();
    }

    public void cleaned(long reclaimedSize, long currentSize) {
        this.listener.cleaned(reclaimedSize, currentSize);
    }

    public void updateStatus(String status) {
        this.listener.updateStatus(status);
    }
}

