/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.data.RecordIdData;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.apache.jackrabbit.oak.segment.data.SegmentDataUtils;
import org.apache.jackrabbit.oak.segment.data.StringData;

class SegmentDataV12
implements SegmentData {
    private static final int HEADER_SIZE = 32;
    private static final int SIGNATURE_OFFSET = 0;
    private static final int SIGNATURE_LENGTH = 3;
    private static final int VERSION_OFFSET = 3;
    private static final int GENERATION_OFFSET = 10;
    private static final int SEGMENT_REFERENCES_COUNT_OFFSET = 14;
    private static final int SEGMENT_REFERENCE_LENGTH = 16;
    private static final int RECORD_REFERENCES_COUNT_OFFSET = 18;
    private static final int RECORD_REFERENCE_LENGTH = 9;
    private static final int SEGMENT_REFERENCE_MSB_OFFSET = 0;
    private static final int SEGMENT_REFERENCE_LSB_OFFSET = 8;
    private static final int RECORD_REFERENCE_NUMBER_OFFSET = 0;
    private static final int RECORD_REFERENCE_TYPE_OFFSET = 4;
    private static final int RECORD_REFERENCE_OFFSET_OFFSET = 5;
    private static final int MAX_SMALL_LENGTH_VALUE = 128;
    private static final int MAX_MEDIUM_LENGTH_VALUE = 16512;
    final Buffer buffer;

    SegmentDataV12(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte getVersion() {
        return this.buffer.get(3);
    }

    @Override
    public String getSignature() {
        byte[] signature = new byte[3];
        for (int i = 0; i < 3; ++i) {
            signature[i] = this.buffer.get(0 + i);
        }
        return new String(signature, Charsets.UTF_8);
    }

    @Override
    public int getFullGeneration() {
        return this.getGeneration();
    }

    @Override
    public boolean isCompacted() {
        return true;
    }

    @Override
    public int getGeneration() {
        return this.buffer.getInt(10);
    }

    @Override
    public int getSegmentReferencesCount() {
        return this.buffer.getInt(14);
    }

    @Override
    public int getRecordReferencesCount() {
        return this.buffer.getInt(18);
    }

    private int getRecordReferenceBase(int i) {
        return 32 + this.getSegmentReferencesCount() * 16 + i * 9;
    }

    @Override
    public int getRecordReferenceNumber(int i) {
        return this.buffer.getInt(this.getRecordReferenceBase(i) + 0);
    }

    @Override
    public byte getRecordReferenceType(int i) {
        return this.buffer.get(this.getRecordReferenceBase(i) + 4);
    }

    @Override
    public int getRecordReferenceOffset(int i) {
        return this.buffer.getInt(this.getRecordReferenceBase(i) + 5);
    }

    private int getSegmentReferenceBase(int i) {
        return 32 + i * 16;
    }

    @Override
    public long getSegmentReferenceMsb(int i) {
        return this.buffer.getLong(this.getSegmentReferenceBase(i) + 0);
    }

    @Override
    public long getSegmentReferenceLsb(int i) {
        return this.buffer.getLong(this.getSegmentReferenceBase(i) + 8);
    }

    private int index(int recordReferenceOffset) {
        return SegmentDataUtils.index(this.buffer, recordReferenceOffset);
    }

    @Override
    public long readLength(int recordReferenceOffset) {
        return this.internalReadLength(this.index(recordReferenceOffset));
    }

    private long internalReadLength(int index) {
        int head = this.buffer.get(index) & 0xFF;
        if ((head & 0x80) == 0) {
            return head;
        }
        if ((head & 0x40) == 0) {
            return 128 + (this.buffer.getShort(index) & 0x3FFF);
        }
        return 16512L + (this.buffer.getLong(index) & 0x3FFFFFFFFFFFFFFFL);
    }

    @Override
    public StringData readString(int recordReferenceOffset) {
        return this.internalReadString(this.index(recordReferenceOffset));
    }

    private StringData internalReadString(int index) {
        long length = this.internalReadLength(index);
        if (length < 128L) {
            return this.internalReadString(index + 1, (int)length);
        }
        if (length < 16512L) {
            return this.internalReadString(index + 2, (int)length);
        }
        if (length < Integer.MAX_VALUE) {
            return new StringData(this.internalReadRecordId(index + 8), (int)length);
        }
        throw new IllegalStateException("String is too long: " + length + "; possibly trying to read a BLOB using getString; can not convert BLOB to String");
    }

    private StringData internalReadString(int index, int length) {
        Buffer duplicate = this.buffer.duplicate();
        duplicate.position(index);
        duplicate.limit(index + length);
        String string = duplicate.decode(Charsets.UTF_8).toString();
        return new StringData(string, length);
    }

    @Override
    public RecordIdData readRecordId(int recordReferenceOffset) {
        return this.internalReadRecordId(this.index(recordReferenceOffset));
    }

    private RecordIdData internalReadRecordId(int index) {
        int segmentReference = this.buffer.getShort(index) & 0xFFFF;
        int recordNumber = this.buffer.getInt(index + 2);
        return new RecordIdData(segmentReference, recordNumber);
    }

    @Override
    public byte readByte(int recordReferenceOffset) {
        return this.buffer.get(this.index(recordReferenceOffset));
    }

    @Override
    public int readInt(int recordReferenceOffset) {
        return this.buffer.getInt(this.index(recordReferenceOffset));
    }

    @Override
    public short readShort(int recordReferenceOffset) {
        return this.buffer.getShort(this.index(recordReferenceOffset));
    }

    @Override
    public long readLong(int recordReferenceOffset) {
        return this.buffer.getLong(this.index(recordReferenceOffset));
    }

    @Override
    public Buffer readBytes(int recordReferenceOffset, int size) {
        return SegmentDataUtils.readBytes(this.buffer, this.index(recordReferenceOffset), size);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public void hexDump(OutputStream stream) throws IOException {
        SegmentDataUtils.hexDump(this.buffer, stream);
    }

    @Override
    public void binDump(OutputStream stream) throws IOException {
        SegmentDataUtils.binDump(this.buffer, stream);
    }

    @Override
    public int estimateMemoryUsage() {
        return SegmentDataUtils.estimateMemoryUsage(this.buffer);
    }
}

