/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.jetbrains.annotations.NotNull;

class DefaultCleanupStrategy
implements CleanupStrategy {
    DefaultCleanupStrategy() {
    }

    @Override
    public List<String> cleanup(CleanupStrategy.Context context) throws IOException {
        PrintableStopwatch watch = PrintableStopwatch.createStarted();
        context.getGCListener().info("cleanup started using reclaimer {}", new Object[]{context.getReclaimer()});
        context.getGCListener().updateStatus(SegmentGCStatus.CLEANUP.message());
        context.getSegmentCache().clear();
        System.gc();
        TarFiles.CleanupResult cleanupResult = context.getTarFiles().cleanup(DefaultCleanupStrategy.newCleanupContext(context, context.getReclaimer()));
        if (cleanupResult.isInterrupted()) {
            context.getGCListener().info("cleanup interrupted", new Object[0]);
        }
        context.getSegmentTracker().clearSegmentIdTables(cleanupResult.getReclaimedSegmentIds(), context.getSegmentEvictionReason());
        context.getGCListener().info("cleanup marking files for deletion: {}", new Object[]{DefaultCleanupStrategy.toFileNames(cleanupResult.getRemovableFiles())});
        long finalSize = DefaultCleanupStrategy.size(context);
        long reclaimedSize = cleanupResult.getReclaimedSize();
        context.getFileStoreStats().reclaimed(reclaimedSize);
        context.getGCJournal().persist(reclaimedSize, finalSize, DefaultCleanupStrategy.getGcGeneration(context), context.getCompactionMonitor().getCompactedNodes(), context.getCompactedRootId());
        context.getGCListener().cleaned(reclaimedSize, finalSize);
        context.getGCListener().info("cleanup completed in {}. Post cleanup size is {} and space reclaimed {}.", new Object[]{watch, PrintableBytes.newPrintableBytes(finalSize), PrintableBytes.newPrintableBytes(reclaimedSize)});
        return cleanupResult.getRemovableFiles();
    }

    private static CleanupContext newCleanupContext(final CleanupStrategy.Context context, final Predicate<GCGeneration> old) {
        return new CleanupContext(){

            private boolean isUnreferencedBulkSegment(UUID id, boolean referenced) {
                return !SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && !referenced;
            }

            private boolean isOldDataSegment(UUID id, GCGeneration generation) {
                return SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && old.apply((Object)generation);
            }

            @Override
            public Collection<UUID> initialReferences() {
                HashSet references = Sets.newHashSet();
                for (SegmentId id : context.getSegmentTracker().getReferencedSegmentIds()) {
                    if (!id.isBulkSegmentId()) continue;
                    references.add(id.asUUID());
                }
                return references;
            }

            @Override
            public boolean shouldReclaim(UUID id, GCGeneration generation, boolean referenced) {
                return this.isUnreferencedBulkSegment(id, referenced) || this.isOldDataSegment(id, generation) || generation.getFullGeneration() > DefaultCleanupStrategy.getGcGeneration(context).getFullGeneration();
            }

            @Override
            public boolean shouldFollow(UUID from, UUID to) {
                return !SegmentId.isDataSegmentId(to.getLeastSignificantBits());
            }
        };
    }

    private static String toFileNames(@NotNull List<String> files) {
        if (files.isEmpty()) {
            return "none";
        }
        return Joiner.on((String)",").join(files);
    }

    private static GCGeneration getGcGeneration(CleanupStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }

    private static long size(CleanupStrategy.Context context) {
        return context.getTarFiles().size();
    }
}

