/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Date;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.jmx.AbstractCheckpointMBean;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentCheckpointMBean
extends AbstractCheckpointMBean {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SegmentNodeStore store;

    public SegmentCheckpointMBean(SegmentNodeStore store) {
        this.store = store;
    }

    protected void collectCheckpoints(TabularDataSupport tab) throws OpenDataException {
        for (ChildNodeEntry cne : this.store.getCheckpoints().getChildNodeEntries()) {
            String id = cne.getName();
            NodeState checkpoint = cne.getNodeState();
            String created = SegmentCheckpointMBean.getDate(checkpoint, "created");
            String expires = SegmentCheckpointMBean.getDate(checkpoint, "timestamp");
            tab.put(id, this.toCompositeData(id, created, expires, this.store.checkpointInfo(id)));
        }
    }

    public long getOldestCheckpointCreationTimestamp() {
        long minTimestamp = Long.MAX_VALUE;
        for (ChildNodeEntry cne : this.store.getCheckpoints().getChildNodeEntries()) {
            NodeState checkpoint = cne.getNodeState();
            PropertyState p = checkpoint.getProperty("created");
            if (p == null) continue;
            minTimestamp = Math.min(minTimestamp, (Long)p.getValue(Type.LONG));
        }
        return minTimestamp == Long.MAX_VALUE ? 0L : minTimestamp;
    }

    private static String getDate(NodeState checkpoint, String name) {
        PropertyState p = checkpoint.getProperty(name);
        if (p == null) {
            return "NA";
        }
        return new Date((Long)p.getValue(Type.LONG)).toString();
    }

    public String createCheckpoint(long lifetime) {
        String cp = this.store.checkpoint(lifetime);
        this.log.info("Created checkpoint [{}] with lifetime {}", (Object)cp, (Object)lifetime);
        return cp;
    }

    public boolean releaseCheckpoint(String checkpoint) {
        this.log.info("Released checkpoint [{}]", (Object)checkpoint);
        return this.store.release(checkpoint);
    }
}

