/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public interface Compression {
    public static final Compression NONE = new Compression(){

        @Override
        public InputStream getInputStream(InputStream in) throws IOException {
            return in;
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) throws IOException {
            return out;
        }

        @Override
        public String addSuffix(String filename) {
            return filename;
        }
    };
    public static final Compression GZIP = new Compression(){

        @Override
        public InputStream getInputStream(InputStream in) throws IOException {
            return new GZIPInputStream(in, 2048);
        }

        @Override
        public OutputStream getOutputStream(OutputStream out) throws IOException {
            return new GZIPOutputStream(out, 2048){
                {
                    this.def.setLevel(1);
                }
            };
        }

        @Override
        public String addSuffix(String filename) {
            return filename + ".gz";
        }
    };

    public InputStream getInputStream(InputStream var1) throws IOException;

    public OutputStream getOutputStream(OutputStream var1) throws IOException;

    public String addSuffix(String var1);
}

