/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.yellowpages.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.components.yellowpages.YellowpagesComponentSettings;
import org.silverpeas.components.yellowpages.dao.GroupDAO;
import org.silverpeas.components.yellowpages.model.TopicDetail;
import org.silverpeas.components.yellowpages.model.UserContact;
import org.silverpeas.components.yellowpages.model.YellowpagesRuntimeException;
import org.silverpeas.components.yellowpages.service.YellowpagesService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contact.model.CompleteContact;
import org.silverpeas.core.contact.model.Contact;
import org.silverpeas.core.contact.model.ContactDetail;
import org.silverpeas.core.contact.model.ContactFatherDetail;
import org.silverpeas.core.contact.model.ContactPK;
import org.silverpeas.core.contact.service.ContactService;
import org.silverpeas.core.contribution.template.form.dao.ModelDAO;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class DefaultYellowpagesService
implements YellowpagesService {
    private static final String GROUP_PREFIX = "group_";
    private static final String NO_ID = "unknown";
    @Inject
    private OrganizationController organizationController;
    @Inject
    private NodeService nodeService;
    @Inject
    private ContactService contactService;

    private OrganizationController getOrganisationController() {
        return this.organizationController;
    }

    private List<Integer> getRecursiveNbContact(NodeDetail nodeDetail) {
        ArrayList<Integer> nbContactsByTopic = new ArrayList<Integer>();
        Collection childrenPKs = nodeDetail.getChildrenDetails();
        if (childrenPKs != null) {
            this.addNodeDetailGroups(nodeDetail, childrenPKs);
            for (NodeDetail child : childrenPKs) {
                int nbContacts;
                NodePK childPK = child.getNodePK();
                if (!childPK.getId().startsWith(GROUP_PREFIX)) {
                    String childPath = child.getPath();
                    nbContacts = this.contactService.getNbPubByFatherPath(childPK, childPath);
                    List<Integer> nbContactsBySubTopic = this.getRecursiveNbContact(this.nodeService.getDetail(childPK));
                    for (Integer nbSubContact : nbContactsBySubTopic) {
                        nbContacts += nbSubContact.intValue();
                    }
                } else {
                    String groupId = childPK.getId().substring(childPK.getId().indexOf(95) + 1);
                    nbContacts = this.getOrganisationController().getAllSubUsersNumber(groupId);
                }
                nbContactsByTopic.add(nbContacts);
            }
        }
        return nbContactsByTopic;
    }

    private void addNodeDetailGroups(NodeDetail nodeDetail, Collection<NodeDetail> childrenPKs) {
        this.getGroups(nodeDetail.getNodePK()).forEach(g -> {
            NodeDetail nodeGroup = new NodeDetail();
            nodeGroup.getNodePK().setId(GROUP_PREFIX + g.getId());
            nodeGroup.setName(g.getName());
            nodeGroup.setDescription(g.getDescription());
            childrenPKs.add(nodeGroup);
        });
    }

    @Override
    public TopicDetail goTo(NodePK pk, String userId) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        ArrayList<ContactDetail> contactDetailsR = new ArrayList<ContactDetail>();
        try {
            Collection contactDetails;
            ContactPK contactPK;
            NodeDetail nodeDetail = this.nodeService.getDetail(pk);
            if (pk.isUnclassed()) {
                contactPK = new ContactPK(NO_ID, (ResourceReference)pk);
                contactDetails = this.contactService.getOrphanContacts(contactPK);
            } else if (pk.isTrash()) {
                contactPK = new ContactPK(NO_ID, (ResourceReference)pk);
                contactDetails = this.contactService.getUnavailableContactsByPublisherId(contactPK, userId, "1");
            } else {
                contactDetails = this.contactService.getDetailsByFatherPK(nodeDetail.getNodePK());
            }
            if (contactDetails != null) {
                this.fillContactDetails(contactDetails, contactDetailsR);
            }
            List<Integer> nbContactsByTopic = this.getRecursiveNbContact(nodeDetail);
            return new TopicDetail(newPath, nodeDetail, this.contactDetails2userPubs(contactDetailsR), nbContactsByTopic);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    private void fillContactDetails(Collection<ContactDetail> contactDetails, List<ContactDetail> contactDetailsR) {
        OrganizationController orga = this.getOrganisationController();
        for (ContactDetail contactDetail : contactDetails) {
            if (contactDetail.getUserId() != null) {
                try {
                    UserDetail userDetail = (UserDetail)orga.getUserDetail(contactDetail.getUserId());
                    if (userDetail != null) {
                        this.setContactAttributes(contactDetail, userDetail, true);
                        contactDetailsR.add(contactDetail);
                        continue;
                    }
                    contactDetail.setUserId(null);
                    this.updateContact((Contact)contactDetail);
                    this.sendContactToBasket(contactDetail.getPK());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("contactDetail = " + contactDetail, (Throwable)e);
                }
                continue;
            }
            contactDetailsR.add(contactDetail);
        }
    }

    @Override
    public List<NodeDetail> getTree(String instanceId) {
        ArrayList<NodeDetail> result = new ArrayList<NodeDetail>();
        List tree = this.nodeService.getSubTree(new NodePK("0", instanceId));
        for (NodeDetail node : tree) {
            result.add(node);
            this.getGroups(node.getNodePK()).forEach(g -> this.addGroup((List<NodeDetail>)result, (Group)g, node.getLevel() + 1));
        }
        return result;
    }

    public void addGroup(List<NodeDetail> tree, Group group, int level) {
        if (group != null) {
            Group[] subGroups;
            NodeDetail nGroup = new NodeDetail();
            nGroup.setName(group.getName());
            nGroup.setDescription(group.getDescription());
            nGroup.getNodePK().setId(GROUP_PREFIX + group.getId());
            nGroup.setLevel(level);
            tree.add(nGroup);
            Group[] groupArray = subGroups = this.getOrganisationController().getAllSubGroups(group.getId());
            int n = groupArray.length;
            for (int i = 0; i < n; ++i) {
                Group subGroup1;
                Group subGroup = subGroup1 = groupArray[i];
                this.addGroup(tree, subGroup, level + 1);
            }
        }
    }

    @Override
    public void addToTopic(NodeDetail father, NodeDetail subTopic) {
        if (!this.isSameTopicSameLevelOnCreation(subTopic)) {
            try {
                String xmlFormName = subTopic.getModelId();
                if (StringUtil.isDefined((String)xmlFormName)) {
                    this.registerTemplate(xmlFormName, father.getNodePK().getInstanceId());
                }
                this.nodeService.createNode(subTopic, father);
            }
            catch (Exception re) {
                throw new YellowpagesRuntimeException(re);
            }
        }
    }

    private boolean isSameTopicSameLevelOnCreation(NodeDetail subTopic) {
        try {
            return this.nodeService.isSameNameSameLevelOnCreation(subTopic);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    private boolean isSameTopicSameLevelOnUpdate(NodeDetail subTopic) {
        try {
            return this.nodeService.isSameNameSameLevelOnUpdate(subTopic);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    public void updateTopic(NodeDetail topic) {
        if (!this.isSameTopicSameLevelOnUpdate(topic)) {
            try {
                String xmlFormName = topic.getModelId();
                if (StringUtil.isDefined((String)xmlFormName)) {
                    this.registerTemplate(xmlFormName, topic.getNodePK().getInstanceId());
                }
                this.nodeService.setDetail(topic);
            }
            catch (Exception re) {
                throw new YellowpagesRuntimeException(re);
            }
        }
    }

    @Override
    public NodeDetail getSubTopicDetail(NodePK pk) {
        return this.nodeService.getDetail(pk);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteTopic(NodePK pkToDelete) {
        ContactPK contactPK = new ContactPK(NO_ID, (ResourceReference)pkToDelete);
        try {
            this.contactService.removeAllIssue(pkToDelete, contactPK);
            this.unreferenceOrphanContacts(contactPK);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
        try {
            this.nodeService.removeNode(pkToDelete);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    private Collection<UserContact> contactDetails2userPubs(Collection<ContactDetail> contactDetails) {
        Iterator<ContactDetail> iterator = contactDetails.iterator();
        String[] users = new String[contactDetails.size()];
        int i = 0;
        while (iterator.hasNext()) {
            users[i] = iterator.next().getCreatorId();
            ++i;
        }
        OrganizationController orga = this.getOrganisationController();
        UserDetail[] userDetails = (UserDetail[])orga.getUserDetails(users);
        ArrayList<UserContact> list = new ArrayList<UserContact>(contactDetails.size());
        iterator = contactDetails.iterator();
        i = 0;
        while (iterator.hasNext()) {
            UserContact uPub = new UserContact(userDetails[i], iterator.next());
            ++i;
            list.add(uPub);
        }
        return list;
    }

    @Override
    public ContactDetail getContactDetail(ContactPK contactPK) {
        try {
            ContactDetail contactDetail = this.contactService.getDetail(contactPK);
            if (contactDetail.getUserId() != null) {
                OrganizationController orga = this.getOrganisationController();
                UserDetail userDetail = (UserDetail)orga.getUserDetail(contactDetail.getUserId());
                if (userDetail != null) {
                    this.setContactAttributes(contactDetail, userDetail, false);
                } else {
                    contactDetail.setUserId(null);
                    this.updateContact((Contact)contactDetail);
                    this.sendContactToBasket(contactDetail.getPK());
                }
            }
            return contactDetail;
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    private void setContactAttributes(ContactDetail contactDetail, UserDetail userDetail, boolean filterExtraInfos) {
        contactDetail.setFirstName(userDetail.getFirstName());
        contactDetail.setLastName(userDetail.getLastName());
        contactDetail.setEmail(userDetail.getEmailAddress());
        contactDetail.setUserExtraDataRequired(!filterExtraInfos || YellowpagesComponentSettings.areUserExtraDataRequired());
    }

    @Override
    public Collection<ContactDetail> getContactDetailsByLastName(ContactPK pk, String query) {
        try {
            return this.contactService.getDetailsByLastName(pk, query);
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    @Override
    public Collection<ContactDetail> getContactDetailsByLastNameOrFirstName(ContactPK pk, String query) {
        Collection contactDetails;
        try {
            contactDetails = this.contactService.getDetailsByLastNameOrFirstName(pk, query);
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
        return contactDetails;
    }

    @Override
    public Collection<ContactDetail> getContactDetailsByLastNameAndFirstName(ContactPK pk, String lastName, String firstName) {
        try {
            return this.contactService.getDetailsByLastNameAndFirstName(pk, lastName, firstName);
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    @Override
    public Collection<ContactFatherDetail> getAllContactDetails(NodePK nodePK) {
        ArrayList<NodePK> nodePKsWithout12 = new ArrayList<NodePK>();
        ArrayList<ContactFatherDetail> contactDetailsR = new ArrayList<ContactFatherDetail>();
        try {
            Collection nodePKs = this.nodeService.getDescendantPKs(nodePK);
            nodePKsWithout12.add(nodePK);
            for (NodePK pk : nodePKs) {
                if (pk.isTrash() || pk.isUnclassed()) continue;
                nodePKsWithout12.add(pk);
            }
            ContactPK pk = new ContactPK(NO_ID, (ResourceReference)nodePK);
            Collection contactDetails = this.contactService.getDetailsByFatherPKs(nodePKsWithout12, pk, nodePK);
            if (contactDetails != null) {
                this.fillContactFatherDetails(contactDetails, contactDetailsR);
            }
            return contactDetailsR;
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    private void fillContactFatherDetails(Collection<ContactFatherDetail> contactDetails, ArrayList<ContactFatherDetail> contactDetailsR) {
        for (ContactFatherDetail contactFatherDetail : contactDetails) {
            ContactDetail contactDetail = contactFatherDetail.getContactDetail();
            if (contactDetail.getUserId() != null) {
                try {
                    OrganizationController orga = this.getOrganisationController();
                    UserDetail userDetail = (UserDetail)orga.getUserDetail(contactDetail.getUserId());
                    if (userDetail != null) {
                        this.setContactAttributes(contactDetail, userDetail, true);
                        contactDetailsR.add(contactFatherDetail);
                        continue;
                    }
                    contactDetail.setUserId(null);
                    this.updateContact((Contact)contactDetail);
                    this.sendContactToBasket(contactDetail.getPK());
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("contactDetail = " + contactDetail, (Throwable)e);
                }
                continue;
            }
            contactDetailsR.add(contactFatherDetail);
        }
    }

    @Override
    public List<Collection<NodeDetail>> getPathList(ContactPK contactPK) {
        Collection fatherPKs;
        try {
            fatherPKs = this.contactService.getAllFatherPK(contactPK);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
        try {
            ArrayList<Collection<NodeDetail>> pathList = new ArrayList<Collection<NodeDetail>>();
            if (fatherPKs != null) {
                for (NodePK pk : fatherPKs) {
                    NodePath path = this.nodeService.getPath(pk);
                    pathList.add((Collection<NodeDetail>)path);
                }
            }
            return pathList;
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createContact(Contact contact, NodePK nodePK) {
        ContactPK contactPK;
        contact.getPK().setComponentName(nodePK.getInstanceId());
        try {
            contactPK = this.contactService.createContact(contact);
            contact.getPK().setId(contactPK.getId());
            this.addContactToTopic(contactPK, nodePK.getId());
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
        return contactPK.getId();
    }

    @Override
    public void updateContact(Contact contactDetail) {
        try {
            this.contactService.setDetail(contactDetail);
            ContactPK contactPK = contactDetail.getPK();
            String fatherId = "2";
            Collection fathers = this.contactService.getAllFatherPK(contactPK);
            Iterator it = fathers.iterator();
            if (it.hasNext()) {
                fatherId = ((NodePK)it.next()).getId();
            }
            if ("2".equals(fatherId) || "1".equals(fatherId)) {
                this.deleteIndex(contactPK);
            }
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteContact(ContactPK contactPK, NodePK nodePK) {
        if (nodePK.isTrash() || nodePK.isUnclassed()) {
            try {
                this.contactService.removeFather(contactPK, new NodePK("1", (ResourceReference)nodePK));
                this.contactService.removeContact(contactPK);
            }
            catch (Exception re) {
                throw new YellowpagesRuntimeException(re);
            }
        } else {
            this.sendContactToBasket(contactPK);
        }
    }

    private void sendContactToBasket(ContactPK contactPK) {
        try {
            this.contactService.removeAllFather(contactPK);
            this.contactService.addFather(contactPK, new NodePK("1", (ResourceReference)contactPK));
            this.deleteIndex(contactPK);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    public void emptyDZByUserId(String instanceId, String userId) {
        ContactPK contactPK = new ContactPK(null, instanceId);
        try {
            this.contactService.deleteOrphanContactsByCreatorId(contactPK, userId);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addContactToTopic(ContactPK contactPK, String fatherId) {
        NodePK fatherPK = new NodePK(fatherId, (ResourceReference)contactPK);
        try {
            NodePK pk;
            Iterator iterator;
            Collection fathers = this.contactService.getAllFatherPK(contactPK);
            if (fathers.size() == 1 && (iterator = fathers.iterator()).hasNext() && (pk = (NodePK)iterator.next()).isTrash()) {
                this.contactService.removeFather(contactPK, pk);
            }
            this.contactService.addFather(contactPK, fatherPK);
            if (!fatherPK.isTrash()) {
                this.contactService.index(contactPK);
            }
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    public void deleteContactFromTopic(ContactPK contactPK, String fatherId) {
        NodePK fatherPK = new NodePK(fatherId, (ResourceReference)contactPK);
        try {
            this.contactService.removeFather(contactPK, fatherPK);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    public void createInfoModel(ContactPK contactPK, String modelId) {
        try {
            this.contactService.createInfoModel(contactPK, modelId);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Override
    public CompleteContact getCompleteContactInNode(ContactPK contactPK, String nodeId) {
        CompleteContact completeContact;
        try {
            NodePK nodePK = new NodePK(nodeId, contactPK.getInstanceId());
            NodeDetail nodeDetail = this.nodeService.getDetail(nodePK);
            String modelId = nodeDetail.getModelId();
            completeContact = this.contactService.getCompleteContact(contactPK, modelId);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
        this.checkContactAsUser(completeContact);
        return completeContact;
    }

    @Override
    public CompleteContact getCompleteContact(ContactPK contactPK) {
        CompleteContact contact = this.contactService.getCompleteContact(contactPK);
        this.checkContactAsUser(contact);
        return contact;
    }

    private void checkContactAsUser(CompleteContact completeContact) {
        ContactDetail contactDetail = completeContact.getContactDetail();
        if (contactDetail.getUserId() != null) {
            try {
                OrganizationController orga = this.getOrganisationController();
                UserDetail userDetail = (UserDetail)orga.getUserDetail(contactDetail.getUserId());
                if (userDetail != null) {
                    this.setContactAttributes(contactDetail, userDetail, false);
                } else {
                    contactDetail.setUserId(null);
                    this.updateContact((Contact)contactDetail);
                    this.sendContactToBasket(contactDetail.getPK());
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("contactPK = " + contactDetail.getPK().toString(), (Throwable)e);
            }
        }
    }

    @Override
    public Collection<UserContact> getContacts(Collection<String> contactIds, String instanceId) {
        ArrayList<ContactPK> contactPKs = new ArrayList<ContactPK>();
        ArrayList<ContactDetail> contactDetailsR = new ArrayList<ContactDetail>();
        for (String contactId : contactIds) {
            ContactPK contactPK = new ContactPK(contactId, instanceId);
            contactPKs.add(contactPK);
        }
        try {
            Collection contacts = this.contactService.getContacts(contactPKs);
            if (contacts != null) {
                this.fillContactDetails(contacts, contactDetailsR);
            }
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
        return this.contactDetails2userPubs(contactDetailsR);
    }

    @Override
    public Collection<NodePK> getContactFathers(ContactPK contactPK) {
        try {
            return this.contactService.getAllFatherPK(contactPK);
        }
        catch (Exception re) {
            throw new YellowpagesRuntimeException(re);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRED)
    public void unreferenceOrphanContacts(ContactPK contactPK) {
        try {
            Collection orphanContacts = this.contactService.getOrphanContacts(contactPK);
            for (ContactDetail contactDetail : orphanContacts) {
                this.contactService.addFather(contactDetail.getPK(), new NodePK("1", (ResourceReference)contactPK));
                this.deleteIndex(contactDetail.getPK());
            }
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    private void deleteIndex(ContactPK contactPK) {
        this.contactService.deleteIndex(contactPK);
    }

    @Override
    public List<Group> getGroups(NodePK pk) {
        List<Group> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = GroupDAO.getGroupIds(con, pk.getId(), pk.getInstanceId()).stream().map(arg_0 -> ((OrganizationController)this.getOrganisationController()).getGroup(arg_0)).filter(Objects::nonNull).map(Group.class::cast).filter(Predicate.not(Group::isRemovedState)).collect(Collectors.toList());
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new YellowpagesRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public void addGroup(String groupId, NodePK nodePK) {
        try (Connection con = this.getConnection();){
            GroupDAO.addGroup(con, groupId, nodePK.getId(), nodePK.getInstanceId());
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    @Override
    public void removeGroup(String groupId) {
        Connection con = this.getConnection();
        try {
            GroupDAO.removeGroup(con, groupId);
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void removeGroup(String groupId, NodePK nodePK) {
        try (Connection con = this.getConnection();){
            GroupDAO.removeGroup(con, groupId, nodePK.getId(), nodePK.getInstanceId());
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    @Override
    public void setModelUsed(String[] models, String instanceId) {
        try (Connection con = this.getConnection();){
            ModelDAO.deleteModel((Connection)con, (String)instanceId);
            if (models != null) {
                for (String modelId : models) {
                    ModelDAO.addModel((Connection)con, (String)instanceId, (String)modelId);
                }
            }
        }
        catch (Exception e) {
            throw new YellowpagesRuntimeException(e);
        }
    }

    @Override
    public Collection<String> getModelUsed(String instanceId) {
        Collection collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = ModelDAO.getModelUsed((Connection)con, (String)instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new YellowpagesRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public void index(String instanceId) {
        this.indexFolder(new NodePK("0", instanceId));
    }

    private void indexFolder(NodePK pk) {
        NodeDetail node = this.nodeService.getDetail(pk);
        if (!(pk.isRoot() || pk.isTrash() || pk.isUnclassed())) {
            this.nodeService.createIndex(node);
        }
        if (!pk.isTrash() && !pk.isUnclassed()) {
            this.indexContacts(pk);
            Collection subTopics = node.getChildrenDetails();
            for (NodeDetail subTopic : subTopics) {
                this.indexFolder(subTopic.getNodePK());
            }
        }
    }

    private void indexContacts(NodePK pk) {
        Collection contacts = this.contactService.getDetailsByFatherPK(pk);
        for (ContactDetail contact : contacts) {
            this.contactService.index(contact.getPK());
        }
    }

    private void registerTemplate(String xmlFormName, String instanceId) throws PublicationTemplateException {
        if (StringUtil.isDefined((String)xmlFormName)) {
            String key = instanceId + ":" + FilenameUtils.getBaseName((String)xmlFormName);
            PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
            templateManager.addDynamicPublicationTemplate(key, xmlFormName);
        }
    }
}

