/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs;

import edu.psu.swe.commons.jaxrs.enumerations.RelationshipType;
import edu.psu.swe.commons.jaxrs.utilities.UriUtil;
import java.net.MalformedURLException;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="link")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AtomLink {
    private static final Logger LOG = LoggerFactory.getLogger(AtomLink.class);
    @XmlElement(name="href")
    private String hyperlink;
    @XmlElement(name="rel")
    private String relation;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="type")
    private String mimeType;

    public AtomLink() {
    }

    public AtomLink(String relation, String type, String hyperlink) {
        this.relation = relation;
        this.mimeType = type;
        this.hyperlink = hyperlink;
    }

    public AtomLink(String relation, String type, String hyperlink, String title) {
        this(relation, type, hyperlink);
        this.title = title;
    }

    public static AtomLink createSelfLink(UriInfo uriInfo) {
        String url = null;
        try {
            url = UriUtil.urlAsString(uriInfo, true);
        }
        catch (MalformedURLException mue) {
            LOG.info("Failed to convert url " + mue.getLocalizedMessage());
        }
        AtomLink self = new AtomLink();
        self.setRelation(RelationshipType.SELF.toString());
        self.setHyperlink(url);
        self.setMimeType("application/edu-psu-swe-v1+json");
        return self;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setHyperlink(String hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomLink)) {
            return false;
        }
        AtomLink other = (AtomLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hyperlink = this.getHyperlink();
        String other$hyperlink = other.getHyperlink();
        if (this$hyperlink == null ? other$hyperlink != null : !this$hyperlink.equals(other$hyperlink)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        return !(this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AtomLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hyperlink = this.getHyperlink();
        result = result * 59 + ($hyperlink == null ? 43 : $hyperlink.hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        return result;
    }

    public String toString() {
        return "AtomLink(hyperlink=" + this.getHyperlink() + ", relation=" + this.getRelation() + ", title=" + this.getTitle() + ", mimeType=" + this.getMimeType() + ")";
    }
}

