/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import javax.inject.Inject;
import org.silverpeas.components.kmelia.service.DefaultKmeliaService;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.attachment.notification.AttachmentEvent;
import org.silverpeas.core.contribution.attachment.notification.AttachmentRef;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.notification.system.CDIResourceEventListener;

@Bean
public class KmeliaAttachmentEventListener
extends CDIResourceEventListener<AttachmentEvent> {
    @Inject
    private DefaultKmeliaService kmeliaService;

    public void onDeletion(AttachmentEvent event) {
        AttachmentRef attachment = (AttachmentRef)event.getTransition().getBefore();
        if (attachment != null && this.isAboutKmeliaPublication(attachment)) {
            this.kmeliaService.onDocumentDeletion(attachment);
        }
    }

    public void onUpdate(AttachmentEvent event) {
        this.onCreation(event);
    }

    public void onCreation(AttachmentEvent event) {
        AttachmentRef attachment = (AttachmentRef)event.getTransition().getAfter();
        if (attachment != null) {
            this.anExternalPublicationElementHaveChanged(attachment, attachment.getUserId());
        }
    }

    private void anExternalPublicationElementHaveChanged(AttachmentRef attachment, String userId) {
        if (this.isAboutKmeliaPublication(attachment)) {
            PublicationPK pubPK = new PublicationPK(attachment.getForeignId(), attachment.getInstanceId());
            this.kmeliaService.externalElementsOfPublicationHaveChanged(pubPK, userId);
        }
    }

    private boolean isAboutKmeliaPublication(AttachmentRef attachment) {
        return !attachment.getForeignId().startsWith("Node") && (attachment.getInstanceId().startsWith("kmax") || attachment.getInstanceId().startsWith("kmelia") || attachment.getInstanceId().startsWith("toolbox"));
    }
}

