/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.util.HttpUtil;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class Watermark {
    private boolean enabled = false;
    private String propertyIPTCForHD;
    private String propertyIPTCForThumbnails;
    private String textForHD;
    private String textForThumbnails;
    private File imageForHD;
    private File imageForThumbnails;

    boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    String getIPTCPropertyForHD() {
        return this.propertyIPTCForHD;
    }

    void setIPTCPropertyForHD(String IPTCPropertyForHD) {
        this.propertyIPTCForHD = IPTCPropertyForHD;
    }

    String getIPTCPropertyForThumbnails() {
        return this.propertyIPTCForThumbnails;
    }

    void setIPTCPropertyForThumbnails(String IPTCPropertyForThumbnails) {
        this.propertyIPTCForThumbnails = IPTCPropertyForThumbnails;
    }

    String getTextForHD() {
        return this.textForHD;
    }

    void setTextForHD(String textForHD) {
        this.textForHD = textForHD;
    }

    String getTextForThumbnails() {
        return this.textForThumbnails;
    }

    void setTextForThumbnails(String textForThumbnails) {
        this.textForThumbnails = textForThumbnails;
    }

    File getImageForHD() {
        return this.imageForHD;
    }

    synchronized void setImageUrlForHD(String componentInstanceId, String imageUrlForHD) {
        this.imageForHD = this.processImageUrl(componentInstanceId, imageUrlForHD);
    }

    File getImageForThumbnails() {
        return this.imageForThumbnails;
    }

    synchronized void setImageUrlForThumbnails(String componentInstanceId, String imageUrlForThumbnails) {
        this.imageForThumbnails = this.processImageUrl(componentInstanceId, imageUrlForThumbnails);
    }

    private synchronized File processImageUrl(String componentInstanceId, String imageUrl) {
        File cachedFile = null;
        if (StringUtil.isDefined((String)imageUrl)) {
            String imageUrlWithoutProtocol = imageUrl.replaceAll("(file|https?):/+", "").replaceAll("[&=%!;*?]", "").replaceAll(":([0-9]+)", "$1");
            String normalizedName = FilenameUtils.normalize((String)imageUrlWithoutProtocol.replaceAll("[/\\\\:]", ""));
            String extension = FilenameUtils.getExtension((String)normalizedName);
            Path cachedPath = Paths.get(FileRepositoryManager.getTemporaryPath(), componentInstanceId + "_watermark_" + FilenameUtils.getBaseName((String)normalizedName) + "." + (StringUtil.isDefined((String)extension) ? extension : "png"));
            cachedFile = cachedPath.toFile();
            if (!cachedFile.exists()) {
                cachedFile = this.cacheImage(imageUrl, cachedFile, imageUrlWithoutProtocol, cachedPath);
            }
        }
        return cachedFile;
    }

    private File cacheImage(String imageUrl, File cachedFile, String imageUrlWithoutProtocol, Path cachedPath) {
        block12: {
            Path watermarkSource = Paths.get(imageUrlWithoutProtocol, new String[0]);
            if (watermarkSource.toFile().exists()) {
                try {
                    Files.copy(watermarkSource, cachedPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    cachedFile = null;
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                    SilverLogger.getLogger((Object)this).warn("impossible to save image from URL {0}", new Object[]{imageUrl});
                }
            } else {
                try {
                    HttpResponse<InputStream> response = HttpUtil.httpClient().send(HttpUtil.toUrl((String)imageUrl).header("Accept", "*/*").build(), HttpResponse.BodyHandlers.ofInputStream());
                    try (InputStream body = response.body();){
                        Files.copy(body, cachedPath, new CopyOption[0]);
                    }
                }
                catch (Exception e) {
                    cachedFile = null;
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                    SilverLogger.getLogger((Object)this).warn("impossible to save image from URL {0}", new Object[]{imageUrl});
                    if (!(e instanceof InterruptedException)) break block12;
                    Thread.currentThread().interrupt();
                }
            }
        }
        return cachedFile;
    }

    boolean isBasedOnIPTC() {
        return StringUtil.isDefined((String)this.getIPTCPropertyForHD()) || StringUtil.isDefined((String)this.getIPTCPropertyForThumbnails());
    }

    boolean isDefinedForThumbnails() {
        return StringUtil.isDefined((String)this.getIPTCPropertyForThumbnails()) || StringUtil.isDefined((String)this.getTextForThumbnails()) || this.getImageForThumbnails() != null;
    }
}

