/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.mp4;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.Mp4Directory;
import java.io.IOException;

public abstract class Mp4Handler<T extends Mp4Directory> {
    @NotNull
    protected Metadata metadata;
    @NotNull
    protected T directory;

    public Mp4Handler(@NotNull Metadata metadata) {
        this.metadata = metadata;
        this.directory = this.getDirectory();
        metadata.addDirectory(this.directory);
    }

    @NotNull
    protected abstract T getDirectory();

    protected abstract boolean shouldAcceptBox(@NotNull String var1);

    protected abstract boolean shouldAcceptContainer(@NotNull String var1);

    protected abstract Mp4Handler<?> processBox(@NotNull String var1, @Nullable byte[] var2, long var3, Mp4Context var5) throws IOException;

    protected Mp4Handler<?> processContainer(@NotNull String type, long boxSize, @NotNull Mp4Context context) throws IOException {
        return this.processBox(type, null, boxSize, context);
    }

    public void addError(@NotNull String message) {
        ((Directory)this.directory).addError(message);
    }
}

