/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningQueryResult;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;

public class DataWarningQuery
extends SilverpeasBean {
    private static final long serialVersionUID = -7619202031176865356L;
    public static final int QUERY_CONDITION_FIRST = 0;
    public static final int QUERY_TYPE_RESULT = 0;
    public static final int QUERY_TYPE_TRIGGER = 1;
    public static final int TRIGGER_CONDITION_SUP = 0;
    public static final int TRIGGER_CONDITION_SUP_OU_EG = 1;
    public static final int TRIGGER_CONDITION_INF = 2;
    public static final int TRIGGER_CONDITION_INF_OU_EG = 3;
    public static final int TRIGGER_CONDITION_EG = 4;
    public static final int TRIGGER_CONDITION_DIF = 5;
    public static final int QUERY_PERSO_NOT_VALID = 0;
    public static final int QUERY_PERSO_VALID = 1;
    public static final String QUERY_PERSO_UID_ID = "QUERY_PERSO_UID_ID";
    public static final String QUERY_PERSO_UID_LOGIN = "QUERY_PERSO_UID_LOGIN";
    public static final String QUERY_PERSO_UID_LASTNAME = "QUERY_PERSO_UID_LASTNAME";
    public static final String QUERY_PERSO_UID_SPECIFICID = "QUERY_PERSO_UID_SPECIFICID";
    public static final String QUERY_PERSO_UID_EMAIL = "QUERY_PERSO_UID_EMAIL";
    private String instanceId;
    private String description = "";
    private String query = "";
    private int queryCondition = 0;
    private int type = 0;
    private long theTrigger = 0L;
    private int theTriggerCondition = 0;
    private long theTriggerPrecedent = 0L;
    private String persoUID = "";
    private int persoColNB = 1;
    private int persoValid = 0;

    public DataWarningQuery() {
    }

    public DataWarningQuery(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getDescription() {
        return this.getNonNullString(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getQuery() {
        return this.getNonNullString(this.query);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getQueryCondition() {
        return this.queryCondition;
    }

    public void setQueryCondition(int queryCondition) {
        this.queryCondition = queryCondition;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getTheTrigger() {
        return this.theTrigger;
    }

    public void setTheTrigger(long theTrigger) {
        this.theTrigger = theTrigger;
    }

    public int getTheTriggerCondition() {
        return this.theTriggerCondition;
    }

    public void setTheTriggerCondition(int theTriggerCondition) {
        this.theTriggerCondition = theTriggerCondition;
    }

    public long getTheTriggerPrecedent() {
        return this.theTriggerPrecedent;
    }

    public void setTheTriggerPrecedent(long theTriggerPrecedent) {
        this.theTriggerPrecedent = theTriggerPrecedent;
    }

    @NonNull
    protected String getTableName() {
        return "SC_DataWarning_Query";
    }

    public DataWarningQueryResult executeQuery(DataWarning dataModel) {
        DataWarningQueryResult result = new DataWarningQueryResult(this, this.getPersoValid() == 1, this.getPersoColNB(), this.getPersoUID());
        try (Connection con = dataModel.openConnection();
             PreparedStatement prepStmt = con.prepareStatement(this.getQuery());
             ResultSet rs = prepStmt.executeQuery();){
            ResultSetMetaData rsmd;
            if (rs != null && (rsmd = rs.getMetaData()) != null) {
                DataWarningQuery.buildDataWarningQueryResultFrom(result, dataModel, rsmd, rs);
            }
        }
        catch (Exception e) {
            result.addError(e, this.getQuery());
            SilverLogger.getLogger((Object)((Object)this)).error("Fail to execute query " + this.getQuery(), (Throwable)e);
        }
        return result;
    }

    private static void buildDataWarningQueryResultFrom(DataWarningQueryResult result, DataWarning dataModel, ResultSetMetaData rsmd, ResultSet rs) throws SQLException {
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            result.addColumn(rsmd.getColumnName(i));
        }
        for (int j = 1; rs.next() && (dataModel.getRowLimit() <= 0 || j <= dataModel.getRowLimit()); ++j) {
            ArrayList<String> row = new ArrayList<String>();
            for (int k = 1; k < rsmd.getColumnCount() + 1; ++k) {
                row.add(rs.getString(k));
            }
            result.addRow(row);
        }
    }

    public boolean checkTriggerSatisfied(long theValue) {
        boolean valret = true;
        switch (this.theTriggerCondition) {
            case 0: {
                valret = theValue > this.theTrigger;
                break;
            }
            case 1: {
                valret = theValue >= this.theTrigger;
                break;
            }
            case 2: {
                valret = theValue < this.theTrigger;
                break;
            }
            case 3: {
                valret = theValue <= this.theTrigger;
                break;
            }
            case 4: {
                valret = theValue == this.theTrigger;
                break;
            }
            case 5: {
                valret = theValue != this.theTrigger;
                break;
            }
        }
        return valret;
    }

    public int getPersoColNB() {
        return this.persoColNB;
    }

    public void setPersoColNB(int persoColNB) {
        this.persoColNB = persoColNB;
    }

    public String getPersoUID() {
        return this.persoUID;
    }

    public void setPersoUID(String persoUID) {
        this.persoUID = persoUID;
    }

    public int getPersoValid() {
        return this.persoValid;
    }

    public void setPersoValid(int persoValid) {
        this.persoValid = persoValid;
    }
}

