/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.service;

import java.util.Optional;
import java.util.function.Predicate;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;

public class BlogFilters {
    private final boolean getDraftIfNotCreator;
    private int maxResult = 0;
    private String creatorId = null;

    public BlogFilters(boolean getDraftIfNotCreator) {
        this.getDraftIfNotCreator = getDraftIfNotCreator;
    }

    public BlogFilters withCreatorId(String creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    public BlogFilters withMaxResult(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public Predicate<PublicationDetail> toPredicate() {
        return p -> !p.isDraft() || this.getDraftIfNotCreator || p.getCreatorId().equals(this.creatorId);
    }

    public Optional<Integer> getMaxResult() {
        return Optional.of(this.maxResult).filter(l -> l > 0);
    }
}

