/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog;

import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;

@Named
public class BlogInstancePostConstruction
implements ComponentInstancePostConstruction {
    @Transactional
    public void postConstruct(String componentInstanceId) {
        NodeService nodeService = NodeService.get();
        NodeDetail rootCategory = this.getCategoryRootNodeFor(componentInstanceId);
        NodeDetail rootArchive = this.getArchiveRootNodeFor(componentInstanceId);
        nodeService.createNode(rootCategory);
        nodeService.createNode(rootArchive);
    }

    private NodeDetail getCategoryRootNodeFor(String componentInstanceId) {
        NodeDetail rootCategory = this.createNode("0", componentInstanceId);
        rootCategory.setName("Accueil Cat\u00e9gories");
        rootCategory.setDescription("Racine Cat\u00e9gories");
        return rootCategory;
    }

    private NodeDetail getArchiveRootNodeFor(String componentInstanceId) {
        NodeDetail rootArchive = this.createNode("1", componentInstanceId);
        rootArchive.setName("Accueil Archives");
        rootArchive.setDescription("Racine Archives");
        return rootArchive;
    }

    private NodeDetail createNode(String id, String componentInstanceId) {
        NodeDetail rootNode = new NodeDetail();
        rootNode.setNodePK(new NodePK(id, componentInstanceId));
        rootNode.setFatherPK(null);
        rootNode.setUseId(true);
        rootNode.setCreatorId(UserDetail.getCurrentRequester().getId());
        rootNode.setLevel(1);
        rootNode.setStatus("Visible");
        return rootNode;
    }
}

