/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.dom.ParentNode;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.dom.element.form.FormTextElement;
import org.odftoolkit.odfdom.dom.element.form.FormTextareaElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.w3c.dom.Node;

public class TextBox
extends FormControl {
    private boolean isMultipleLine = false;

    TextBox(OdfElement element) {
        if (element instanceof FormTextareaElement) {
            this.isMultipleLine = true;
            this.mElement = (FormTextareaElement)element;
        } else {
            this.mElement = (FormTextElement)element;
        }
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static TextBox getInstanceOf(OdfElement element) {
        TextBox textbox = new TextBox(element);
        try {
            textbox.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e) {
            Logger.getLogger(TextBox.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this textbox.");
        }
        return textbox;
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = this.isMultipleLine ? ((FormTextareaElement)this.mElement).newFormPropertiesElement() : ((FormTextElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        if (this.isMultipleLine) {
            ((FormTextareaElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
        } else {
            ((FormTextElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
        }
    }

    @Override
    public String getId() {
        String formId = this.isMultipleLine ? ((FormTextareaElement)this.mElement).getFormIdAttribute() : ((FormTextElement)this.mElement).getFormIdAttribute();
        return formId;
    }

    @Override
    public void setId(String id) {
        if (this.isMultipleLine) {
            ((FormTextareaElement)this.mElement).setFormIdAttribute(id);
        } else {
            ((FormTextElement)this.mElement).setFormIdAttribute(id);
        }
    }

    @Override
    public String getName() {
        String name = this.isMultipleLine ? ((FormTextareaElement)this.mElement).getFormNameAttribute() : ((FormTextElement)this.mElement).getFormNameAttribute();
        return name;
    }

    @Override
    public void setName(String name) {
        if (this.isMultipleLine) {
            ((FormTextareaElement)this.mElement).setFormNameAttribute(name);
        } else {
            ((FormTextElement)this.mElement).setFormNameAttribute(name);
        }
    }

    public void setValue(String defaultValue) {
        if (this.isMultipleLine) {
            ((FormTextareaElement)this.mElement).setFormValueAttribute(defaultValue);
        } else {
            ((FormTextElement)this.mElement).setFormValueAttribute(defaultValue);
        }
    }

    public String getValue() {
        if (this.isMultipleLine) {
            return ((FormTextareaElement)this.mElement).getFormValueAttribute();
        }
        return ((FormTextElement)this.mElement).getFormValueAttribute();
    }

    public void setCurrentValue(String currentValue) {
        if (this.isMultipleLine) {
            ((FormTextareaElement)this.mElement).setFormCurrentValueAttribute(currentValue);
        } else {
            ((FormTextElement)this.mElement).setFormCurrentValueAttribute(currentValue);
        }
    }

    public String getCurrentValue() {
        if (this.isMultipleLine) {
            return ((FormTextareaElement)this.mElement).getFormCurrentValueAttribute();
        }
        return ((FormTextElement)this.mElement).getFormCurrentValueAttribute();
    }

    public static Iterator<FormControl> getSimpleIterator(Form container) {
        return new SimpleTextBoxIterator(container);
    }

    private static class SimpleTextBoxIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private TextBox nextElement = null;
        private TextBox tempElement = null;

        private SimpleTextBoxIterator(Form container) {
            this.containerElement = container.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public TextBox next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private TextBox findNext(TextBox thisTextBox) {
            OdfElement nextTextBox = null;
            if (thisTextBox == null) {
                if (this.containerElement != null && this.containerElement instanceof ParentNode) {
                    Node node;
                    for (node = this.containerElement.getFirstChild(); node != null && !FormTextareaElement.class.isInstance(node) && !FormTextElement.class.isInstance(node); node = node.getNextSibling()) {
                    }
                    if (node != null) {
                        nextTextBox = (OdfElement)node;
                    }
                }
            } else {
                OdfElement refNode = thisTextBox.getOdfElement();
                if (refNode != null) {
                    Node node;
                    for (node = refNode.getNextSibling(); node != null && !FormTextareaElement.class.isInstance(node) && !FormTextElement.class.isInstance(node); node = node.getNextSibling()) {
                    }
                    if (node != null) {
                        nextTextBox = (OdfElement)node;
                    }
                }
            }
            if (nextTextBox != null) {
                return TextBox.getInstanceOf(nextTextBox);
            }
            return null;
        }
    }
}

