/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.HashMap;
import java.util.Map;
import net.rootdev.javardfa.StatementSink;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.rdfa.EvalContext;
import org.odftoolkit.odfdom.pkg.rdfa.URIExtractor;
import org.w3c.dom.Node;

public class JenaSink
implements StatementSink {
    private Node contextNode;
    private OdfFileDom mFileDom;
    private Map<String, Resource> bnodeLookup;
    private URIExtractor extractor;
    private EvalContext context;

    public JenaSink(OdfFileDom mFileDom) {
        this.mFileDom = mFileDom;
        this.bnodeLookup = new HashMap<String, Resource>();
    }

    public void start() {
        this.bnodeLookup = new HashMap<String, Resource>();
    }

    public void end() {
        this.bnodeLookup = null;
    }

    public void addObject(String subject, String predicate, String object) {
        Model model = this.getContextModel();
        Resource s = this.getResource(model, subject.trim());
        Property p = model.createProperty(predicate.trim());
        Resource o = this.getResource(model, object.trim());
        model.add(s, p, (RDFNode)o);
    }

    public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
        if (lex.isEmpty()) {
            return;
        }
        Model model = this.getContextModel();
        Resource s = this.getResource(model, subject.trim());
        Property p = model.createProperty(predicate.trim());
        Literal o = lang == null && datatype == null ? model.createLiteral(lex.trim()) : (lang != null ? model.createLiteral(lex.trim(), lang.trim()) : model.createTypedLiteral(lex.trim(), datatype.trim()));
        model.add(s, p, (RDFNode)o);
    }

    private Resource getResource(Model model, String res) {
        if (res.startsWith("_:")) {
            if (this.bnodeLookup.containsKey(res)) {
                return this.bnodeLookup.get(res);
            }
            Resource bnode = model.createResource();
            this.bnodeLookup.put(res, bnode);
            return bnode;
        }
        return model.createResource(res);
    }

    public void addPrefix(String prefix, String uri) {
    }

    public void setBase(String base) {
    }

    private Model getContextModel() {
        Map<Node, Model> cache = this.mFileDom.getInContentMetadataCache();
        Model model = cache.get(this.contextNode);
        if (model == null) {
            model = ModelFactory.createDefaultModel();
            this.mFileDom.getInContentMetadataCache().put(this.contextNode, model);
        }
        return model;
    }

    public Node getContextNode() {
        return this.contextNode;
    }

    public void setContextNode(Node contextNode) {
        this.contextNode = contextNode;
    }

    public URIExtractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(URIExtractor extractor) {
        this.extractor = extractor;
    }

    public EvalContext getContext() {
        return this.context;
    }

    public void setContext(EvalContext context) {
        this.context = context;
    }
}

