/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs;

import edu.psu.swe.commons.jaxrs.adapters.XmlStatusAdapter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ErrorMessage {
    @XmlElement(name="status")
    @XmlJavaTypeAdapter(value=XmlStatusAdapter.class)
    private Response.Status status;
    @XmlElementWrapper(name="errorMessageList")
    @XmlElement(name="errorMessage")
    List<String> errorMessages = new ArrayList<String>();
    @XmlElementWrapper(name="referenceList", nillable=true)
    @XmlElement(name="link", nillable=true)
    List<String> externalLinks = null;
    Map<String, Object> headerMap = new HashMap<String, Object>();

    public ErrorMessage() {
    }

    public ErrorMessage(Response.Status status) {
        this.status = status;
    }

    public void setStatus(Response.Status status) {
        this.status = status;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeader(String header, Object value) {
        this.headerMap.put(header, value);
    }

    public Object removeHeader(String header) {
        return this.headerMap.remove(header);
    }

    public void setErrorMessageList(List<String> messageList) {
        if (messageList == null) {
            this.errorMessages.clear();
        } else {
            this.errorMessages = messageList;
        }
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public List<String> getErrorMessageList() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public void setExternalLinkList(List<String> linkList) {
        this.externalLinks = linkList;
    }

    public void addExtenalLink(URL link) {
        if (this.externalLinks == null) {
            this.externalLinks = new ArrayList<String>();
        }
        this.externalLinks.add(link.toString());
    }

    public List<String> getExternalLinkList() {
        return this.externalLinks;
    }

    public Response toResponse() {
        return this.buildResponse(this.status).build();
    }

    public Response toResponse(String mediaType) {
        return this.buildResponse(this.status).type(mediaType).build();
    }

    public Response toResponse(MediaType mediaType) {
        return this.buildResponse(this.status).type(mediaType).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Status = ");
        sb.append(this.status.getStatusCode());
        sb.append("\n");
        if (this.errorMessages != null) {
            sb.append("Error Messages");
            sb.append("\n");
            for (String s : this.errorMessages) {
                sb.append(s);
                sb.append("\n");
            }
        }
        if (this.externalLinks != null) {
            sb.append("External Links");
            for (String s : this.externalLinks) {
                sb.append(s);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private Response.ResponseBuilder buildResponse(Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        for (Map.Entry<String, Object> entry : this.headerMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            builder.header(key, value);
        }
        builder.entity((Object)this);
        return builder;
    }
}

