/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.model;

import javax.inject.Inject;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.notification.ComponentInstanceEvent;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class CommunityOfUsersRemovingListener
extends CDIResourceEventListener<ComponentInstanceEvent> {
    @Inject
    private Administration administration;

    public void onRemoving(ComponentInstanceEvent event) {
        ComponentInst componentInstance = (ComponentInst)event.getTransition().getBefore();
        CommunityOfUsers.getByComponentInstanceId(componentInstance.getId()).filter(c -> c.groupId != null).ifPresent(c -> {
            String groupId = String.valueOf(c.groupId);
            Transaction.performInOne(() -> {
                this.administration.removeGroup(groupId);
                return null;
            });
        });
    }

    public void onRecovery(ComponentInstanceEvent event) {
        ComponentInst componentInstance = (ComponentInst)event.getTransition().getBefore();
        CommunityOfUsers.getByComponentInstanceId(componentInstance.getId()).filter(c -> c.groupId != null).ifPresent(c -> {
            String groupId = String.valueOf(c.groupId);
            Transaction.performInOne(() -> {
                this.administration.restoreGroup(groupId);
                return null;
            });
        });
    }
}

