/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.jdbcconnector.service;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.jdbcconnector.model.DataSourceConnectionInfo;
import org.silverpeas.components.jdbcconnector.model.DataSourceConnectionInfoRepository;
import org.silverpeas.components.jdbcconnector.model.DataSourceDefinition;
import org.silverpeas.components.jdbcconnector.service.DataSourceConnectionInfoService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional
public class SimpleDataSourceConnectionInfoService
implements DataSourceConnectionInfoService {
    private static final SettingBundle dataSources = ResourceLocator.getSettingBundle((String)"org.silverpeas.jdbcConnector.settings.dataSources");
    @Inject
    private DataSourceConnectionInfoRepository repository;

    @Override
    public List<DataSourceConnectionInfo> getConnectionInfoList(String instanceId) {
        return this.repository.findByInstanceId(instanceId);
    }

    @Override
    public void removeConnectionInfo(DataSourceConnectionInfo connectionInfo) {
        this.repository.delete((IdentifiableEntity[])new DataSourceConnectionInfo[]{connectionInfo});
    }

    @Override
    public void removeConnectionInfoOfComponentInstance(String componentInstanceId) {
        this.repository.deleteByInstanceId(componentInstanceId);
    }

    @Override
    public DataSourceConnectionInfo getConnectionInfo(String id) {
        return (DataSourceConnectionInfo)this.repository.getById(id);
    }

    @Override
    public DataSourceConnectionInfo saveConnectionInfo(DataSourceConnectionInfo connectionInfo) {
        return (DataSourceConnectionInfo)this.repository.save((IdentifiableEntity)connectionInfo);
    }

    @Override
    public List<DataSourceDefinition> getAllDataSourceDefinitions() {
        int count = dataSources.getInteger("dataSource.count", 0);
        ArrayList<DataSourceDefinition> dataSourceDefinitions = new ArrayList<DataSourceDefinition>(count);
        for (int i = 0; i < count; ++i) {
            String jndiName = dataSources.getString("dataSource." + i + ".name");
            String description = dataSources.getString("dataSource." + i + ".description");
            if (StringUtil.isNotDefined((String)description)) {
                description = "";
            }
            dataSourceDefinitions.add(new DataSourceDefinition(jndiName, description));
        }
        return dataSourceDefinitions;
    }
}

