/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ComparisonChain;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.jetbrains.annotations.NotNull;

public final class FormatVersion
implements Comparable<FormatVersion> {
    static final FormatVersion V0 = new FormatVersion(0, 0, 0);
    static final FormatVersion V1_0 = new FormatVersion(1, 0, 0);
    static final FormatVersion V1_2 = new FormatVersion(1, 2, 0);
    static final FormatVersion V1_4 = new FormatVersion(1, 4, 0);
    static final FormatVersion V1_6 = new FormatVersion(1, 6, 0);
    static final FormatVersion V1_8 = new FormatVersion(1, 8, 0);
    private static final String VERSION_ID = "version";
    private static final String PROP_VERSION = "_v";
    private final int major;
    private final int minor;
    private final int micro;

    public static Iterable<FormatVersion> values() {
        return ImmutableList.of((Object)V0, (Object)V1_0, (Object)V1_2, (Object)V1_4, (Object)V1_6, (Object)V1_8);
    }

    private FormatVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public boolean canRead(FormatVersion other) {
        return this.compareTo((FormatVersion)Preconditions.checkNotNull((Object)other)) >= 0;
    }

    @NotNull
    public static FormatVersion versionOf(@NotNull DocumentStore store) throws DocumentStoreException {
        Object p;
        Preconditions.checkNotNull((Object)store);
        FormatVersion v = V0;
        Document d = store.find(Collection.SETTINGS, VERSION_ID);
        if (d != null && (p = d.get(PROP_VERSION)) != null) {
            try {
                v = FormatVersion.valueOf(p.toString());
            }
            catch (IllegalArgumentException e) {
                throw new DocumentStoreException(e);
            }
        }
        return v;
    }

    public boolean writeTo(@NotNull DocumentStore store) throws DocumentStoreException {
        UpdateOp op;
        Preconditions.checkNotNull((Object)store);
        FormatVersion v = FormatVersion.versionOf(store);
        if (v == this) {
            return false;
        }
        if (!this.canRead(v)) {
            throw FormatVersion.unableToWrite("Version " + this + " cannot read " + v);
        }
        ArrayList active = Lists.newArrayList();
        for (ClusterNodeInfoDocument d : ClusterNodeInfoDocument.all(store)) {
            if (!d.isActive()) continue;
            active.add(d.getClusterId());
        }
        if (!active.isEmpty() && v != V0) {
            throw FormatVersion.unableToWrite("There are active cluster nodes: " + active);
        }
        if (v == V0) {
            op = new UpdateOp(VERSION_ID, true);
            op.set(PROP_VERSION, this.toString());
            if (!store.create(Collection.SETTINGS, Lists.newArrayList((Object[])new UpdateOp[]{op}))) {
                throw FormatVersion.concurrentUpdate();
            }
        } else {
            op = new UpdateOp(VERSION_ID, false);
            op.equals(PROP_VERSION, v.toString());
            op.set(PROP_VERSION, this.toString());
            if (store.findAndUpdate(Collection.SETTINGS, op) == null) {
                throw FormatVersion.concurrentUpdate();
            }
        }
        return true;
    }

    public static FormatVersion valueOf(String s) throws IllegalArgumentException {
        String[] parts = s.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException(s);
        }
        int[] elements = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                elements[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(s);
            }
        }
        FormatVersion v = new FormatVersion(elements[0], elements[1], elements[2]);
        for (FormatVersion known : FormatVersion.values()) {
            if (!v.equals(known)) continue;
            v = known;
            break;
        }
        return v;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.micro;
    }

    public boolean equals(Object obj) {
        return obj instanceof FormatVersion && this.compareTo((FormatVersion)obj) == 0;
    }

    @Override
    public int compareTo(@NotNull FormatVersion other) {
        Preconditions.checkNotNull((Object)other);
        return ComparisonChain.start().compare(this.major, other.major).compare(this.minor, other.minor).compare(this.micro, other.micro).result();
    }

    private static DocumentStoreException concurrentUpdate() {
        return FormatVersion.unableToWrite("Version was updated concurrently");
    }

    private static DocumentStoreException unableToWrite(String reason) {
        return new DocumentStoreException("Unable to write format version. " + reason);
    }
}

