/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "http://www.silverpeas.org/legal/licensing"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception. You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.components.survey.notification;

import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.user.RemoveSenderRecipientBehavior;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerDetail;

import java.util.ArrayList;
import java.util.Collection;

/**
 * The centralization of the construction of the survey notifications
 * @author Cécile Bonin
 */
public class SurveyUserNotification
    extends AbstractSurveyUserNotification implements RemoveSenderRecipientBehavior {

  private final Collection<String> userIdsToNotify;

  public SurveyUserNotification(final QuestionContainerDetail surveyDetail, final UserDetail userDetail,
      final UserDetail[] participants) {
    super(surveyDetail, userDetail);
    Collection<String> userIds = new ArrayList<>();
    for (UserDetail participant : participants) {
      userIds.add(participant.getId());
    }
    this.userIdsToNotify = userIds;
  }

  @Override
  protected String getTemplateFileName() {
    return "alertResultSurvey";
  }

  @Override
  protected Collection<String> getUserIdsToNotify() {
    return this.userIdsToNotify;
  }
}
