/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.silvercrawler.statistic;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.silverpeas.components.silvercrawler.model.SilverCrawlerRuntimeException;
import org.silverpeas.components.silvercrawler.statistic.HistoryByUser;
import org.silverpeas.components.silvercrawler.statistic.HistoryDAO;
import org.silverpeas.components.silvercrawler.statistic.HistoryDetail;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class Statistic {
    private static final String HISTORY_TABLE_NAME = "SC_SilverCrawler_Statistic";
    public static final String DIRECTORY = "Directory";
    public static final String FILE = "File";

    private Statistic() {
    }

    private static Connection getConnection() {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (SQLException e) {
            throw new SilverCrawlerRuntimeException(e);
        }
        return con;
    }

    public static void addStat(String userId, File path, String componentId, String objectType) {
        try (Connection con = Statistic.getConnection();){
            HistoryDAO.add(con, HISTORY_TABLE_NAME, userId, path.getAbsolutePath(), componentId, objectType);
            if (objectType.equals(DIRECTORY)) {
                Statistic.processFileList(con, path, userId, componentId);
            }
        }
        catch (Exception e) {
            throw new SilverCrawlerRuntimeException(e);
        }
    }

    private static void processFileList(Connection con, File path, String userId, String componentId) throws SQLException {
        File[] fileList;
        if (path.isDirectory() && (fileList = path.listFiles()) != null) {
            for (File currentFile : fileList) {
                if (currentFile.isDirectory()) {
                    HistoryDAO.add(con, HISTORY_TABLE_NAME, userId, currentFile.getAbsolutePath(), componentId, DIRECTORY);
                    Statistic.processFileList(con, currentFile, userId, componentId);
                    continue;
                }
                HistoryDAO.add(con, HISTORY_TABLE_NAME, userId, currentFile.getAbsolutePath(), componentId, FILE);
            }
        }
    }

    public static Collection<HistoryByUser> getHistoryByObject(String path, String componentId) {
        Collection<HistoryDetail> list = Statistic.getHistoryByAction(path, componentId);
        OrganizationController orga = OrganizationControllerProvider.getOrganisationController();
        ArrayList<HistoryByUser> statByUser = new ArrayList<HistoryByUser>();
        for (HistoryDetail historyObject : list) {
            Iterator itStat = statByUser.iterator();
            boolean trouve = false;
            while (itStat.hasNext()) {
                HistoryByUser historyUser = (HistoryByUser)itStat.next();
                if (!historyUser.getUser().getId().equals(historyObject.getUserId())) continue;
                long currentLastAccess = historyUser.getLastDownload().getTime();
                long newDate = historyObject.getDate().getTime();
                if (newDate > currentLastAccess) {
                    historyUser.setLastDownload(new Date(newDate));
                }
                historyUser.setNbDownload(historyUser.getNbDownload() + 1);
                trouve = true;
            }
            if (trouve) continue;
            UserDetail user = (UserDetail)orga.getUserDetail(historyObject.getUserId());
            HistoryByUser historyByUser = new HistoryByUser(user, historyObject.getDate(), 1);
            statByUser.add(historyByUser);
        }
        return statByUser;
    }

    public static Collection<HistoryDetail> getHistoryByAction(String path, String componentId) {
        Collection<HistoryDetail> collection;
        block8: {
            Connection con = Statistic.getConnection();
            try {
                collection = HistoryDAO.getHistoryDetailByObject(con, HISTORY_TABLE_NAME, path, componentId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverCrawlerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    public static Collection<HistoryDetail> getHistoryByObjectAndUser(String path, String userId, String componentId) {
        Collection<HistoryDetail> collection;
        block8: {
            Connection con = Statistic.getConnection();
            try {
                collection = HistoryDAO.getHistoryDetailByObjectAndUser(con, HISTORY_TABLE_NAME, path, userId, componentId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SilverCrawlerRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    public static void deleteHistoryByObject(String path, String componentId) {
        try (Connection con = Statistic.getConnection();){
            HistoryDAO.deleteHistoryByObject(con, HISTORY_TABLE_NAME, path, componentId);
        }
        catch (Exception e) {
            throw new SilverCrawlerRuntimeException(e);
        }
    }
}

