/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.components.kmelia.KmeliaContentManager;
import org.silverpeas.components.kmelia.KmeliaCopyDetail;
import org.silverpeas.components.kmelia.KmeliaPasteDetail;
import org.silverpeas.components.kmelia.KmeliaPublicationHelper;
import org.silverpeas.components.kmelia.model.KmaxRuntimeException;
import org.silverpeas.components.kmelia.model.KmeliaPublication;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.components.kmelia.model.TopicComparator;
import org.silverpeas.components.kmelia.model.TopicDetail;
import org.silverpeas.components.kmelia.model.ValidatorsList;
import org.silverpeas.components.kmelia.notification.KmeliaDefermentPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaDelayedVisibilityUserNotificationReminder;
import org.silverpeas.components.kmelia.notification.KmeliaModificationPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaNoMoreValidatorPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaNotifyPublicationDocumentUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaNotifyPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaNotifyTopicUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaPendingValidationPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaSubscriptionPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaSupervisorPublicationUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaTopicUserNotification;
import org.silverpeas.components.kmelia.notification.KmeliaValidationPublicationUserNotification;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.components.kmelia.service.KmeliaNodeSimulationElementLister;
import org.silverpeas.components.kmelia.service.KmeliaOperationContext;
import org.silverpeas.components.kmelia.service.KmeliaPublicationSimulationElementLister;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.components.kmelia.service.KmeliaServiceContext;
import org.silverpeas.components.kmelia.service.KmeliaUserTreeViewFilter;
import org.silverpeas.components.kmelia.service.KmeliaValidation;
import org.silverpeas.core.ActionType;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.service.RemovedSpaceAndComponentInstanceChecker;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleAttachment;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.contribution.attachment.notification.AttachmentRef;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSet;
import org.silverpeas.core.contribution.content.wysiwyg.WysiwygException;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.dao.DistributionTreeCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationLink;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.ValidationStep;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.template.form.dao.ModelDAO;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.image.thumbnail.ThumbnailException;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.io.media.image.thumbnail.service.ThumbnailServiceProvider;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.coordinates.model.CoordinatePK;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.node.coordinates.service.CoordinatesService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionManager;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.TodoDetail;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.process.annotation.SimulationActionProcess;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.silverstatistics.access.model.HistoryObjectDetail;
import org.silverpeas.core.silverstatistics.access.service.StatisticService;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.Pagination;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.util.annotation.Action;
import org.silverpeas.core.util.annotation.SourcePK;
import org.silverpeas.core.util.annotation.TargetPK;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Named(value="kmeliaService")
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultKmeliaService
implements KmeliaService {
    private static final String MESSAGES_PATH = "org.silverpeas.kmelia.multilang.kmeliaBundle";
    private static final String SETTINGS_PATH = "org.silverpeas.kmelia.settings.kmeliaSettings";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.kmelia.settings.kmeliaSettings");
    private static final String UNKNOWN = "unknown";
    private static final String PUBLICATION = "Publication";
    private static final String USELESS = "useless";
    private static final String NODE_PREFIX = "Node_";
    private static final String ADMIN_ROLE = "admin";
    private static final String ALIASES_CACHE_KEY = "NEW_PUB_ALIASES";
    private static final Predicate<PublicationDetail> HAS_CLONE = k -> k.isValid() && k.haveGotClone() && !k.isClone();
    @Inject
    private NodeService nodeService;
    @Inject
    private PublicationService publicationService;
    @Inject
    private StatisticService statisticService;
    @Inject
    private PdcManager pdcManager;
    @Inject
    private CoordinatesService coordinatesService;
    @Inject
    private CommentService commentService;
    @Inject
    private AdminController adminController;
    @Inject
    private SilverpeasCalendar calendar;
    @Inject
    private PdcClassificationService pdcClassificationService;
    @Inject
    private PdcSubscriptionManager pdcSubscriptionManager;
    @Inject
    private KmeliaContentManager kmeliaContentManager;

    private int getNbPublicationsOnRoot(String componentId) {
        String parameterValue = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "nbPubliOnRoot");
        if (StringUtil.isDefined((String)parameterValue)) {
            return Integer.parseInt(parameterValue);
        }
        if (KmeliaHelper.isToolbox(componentId)) {
            return 0;
        }
        SettingBundle theSettings = this.getComponentSettings();
        return theSettings.getInteger("HomeNbPublications");
    }

    private boolean isDraftModeUsed(String componentId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "draft"));
    }

    @Override
    public TopicDetail goTo(NodePK pk, String userId, boolean isTreeStructureUsed, String userProfile, boolean mustUserRightsBeChecked) {
        NodeDetail nodeDetail;
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        try {
            nodeDetail = this.nodeService.getDetail(pk);
            if (mustUserRightsBeChecked) {
                if (!NodeAccessControl.get().isUserAuthorized(userId, nodeDetail)) {
                    nodeDetail.setUserRole("noRights");
                }
                List<NodeDetail> availableChildren = this.getAllowedSubfolders(nodeDetail, userId);
                nodeDetail.setChildrenDetails(availableChildren);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        List<KmeliaPublication> pubDetails = this.getAuthorizedPublicationsOfFolder(pk, userProfile, userId, isTreeStructureUsed);
        if (pk.isRoot()) {
            newPath.add(nodeDetail);
        } else {
            newPath = this.getPathFromAToZ(nodeDetail);
        }
        return new TopicDetail(newPath, nodeDetail, pubDetails);
    }

    @Override
    public List<KmeliaPublication> getAuthorizedPublicationsOfFolder(NodePK pk, String userProfile, String userId, boolean isTreeStructureUsed) {
        Collection pubDetails;
        long start = System.currentTimeMillis();
        if (pk.isTrash()) {
            pubDetails = this.getPublicationsInBasket(pk, userProfile, userId);
        } else {
            if (pk.isRoot()) {
                try {
                    int nbPublisOnRoot = this.getNbPublicationsOnRoot(pk.getInstanceId());
                    if (nbPublisOnRoot != 0 && isTreeStructureUsed && !KmeliaHelper.isToolbox(pk.getInstanceId())) {
                        return this.getLatestAuthorizedPublications(pk.getInstanceId(), userId, nbPublisOnRoot);
                    }
                    pubDetails = this.publicationService.getDetailsByFatherPK(pk, "P.pubUpdateDate desc", false);
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException(e);
                }
            }
            try {
                pubDetails = this.publicationService.getDetailsByFatherPK(pk, "P.pubUpdateDate DESC, P.pubId DESC", false);
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException(e);
            }
        }
        List<KmeliaPublication> result = this.filterPublications(this.asLocatedKmeliaPublication(pk, pubDetails), pk.getInstanceId(), SilverpeasRole.fromString((String)userProfile), userId);
        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("getting {0} publications of folder {1} in {2}", result.size(), pk, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))));
        return result;
    }

    @Override
    public List<KmeliaPublication> getLatestAuthorizedPublications(String instanceId, String userId, int limit) {
        long start = System.currentTimeMillis();
        List result = (List)CacheAccessorProvider.getThreadCacheAccessor().getCache().computeIfAbsent((Object)("KmeliaService:getLatestAuthorizedPublications:" + instanceId + ":" + userId + ":" + limit), List.class, () -> {
            SilverpeasList pubDetails = this.publicationService.getAuthorizedPublicationsForUserByCriteria(userId, PublicationCriteria.excludingTrashNodeOnComponentInstanceIds((String[])new String[]{instanceId}).excludingNodes(new String[]{"0"}).ofStatus(new String[]{"Valid"}).visibleAt(OffsetDateTime.now()).takingAliasesIntoAccount().orderByDescendingBeginDate().limitTo(limit));
            return this.asKmeliaPublication((Collection<PublicationDetail>)pubDetails);
        });
        int size = result == null ? 0 : result.size();
        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("getting {0} latest authorized publications of instance {1} in {2}", size, instanceId, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))));
        return result;
    }

    @Override
    public List<NodeDetail> getAllowedSubfolders(NodeDetail folder, String userId) {
        List children = (List)folder.getChildrenDetails();
        ArrayList<NodeDetail> availableChildren = new ArrayList<NodeDetail>();
        for (NodeDetail child : children) {
            NodePK childId = child.getNodePK();
            if (childId.isTrash() || childId.isUnclassed() || !child.haveRights()) {
                availableChildren.add(child);
                continue;
            }
            this.addAccordingToRights(userId, availableChildren, child);
        }
        return availableChildren;
    }

    private void addAccordingToRights(String userId, List<NodeDetail> availableChildren, NodeDetail child) {
        String rightsDependsOn = child.getRightsDependsOn();
        boolean nodeAvailable = OrganizationControllerProvider.getOrganisationController().isObjectAvailableToUser(ProfiledObjectId.fromNode((String)rightsDependsOn), child.getNodePK().getInstanceId(), userId);
        if (nodeAvailable) {
            availableChildren.add(child);
        } else {
            Iterator<NodeDetail> descendants = this.nodeService.getDescendantDetails(child).iterator();
            this.addDescendantIfAvailable(userId, availableChildren, child, rightsDependsOn, descendants);
        }
    }

    private void addDescendantIfAvailable(String userId, List<NodeDetail> availableChildren, NodeDetail child, String rightsDependsOn, Iterator<NodeDetail> descendants) {
        boolean childAllowed = false;
        while (!childAllowed && descendants.hasNext()) {
            NodeDetail descendant = descendants.next();
            if (descendant.getRightsDependsOn().equals(rightsDependsOn) || !OrganizationControllerProvider.getOrganisationController().isObjectAvailableToUser(ProfiledObjectId.fromNode((String)descendant.getRightsDependsOn()), descendant.getNodePK().getInstanceId(), userId)) continue;
            childAllowed = true;
            if (availableChildren.contains(child)) continue;
            availableChildren.add(child);
        }
    }

    private Collection<NodeDetail> getPathFromAToZ(NodeDetail nd) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        try {
            NodePath pathInReverse = this.nodeService.getPath(nd.getNodePK());
            for (int i = pathInReverse.size() - 1; i >= 0; --i) {
                newPath.add((NodeDetail)pathInReverse.get(i));
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return newPath;
    }

    @Override
    public NodeDetail addToTopic(NodePK fatherPK, NodeDetail subTopic) {
        try {
            NodeDetail fatherDetail = this.nodeService.getHeader(fatherPK);
            return this.nodeService.createNode(subTopic, fatherDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public NodeDetail addSubTopic(NodePK fatherPK, NodeDetail subTopic, String alertType) {
        subTopic.setCreationDate(new Date());
        subTopic.setStatus("Invisible");
        NodeDetail addedTopic = this.addToTopic(fatherPK, subTopic);
        subTopic.setNodePK(addedTopic.getNodePK());
        subTopic.setFatherPK(fatherPK);
        this.topicCreationAlert(subTopic, NotifAction.CREATE, alertType);
        return addedTopic;
    }

    private void topicCreationAlert(NodeDetail node, NotifAction action, String alertType) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaTopicUserNotification(node, action, alertType));
    }

    @Override
    public NodeDetail updateTopic(NodeDetail topic, String alertType) {
        NodeDetail oldNode = this.nodeService.getHeader(topic.getNodePK());
        int order = oldNode.getOrder();
        topic.setOrder(order);
        this.nodeService.setDetail(topic);
        if (this.isRightsOnTopicsEnabled(topic.getNodePK().getInstanceId())) {
            this.updateNode(topic, oldNode);
        }
        topic.setFatherPK(oldNode.getFatherPK());
        this.topicCreationAlert(topic, NotifAction.UPDATE, alertType);
        return topic;
    }

    private void updateNode(NodeDetail newNode, NodeDetail oldNode) {
        if (!oldNode.getRightsDependsOn().equals(newNode.getRightsDependsOn())) {
            if (!newNode.haveRights()) {
                NodeDetail father = this.nodeService.getHeader(oldNode.getFatherPK());
                newNode.setRightsDependsOn(father.getRightsDependsOn());
                List profiles = this.adminController.getProfilesByObject(ProfiledObjectId.fromNode((String)newNode.getNodePK().getId()), newNode.getNodePK().getInstanceId());
                this.deleteProfiles(profiles);
            } else {
                newNode.setRightsDependsOnMe();
            }
            this.nodeService.updateRightsDependency(newNode);
        }
    }

    private void deleteProfiles(List<ProfileInst> profiles) {
        for (ProfileInst profile : profiles) {
            this.adminController.deleteProfileInst(profile.getId());
        }
    }

    @Override
    public NodeDetail getSubTopicDetail(NodePK pk) {
        NodeDetail subTopic;
        try {
            subTopic = this.nodeService.getDetail(pk);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return subTopic;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteTopic(NodePK pkToDelete) {
        try {
            Collection nodesToDelete = this.nodeService.getDescendantPKs(pkToDelete);
            nodesToDelete.add(pkToDelete);
            for (NodePK oneNodeToDelete : nodesToDelete) {
                Collection pubsToCheck = this.publicationService.getDetailsByFatherPK(oneNodeToDelete);
                for (PublicationDetail onePubToCheck : pubsToCheck) {
                    KmeliaPublication kmeliaPub = KmeliaPublication.fromDetail(onePubToCheck, oneNodeToDelete);
                    if (!kmeliaPub.isAlias()) {
                        this.sendPublicationToBasket(kmeliaPub.getPk());
                        continue;
                    }
                    List<Location> aliases = Collections.singletonList(kmeliaPub.getLocation());
                    this.publicationService.removeAliases(kmeliaPub.getPk(), aliases);
                }
            }
            this.nodeService.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void changeTopicStatus(String newStatus, NodePK nodePK, boolean recursiveChanges) {
        try {
            if (!recursiveChanges) {
                NodeDetail nodeDetail = this.nodeService.getHeader(nodePK);
                this.changeTopicStatus(newStatus, nodeDetail);
            } else {
                List subTree = this.nodeService.getSubTree(nodePK);
                for (NodeDetail aSubTree : subTree) {
                    this.changeTopicStatus(newStatus, aSubTree);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void sortSubTopics(NodePK fatherPK, boolean recursive, String[] criteria) {
        List subTopics;
        try {
            subTopics = (List)this.nodeService.getChildrenDetails(fatherPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        if (subTopics != null && !subTopics.isEmpty()) {
            subTopics.sort(new TopicComparator(criteria));
            for (int i = 0; i < subTopics.size(); ++i) {
                NodeDetail nodeDetail = (NodeDetail)subTopics.get(i);
                try {
                    nodeDetail.setOrder(i);
                    this.nodeService.setDetail(nodeDetail);
                }
                catch (Exception e) {
                    throw new KmeliaRuntimeException(e);
                }
                if (!recursive) continue;
                this.sortSubTopics(nodeDetail.getNodePK(), true, criteria);
            }
        }
    }

    private void changeTopicStatus(String newStatus, NodeDetail topic) {
        try {
            topic.setStatus(newStatus);
            this.nodeService.setDetail(topic);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public List<NodeDetail> getTreeview(NodePK nodePK, String profile, boolean coWritingEnable, boolean draftVisibleWithCoWriting, String userId, boolean displayNb, boolean isRightsOnTopicsUsed) {
        long start = System.currentTimeMillis();
        String instanceId = nodePK.getInstanceId();
        List allowedTree = this.nodeService.getSubTree(nodePK);
        if (profile == null) {
            profile = this.getProfile(userId, nodePK);
        }
        KmeliaUserTreeViewFilter.from(userId, instanceId, nodePK, profile, isRightsOnTopicsUsed).setBestUserRoleAndFilter(allowedTree);
        if (displayNb) {
            this.buildTreeView(nodePK, profile, coWritingEnable, draftVisibleWithCoWriting, userId, allowedTree);
        }
        SilverLogger.getLogger((Object)this).debug(() -> MessageFormat.format("getting {0} nodes from folder {1} in {2}", allowedTree.size(), nodePK, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))));
        return allowedTree;
    }

    private void buildTreeView(NodePK nodePK, String profile, boolean coWritingEnable, boolean draftVisibleWithCoWriting, String userId, List<NodeDetail> allowedTree) {
        boolean checkVisibility = false;
        StringBuilder statusSubQuery = new StringBuilder();
        if (profile == null || profile.equals("user")) {
            checkVisibility = true;
            statusSubQuery.append(" AND sb_publication_publi.pubStatus = 'Valid' ");
        } else if (profile.equals("writer")) {
            statusSubQuery.append(" AND (");
            if (coWritingEnable && draftVisibleWithCoWriting) {
                statusSubQuery.append("sb_publication_publi.pubStatus = 'Valid' OR ").append("sb_publication_publi.pubStatus = 'Draft' OR ").append("sb_publication_publi.pubStatus = 'Unvalidate' ");
            } else {
                checkVisibility = true;
                statusSubQuery.append("sb_publication_publi.pubStatus = 'Valid' OR ").append("(sb_publication_publi.pubStatus = 'Draft' AND ").append("sb_publication_publi.pubUpdaterId = '").append(userId).append("') OR (sb_publication_publi.pubStatus = 'Unvalidate' AND ").append("sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
            }
            statusSubQuery.append("OR (sb_publication_publi.pubStatus = 'ToValidate' ").append("AND sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
            statusSubQuery.append("OR sb_publication_publi.pubUpdaterId = '").append(userId).append("')");
        } else {
            statusSubQuery.append(" AND (");
            if (coWritingEnable && draftVisibleWithCoWriting) {
                statusSubQuery.append("sb_publication_publi.pubStatus IN ('Valid','ToValidate','Draft') ");
            } else {
                if (profile.equals("publisher")) {
                    checkVisibility = true;
                }
                statusSubQuery.append("sb_publication_publi.pubStatus IN ('Valid','ToValidate') OR (sb_publication_publi.pubStatus = 'Draft' AND sb_publication_publi.pubUpdaterId = '").append(userId).append("') ");
            }
            statusSubQuery.append("OR sb_publication_publi.pubUpdaterId = '").append(userId).append("')");
        }
        DistributionTreeCriteria criteria = DistributionTreeCriteria.onInstanceId((String)nodePK.getInstanceId()).withVisibilityCheck(checkVisibility).withManualStatusFilter(statusSubQuery.toString());
        Map numbers = this.publicationService.getDistributionTree(criteria);
        NodePK trashPk = new NodePK("1", nodePK.getInstanceId());
        int nbPubsInTrash = this.getPublicationsInBasket(trashPk, profile, userId).size();
        numbers.put("1", nbPubsInTrash);
        this.decorateWithNumberOfPublications(allowedTree, (Map<String, Integer>)numbers);
    }

    private void decorateWithNumberOfPublications(List<NodeDetail> nodes, Map<String, Integer> numbers) {
        for (NodeDetail node : nodes) {
            this.decorateWithNumberOfPublications(node, numbers);
        }
    }

    private int decorateWithNumberOfPublications(NodeDetail node, Map<String, Integer> numbers) {
        Integer nb = numbers.get(node.getNodePK().getId());
        for (NodeDetail child : node.getChildrenDetails()) {
            nb = nb + this.decorateWithNumberOfPublications(child, numbers);
        }
        node.setNbObjects(nb.intValue());
        return nb;
    }

    private Collection<PublicationDetail> getPublicationsInBasket(NodePK pk, String userProfile, String userId) {
        String currentUserId = userId;
        try {
            if (SilverpeasRole.ADMIN.isInRole(new String[]{userProfile})) {
                currentUserId = null;
            }
            return this.publicationService.getDetailsByFatherPK(pk, null, false, currentUserId);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private List<KmeliaPublication> asLocatedKmeliaPublication(NodePK fatherPK, Collection<PublicationDetail> pubDetails) {
        Collection pubIds = pubDetails.stream().map(PublicationDetail::getId).collect(Collectors.toSet());
        Map locationsByPublication = this.publicationService.getAllLocationsByPublicationIds(pubIds);
        return pubDetails.stream().map(p -> KmeliaPublication.fromDetail(p, fatherPK, locationsByPublication)).collect(Collectors.toList());
    }

    private List<KmeliaPublication> asKmeliaPublication(Collection<PublicationDetail> pubDetails) {
        return pubDetails.stream().map(KmeliaPublication::fromDetail).collect(Collectors.toList());
    }

    @Override
    public PublicationDetail getPublicationDetail(PublicationPK pubPK) {
        try {
            return this.publicationService.getDetail(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public Collection<Collection<NodeDetail>> getPathList(PublicationPK pubPK) {
        List fatherPKs;
        try {
            fatherPKs = this.publicationService.getAllFatherPKInSamePublicationComponentInstance(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        try {
            ArrayList<Collection<NodeDetail>> pathList = new ArrayList<Collection<NodeDetail>>();
            if (fatherPKs != null) {
                for (NodePK pk : fatherPKs) {
                    NodePath path = this.nodeService.getPath(pk);
                    pathList.add((Collection<NodeDetail>)path);
                }
            }
            return pathList;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createPublicationIntoTopic(PublicationDetail pubDetail, NodePK fatherPK) {
        PdcClassification predefinedClassification = this.pdcClassificationService.findAPreDefinedClassification(fatherPK.getId(), fatherPK.getInstanceId());
        return this.createPublicationIntoTopic(pubDetail, fatherPK, predefinedClassification);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String createPublicationIntoTopic(PublicationDetail pubDetail, NodePK fatherPK, PdcClassification classification) {
        String pubId;
        KmeliaOperationContext.about(KmeliaOperationContext.OperationType.CREATION);
        try {
            pubId = this.createPublicationIntoTopicWithoutNotifications(pubDetail, fatherPK, classification);
            this.createTodosForPublication(pubDetail, true);
            this.sendAlertToSupervisors(fatherPK, pubDetail);
            this.sendSubscriptionsNotification(pubDetail, NotifAction.CREATE, false);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return pubId;
    }

    private String createPublicationIntoTopicWithoutNotifications(PublicationDetail pubDetail, NodePK fatherPK, PdcClassification classification) {
        PublicationPK pubPK;
        try {
            PublicationDetail detail = this.changePublicationStatusOnCreation(pubDetail, fatherPK);
            pubPK = this.publicationService.createPublication(detail);
            detail.getPK().setId(pubPK.getId());
            this.createSilverContent(detail, detail.getCreatorId());
            this.addPublicationToTopicWithoutNotifications(pubPK, fatherPK, true);
            classification.classifyContent((Contribution)detail, false);
            KmeliaServiceContext.createdIntoRequestContext(detail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return pubPK.getId();
    }

    private String getProfile(String userId, NodePK nodePK) {
        NodeDetail topic;
        OrganizationController orgCtrl = OrganizationControllerProvider.getOrganisationController();
        if (this.isRightsOnTopicsEnabled(nodePK.getInstanceId()) && (topic = this.nodeService.getHeader(nodePK)).haveRights()) {
            ProfiledObjectId nodeId = ProfiledObjectId.fromNode((String)topic.getRightsDependsOn());
            return KmeliaHelper.getProfile(orgCtrl.getUserProfiles(userId, nodePK.getInstanceId(), nodeId));
        }
        return KmeliaHelper.getProfile(this.getUserRoles(nodePK.getInstanceId(), userId));
    }

    private String getProfileOnPublication(String userId, PublicationPK pubPK) {
        NodePK fatherPK = this.getPublicationFatherPK(pubPK);
        return this.getProfileForDirectNodeOfPublication(userId, pubPK, fatherPK);
    }

    private String getProfileForDirectNodeOfPublication(String userId, PublicationPK pubPK, NodePK fatherPK) {
        String profile;
        if (fatherPK != null) {
            profile = this.getProfile(userId, fatherPK);
        } else {
            SilverLogger.getLogger((Object)this).warn("The publication {0} is orphaned!", new Object[]{pubPK});
            profile = SilverpeasRole.getHighestFrom((Collection)SilverpeasRole.fromStrings((String[])OrganizationControllerProvider.getOrganisationController().getUserProfiles(userId, pubPK.getInstanceId()))).getName();
        }
        return profile;
    }

    private PublicationDetail changePublicationStatusOnCreation(PublicationDetail pubDetail, NodePK nodePK) {
        String status = pubDetail.getStatus();
        if (!StringUtil.isDefined((String)status)) {
            status = "ToValidate";
            boolean draftModeUsed = this.isDraftModeUsed(pubDetail.getPK().getInstanceId());
            if (draftModeUsed) {
                status = "Draft";
            } else {
                String profile = this.getProfile(pubDetail.getCreatorId(), nodePK);
                if (SilverpeasRole.PUBLISHER.isInRole(new String[]{profile}) || SilverpeasRole.ADMIN.isInRole(new String[]{profile})) {
                    status = "Valid";
                }
            }
        }
        pubDetail.setStatus(status);
        KmeliaHelper.checkIndex(pubDetail);
        return pubDetail;
    }

    private Pair<Boolean, String> changePublicationStatusOnMove(PublicationDetail pub, NodePK to, String currentUserId) {
        String oldStatus = pub.getStatus();
        String status = pub.getStatus();
        if (!status.equals("Draft")) {
            status = "ToValidate";
            String profile = this.getProfile(currentUserId, to);
            if (SilverpeasRole.PUBLISHER.isInRole(new String[]{profile}) || SilverpeasRole.ADMIN.isInRole(new String[]{profile})) {
                status = "Valid";
            }
        }
        pub.setStatus(status);
        KmeliaHelper.checkIndex(pub);
        return Pair.of((Object)(!oldStatus.equals(status) ? 1 : 0), (Object)status);
    }

    private boolean changePublicationStatusOnUpdate(PublicationDetail pubDetail) {
        String previousStatus = pubDetail.getStatus();
        NodePK father = this.getPublicationFatherPK(pubDetail.getPK());
        String newStatus = pubDetail.isStatusMustBeChecked() && !pubDetail.isDraft() && !pubDetail.isClone() ? this.setPublicationStatus(pubDetail, previousStatus, father) : previousStatus;
        KmeliaHelper.checkIndex(pubDetail);
        if (father == null || father.isTrash()) {
            pubDetail.setIndexOperation(-1);
        }
        return !previousStatus.equalsIgnoreCase(newStatus);
    }

    private String setPublicationStatus(PublicationDetail pubDetail, String newStatus, NodePK father) {
        String profile = this.getProfileForDirectNodeOfPublication(pubDetail.getUpdaterId(), pubDetail.getPK(), father);
        String status = SilverpeasRole.WRITER.isInRole(new String[]{profile}) ? "ToValidate" : (pubDetail.isRefused() && (SilverpeasRole.ADMIN.isInRole(new String[]{profile}) || SilverpeasRole.PUBLISHER.isInRole(new String[]{profile})) ? "Valid" : newStatus);
        pubDetail.setStatus(status);
        return status;
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail) {
        this.updatePublication(pubDetail, 0, false);
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail, PdcClassification classification) {
        this.updatePublication(pubDetail, classification, 0, false);
    }

    @Override
    public void updatePublication(PublicationDetail pubDetail, boolean forceUpdateDate) {
        this.updatePublication(pubDetail, 0, forceUpdateDate);
    }

    private void updatePublication(PublicationDetail pubDetail, int updateScope, boolean forceUpdateDate) {
        this.updatePublication(pubDetail, null, updateScope, forceUpdateDate);
    }

    private void updatePublication(PublicationDetail pubDetail, PdcClassification classification, int updateScope, boolean forceUpdateDate) {
        KmeliaOperationContext.about(KmeliaOperationContext.OperationType.UPDATE);
        try {
            boolean isClone = pubDetail.isClone();
            PublicationDetail old = this.getPublicationDetail(pubDetail.getPK());
            if (StringUtil.isDefined((String)old.getTargetValidatorId()) && !StringUtil.isDefined((String)pubDetail.getTargetValidatorId())) {
                pubDetail.setTargetValidatorId(old.getTargetValidatorId());
            }
            boolean isPublicationInBasket = this.isPublicationInBasket(pubDetail.getPK());
            if (isClone) {
                this.publicationService.setDetail(pubDetail, forceUpdateDate);
                this.performValidatorChanges(old, pubDetail);
            } else {
                boolean statusChanged = this.changePublicationStatusOnUpdate(pubDetail);
                this.publicationService.setDetail(pubDetail, forceUpdateDate);
                if (!isPublicationInBasket) {
                    this.updatePublicationContent(pubDetail, updateScope, old, statusChanged);
                }
            }
            if (classification != null) {
                classification.classifyContentOrClearClassificationIfEmpty((Contribution)pubDetail, false);
            }
            if (!(isPublicationInBasket || KmeliaServiceContext.hasPublicationBeenCreatedFromRequestContext(pubDetail) || KmeliaServiceContext.hasPublicationBeenUpdatedFromRequestContext(pubDetail))) {
                this.sendSubscriptionsNotification(pubDetail, NotifAction.UPDATE, false);
            }
            KmeliaServiceContext.updatedIntoRequestContext(pubDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void updatePublicationContent(PublicationDetail pubDetail, int updateScope, PublicationDetail old, boolean statusChanged) {
        if (statusChanged) {
            this.createTodosForPublication(pubDetail, false);
        } else {
            this.performValidatorChanges(old, pubDetail);
        }
        this.updateSilverContentVisibility(pubDetail);
        String profile = KmeliaHelper.getProfile(this.getUserRoles(pubDetail.getPK().getInstanceId(), pubDetail.getUpdaterId()));
        if ("supervisor".equals(profile)) {
            this.sendModificationAlert(updateScope, pubDetail.getPK());
        }
        boolean visibilityPeriodUpdated = this.isVisibilityPeriodUpdated(pubDetail, old);
        if (statusChanged || visibilityPeriodUpdated) {
            if (KmeliaHelper.isIndexable(pubDetail)) {
                this.indexExternalElementsOfPublication(pubDetail);
            } else {
                this.unIndexExternalElementsOfPublication(pubDetail.getPK());
            }
        }
    }

    private void performValidatorChanges(PublicationDetail previousPublication, PublicationDetail currentPublication) {
        if (currentPublication.isValidationRequired() && currentPublication.getTargetValidatorIds() != null) {
            List<String> oldValidatorIds = Arrays.asList(previousPublication.getTargetValidatorIds());
            List<String> newValidatorIds = Arrays.asList(currentPublication.getTargetValidatorIds());
            ArrayList<String> toRemoveToDo = new ArrayList<String>(oldValidatorIds);
            toRemoveToDo.removeAll(newValidatorIds);
            ValidatorsList toAlert = new ValidatorsList(this.getActiveValidatorIds(currentPublication));
            toAlert.removeAll(oldValidatorIds);
            this.removeTodoForPublication(currentPublication.getPK(), toRemoveToDo);
            this.addTodoAndSendNotificationToValidators(currentPublication, toAlert);
        }
    }

    private boolean isVisibilityPeriodUpdated(PublicationDetail pubDetail, PublicationDetail old) {
        boolean beginVisibilityPeriodUpdated = pubDetail.getBeginDate() != null && old.getBeginDate() == null || pubDetail.getBeginDate() == null && old.getBeginDate() != null || pubDetail.getBeginDate() != null && old.getBeginDate() != null && !pubDetail.getBeginDate().equals(old.getBeginDate());
        boolean endVisibilityPeriodUpdated = pubDetail.getEndDate() != null && old.getEndDate() == null || pubDetail.getEndDate() == null && old.getEndDate() != null || pubDetail.getEndDate() != null && old.getEndDate() != null && !pubDetail.getEndDate().equals(old.getEndDate());
        return beginVisibilityPeriodUpdated || endVisibilityPeriodUpdated;
    }

    @Override
    @Transactional
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void movePublication(@SourcePK PublicationPK pubPK, @TargetPK NodePK to, KmeliaPasteDetail pasteContext) {
        NodePK fromNode = pasteContext.getFromPK();
        KmeliaPublication publication = KmeliaPublication.withPK(pubPK, fromNode);
        if (publication.isAlias()) {
            Location newLocation = new Location(to.getId(), to.getInstanceId());
            newLocation.setAsAlias(pasteContext.getUserId());
            this.publicationService.removeAliases(pubPK, Collections.singletonList(publication.getLocation()));
            this.publicationService.addAliases(pubPK, Collections.singletonList(newLocation));
        } else if (fromNode.getInstanceId().equals(to.getInstanceId())) {
            this.movePublicationInSameApplication(publication.getDetail(), to, pasteContext);
        } else {
            this.movePublicationInAnotherApplication(publication.getDetail(), to, pasteContext);
        }
    }

    @Override
    @Transactional
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void movePublicationInSameApplication(@SourcePK PublicationPK pubPK, @TargetPK NodePK from, KmeliaPasteDetail pasteContext) {
        PublicationDetail pub = this.getPublicationDetail(pubPK);
        String userId = pasteContext.getUserId();
        NodePK to = pasteContext.getToPK();
        String profile = this.getUserTopicProfile(from, userId);
        boolean cutAllowed = KmeliaPublicationHelper.isCanBeCut(from.getComponentName(), userId, profile, pub.getCreator());
        String profileInTarget = this.getUserTopicProfile(to, userId);
        boolean pasteAllowed = KmeliaPublicationHelper.isCreationAllowed(to, profileInTarget);
        if (cutAllowed && pasteAllowed) {
            this.movePublicationInSameApplication(pub, to, pasteContext);
        }
    }

    private void movePublicationInSameApplication(PublicationDetail pub, NodePK to, KmeliaPasteDetail pasteContext) {
        if (to.isTrash()) {
            this.sendPublicationToBasket(pub.getPK());
        } else {
            this.publicationService.movePublication(pub.getPK(), to, false);
            pub.setTargetValidatorId(pasteContext.getTargetValidatorIds());
            this.processPublicationAfterMove(pub, to, pasteContext.getUserId());
        }
    }

    private void movePublicationInAnotherApplication(PublicationDetail pub, NodePK to, KmeliaPasteDetail pasteContext) {
        try {
            ResourceReference fromResourceReference = new ResourceReference((WAPrimaryKey)pub.getPK());
            String fromComponentId = pub.getInstanceId();
            ResourceReference toPubliResourceReference = new ResourceReference(pub.getId(), to.getInstanceId());
            this.unIndexExternalElementsOfPublication(pub.getPK());
            ThumbnailController.moveThumbnail((ResourceReference)fromResourceReference, (ResourceReference)toPubliResourceReference);
            this.moveAdditionalFiles(pub, fromResourceReference, toPubliResourceReference);
            WysiwygController.wysiwygPlaceHaveChanged((String)fromResourceReference.getInstanceId(), (String)pub.getPK().getId(), (String)to.getInstanceId(), (String)pub.getPK().getId());
            SimpleDocumentList docs = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromResourceReference, DocumentType.attachment, null);
            for (SimpleDocument doc : docs) {
                AttachmentServiceProvider.getAttachmentService().moveDocument(doc, toPubliResourceReference);
            }
            String infoId = pub.getInfoId();
            if (infoId != null && !"0".equals(infoId)) {
                PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
                GenericRecordSet toRecordSet = templateManager.addDynamicPublicationTemplate(to.getInstanceId() + ":" + pub.getInfoId(), pub.getInfoId() + ".xml");
                RecordTemplate toRecordTemplate = toRecordSet.getRecordTemplate();
                PublicationTemplate pubTemplateFrom = templateManager.getPublicationTemplate(fromComponentId + ":" + pub.getInfoId());
                RecordSet set = pubTemplateFrom.getRecordSet();
                set.move(fromResourceReference, toPubliResourceReference, toRecordTemplate);
            }
            this.getCommentService().moveComments(PublicationDetail.getResourceType(), fromResourceReference, toPubliResourceReference);
            int fromSilverObjectId = this.getSilverObjectId(pub.getPK());
            List positions = this.pdcManager.getPositions(fromSilverObjectId, fromComponentId);
            this.deleteSilverContent(pub.getPK());
            this.statisticService.moveStat(toPubliResourceReference, 1, PUBLICATION);
            this.publicationService.movePublication(pub.getPK(), to, false);
            pub.getPK().setComponentName(to.getInstanceId());
            pub.setTargetValidatorId(pasteContext.getTargetValidatorIds());
            this.processPublicationAfterMove(pub, to, pasteContext.getUserId());
            if (KmeliaHelper.isIndexable(pub)) {
                this.indexPublication(pub);
            }
            int toSilverObjectId = this.getSilverObjectId(pub.getPK());
            this.pdcManager.addPositions(positions, toSilverObjectId, to.getInstanceId());
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void moveAdditionalFiles(@SourcePK PublicationDetail pub, ResourceReference fromResourceReference, ResourceReference toPubliResourceReference) {
        try {
            SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromResourceReference, DocumentType.image, null);
            documents.addAll(AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromResourceReference, DocumentType.wysiwyg, null));
            for (SimpleDocument doc : documents) {
                AttachmentServiceProvider.getAttachmentService().moveDocument(doc, toPubliResourceReference);
            }
        }
        catch (AttachmentException e) {
            SilverLogger.getLogger((Object)this).error("Cannot move attachments of publication {0}", (Object[])new String[]{pub.getPK().getId()}, (Throwable)e);
        }
    }

    private void processPublicationAfterMove(PublicationDetail pub, NodePK to, String currentUserId) {
        Pair<Boolean, String> statusChanges = this.changePublicationStatusOnMove(pub, to, currentUserId);
        boolean statusChanged = (Boolean)statusChanges.getFirst();
        if (!statusChanged) {
            pub.setUpdateDataMustBeSet(false);
        } else if (!"Valid".equals(statusChanges.getSecond())) {
            pub.setUpdaterId(currentUserId);
        }
        this.publicationService.setDetail(pub, false, ResourceEvent.Type.MOVE);
        this.updateSilverContentVisibility(pub);
        if (statusChanged) {
            this.createTodosForPublication(pub, false);
            if (KmeliaHelper.isIndexable(pub)) {
                this.indexExternalElementsOfPublication(pub);
            } else {
                this.unIndexExternalElementsOfPublication(pub.getPK());
            }
        }
        this.sendSubscriptionsNotification(pub, NotifAction.PUBLISHED, false);
    }

    @Override
    public void externalElementsOfPublicationHaveChanged(PublicationPK pubPK, String userId) {
        this.externalElementsOfPublicationHaveChanged(pubPK, userId, true);
    }

    private void externalElementsOfPublicationHaveChanged(PublicationPK pubPK, String userId, boolean indexExternalElements) {
        if (pubPK == null || StringUtil.isNotDefined((String)pubPK.getInstanceId()) || !pubPK.getInstanceId().startsWith("kmelia") && !pubPK.getInstanceId().startsWith("toolbox") && !pubPK.getInstanceId().startsWith("kmax")) {
            return;
        }
        PublicationConcernedByUpdate publicationConcernedByUpdate = new PublicationConcernedByUpdate(pubPK).invoke();
        if (publicationConcernedByUpdate.isPublicationNotDefined()) {
            return;
        }
        PublicationDetail pubDetail = publicationConcernedByUpdate.getPubDetail();
        boolean isPublicationInBasketBeforeUpdate = publicationConcernedByUpdate.isPublicationInBasketBeforeUpdate();
        if (pubDetail.isClone()) {
            pubDetail.setIndexOperation(-1);
        }
        if (StringUtil.isDefined((String)userId)) {
            pubDetail.setUpdaterId(userId);
        }
        if (!StringUtil.isDefined((String)userId)) {
            this.updatePublication(pubDetail, 1, false);
        } else {
            this.updatePublicationAccordingToProfile(userId, pubDetail);
        }
        if (KmeliaHelper.isIndexable(pubDetail) && !isPublicationInBasketBeforeUpdate) {
            this.publicationService.createIndex(pubDetail);
        }
        if (indexExternalElements) {
            this.indexExternalElementsOfPublication(pubDetail);
        }
    }

    private void updatePublicationAccordingToProfile(String userId, PublicationDetail pubDetail) {
        String profile = this.getProfileOnPublication(userId, pubDetail.getPK());
        if ("supervisor".equals(profile) || SilverpeasRole.PUBLISHER.isInRole(new String[]{profile}) || SilverpeasRole.ADMIN.isInRole(new String[]{profile}) || SilverpeasRole.WRITER.isInRole(new String[]{profile})) {
            this.updatePublication(pubDetail, 1, false);
        } else {
            SilverLogger.getLogger((Object)this).warn("User {0} not allowed to update publication {1}", new Object[]{userId, pubDetail.getPK().getId()});
        }
    }

    private boolean isClone(PublicationDetail publication) {
        return StringUtil.isDefined((String)publication.getCloneId()) && !"-1".equals(publication.getCloneId()) && !StringUtil.isDefined((String)publication.getCloneStatus());
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deletePublication(PublicationPK pubPK) {
        KmeliaOperationContext.about(KmeliaOperationContext.OperationType.DELETION);
        try {
            this.removeXMLContentOfPublication(pubPK);
            this.deleteAllReadingControlsByPublication(pubPK);
            this.publicationService.removeAllFathers(pubPK);
            this.publicationService.removePublication(pubPK);
            this.deleteSilverContent(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void sendPublicationToBasket(PublicationPK pubPK, boolean kmaxMode) {
        KmeliaOperationContext.about(KmeliaOperationContext.OperationType.REMOVING);
        try {
            if (kmaxMode) {
                CoordinatePK coordinatePK = new CoordinatePK(UNKNOWN, pubPK.getSpaceId(), pubPK.getComponentName());
                List fatherPKs = this.publicationService.getAllFatherPKInSamePublicationComponentInstance(pubPK);
                Iterator it = fatherPKs.iterator();
                ArrayList<String> coordinates = new ArrayList<String>();
                while (it.hasNext()) {
                    String coordinateId = ((NodePK)it.next()).getId();
                    coordinates.add(coordinateId);
                }
                if (!coordinates.isEmpty()) {
                    this.coordinatesService.deleteCoordinates(coordinatePK, coordinates);
                }
            }
            this.publicationService.removeAllFathers(pubPK);
            this.publicationService.addFather(pubPK, new NodePK("1", (ResourceReference)pubPK));
            this.removeAllTodosForPublication(pubPK);
            this.updateSilverContentVisibility(pubPK);
            this.unIndexExternalElementsOfPublication(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void sendPublicationToBasket(PublicationPK pubPK) {
        this.sendPublicationToBasket(pubPK, KmeliaHelper.isKmax(pubPK.getInstanceId()));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addPublicationToTopic(PublicationPK pubPK, NodePK fatherPK, boolean isACreation) {
        this.addPublicationToTopicWithoutNotifications(pubPK, fatherPK, isACreation);
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        this.sendSubscriptionsNotification(pubDetail, NotifAction.CREATE, false);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addPublicationToTopicWithoutNotifications(PublicationPK pubPK, NodePK fatherPK, boolean isACreation) {
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        Optional<Location> mainPubLocation = this.publicationService.getMainLocation(pubPK);
        if (!isACreation) {
            try {
                if (mainPubLocation.filter(NodePK::isTrash).isPresent()) {
                    this.publicationService.removeFather(pubPK, (NodePK)mainPubLocation.get());
                    mainPubLocation = Optional.empty();
                    if ("Valid".equalsIgnoreCase(pubDetail.getStatus())) {
                        this.publicationService.createIndex(pubPK);
                        this.indexExternalElementsOfPublication(pubDetail);
                        this.updateSilverContentVisibility(pubDetail);
                    } else if ("ToValidate".equalsIgnoreCase(pubDetail.getStatus())) {
                        this.createTodosForPublication(pubDetail, true);
                    }
                } else if (mainPubLocation.isEmpty()) {
                    pubDetail.setEndDate(null);
                    this.publicationService.setDetail(pubDetail);
                    this.updateSilverContentVisibility(pubDetail);
                }
            }
            catch (Exception e) {
                throw new KmeliaRuntimeException(e);
            }
        }
        try {
            if (mainPubLocation.isPresent()) {
                Location alias = new Location(fatherPK.getId(), fatherPK.getInstanceId());
                alias.setAsAlias(User.getCurrentRequester().getId());
                this.publicationService.addAliases(pubPK, Collections.singletonList(alias));
            } else {
                this.publicationService.addFather(pubPK, fatherPK);
            }
            if (pubDetail.isIndexable()) {
                this.publicationService.createIndex(pubPK);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private boolean isPublicationInBasket(PublicationPK pubPK) {
        return this.publicationService.getAllLocations(pubPK).stream().anyMatch(NodePK::isTrash);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodePK sendSubscriptionsNotification(PublicationDetail pubDetail, NotifAction action, boolean sendOnlyToAliases) {
        NodePK father = null;
        if (!pubDetail.haveGotClone() && pubDetail.isValid() && pubDetail.isVisible()) {
            Collection<Location> locations;
            father = this.getPublicationFatherPK(pubDetail.getPK());
            if (!sendOnlyToAliases && father != null) {
                this.sendSubscriptionsNotification(father, pubDetail, action);
            }
            if ((locations = (Collection<Location>)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)ALIASES_CACHE_KEY)) == null) {
                locations = this.getAliases(pubDetail.getPK());
            }
            this.sendSubscriptionNotificationForAliases(pubDetail, action, locations);
            try {
                int silverObjectId = this.getSilverObjectId(pubDetail.getPK());
                List positions = this.pdcManager.getPositions(silverObjectId, pubDetail.getPK().getInstanceId());
                if (positions == null) return father;
                for (ClassifyPosition position : positions) {
                    this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), pubDetail.getPK().getInstanceId(), silverObjectId);
                }
                return father;
            }
            catch (PdcException e) {
                SilverLogger.getLogger((Object)this).error("PdC subscriptions notification failure for publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
                return father;
            }
        } else {
            KmeliaDelayedVisibilityUserNotificationReminder.get().setAbout(pubDetail);
        }
        return father;
    }

    private void sendSubscriptionNotificationForAliases(PublicationDetail pubDetail, NotifAction action, Collection<Location> locations) {
        locations.stream().filter(Location::isAlias).forEach(a -> {
            PublicationDetail copy = pubDetail.copy();
            copy.setAlias(true);
            this.sendSubscriptionsNotification((NodePK)a, copy, action);
        });
    }

    private void sendSubscriptionsNotification(NodePK fatherPK, PublicationDetail pubDetail, NotifAction action) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaSubscriptionPublicationUserNotification(fatherPK, pubDetail, action));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Subscriber notification failure about publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addInfoLinks(PublicationPK pubPK, List<ResourceReference> links) {
        try {
            this.publicationService.addLinks(pubPK, links);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public CompletePublication getCompletePublication(PublicationPK pubPK) {
        try {
            return this.publicationService.getCompletePublication(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private KmeliaPublication getPublication(PublicationPK pubPK) {
        return KmeliaPublication.withPK(pubPK);
    }

    @Override
    public KmeliaPublication getPublication(PublicationPK pubPK, NodePK topicPK) {
        return KmeliaPublication.withPK(pubPK, topicPK);
    }

    @Override
    public TopicDetail getBestTopicDetailOfPublicationForUser(PublicationPK pubPK, boolean isTreeStructureUsed, String userId) {
        NodePK fatherPK = this.getBestLocationOfPublicationForUser(pubPK, userId);
        String profile = KmeliaHelper.getProfile(this.getUserRoles(pubPK.getInstanceId(), userId));
        return this.goTo(fatherPK, userId, isTreeStructureUsed, profile, false);
    }

    @Override
    public NodePK getBestLocationOfPublicationForUser(PublicationPK pubPK, String userId) {
        Location root = new Location("0", pubPK.getInstanceId());
        return (NodePK)this.getPublicationLocations(pubPK, false).stream().sorted(Comparator.comparing(l -> !l.getInstanceId().equals(pubPK.getInstanceId())).thenComparing(Location::isAlias).thenComparing(WAPrimaryKey::getInstanceId).thenComparing(WAPrimaryKey::getId)).filter(l -> NodeAccessControl.get().isUserAuthorized(userId, l)).findFirst().orElse(root);
    }

    private List<Location> getPublicationLocations(PublicationPK pubPK, boolean inComponentInstance) {
        PublicationDetail publi;
        boolean alwaysVisibleModeActivated;
        Function<PublicationPK, List> locationSupplier = pk -> {
            if (inComponentInstance) {
                return this.publicationService.getLocationsInComponentInstance(pk, pk.getInstanceId());
            }
            return this.publicationService.getAllLocations(pk);
        };
        List locations = locationSupplier.apply(pubPK);
        if (locations.isEmpty() && (alwaysVisibleModeActivated = StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(pubPK.getInstanceId(), "publicationAlwaysVisible"))) && (publi = this.publicationService.getDetail(pubPK)) != null && this.isClone(publi)) {
            locations = locationSupplier.apply(publi.getClonePK());
        }
        return locations;
    }

    @Override
    public NodePK getPublicationFatherPK(PublicationPK pubPK) {
        List<Location> locations = this.getPublicationLocations(pubPK, true);
        return locations.stream().filter(l -> !l.isAlias()).findFirst().orElse(null);
    }

    @Override
    public <T extends ResourceReference> List<PublicationDetail> getPublicationDetails(List<T> references) {
        try {
            return this.publicationService.getPublications((Collection)references.stream().map(l -> new PublicationPK(l.getId(), l.getInstanceId())).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public <T extends ResourceReference> List<KmeliaPublication> getPublications(List<T> references, String userId, NodePK contextFolder, boolean accessControlFiltering) {
        List<PublicationDetail> publications;
        if (accessControlFiltering) {
            Map<PublicationPK, ResourceReference> indexedReferences = references.stream().collect(Collectors.toMap(r -> new PublicationPK(r.getId(), r.getInstanceId()), r -> r));
            List authorizedReferences = PublicationAccessControl.get().filterAuthorizedByUser(indexedReferences.keySet(), userId).map(indexedReferences::get).collect(Collectors.toList());
            publications = this.getPublicationDetails(authorizedReferences);
        } else {
            publications = this.getPublicationDetails(references);
        }
        return contextFolder != null ? this.asLocatedKmeliaPublication(contextFolder, publications) : this.asKmeliaPublication(publications);
    }

    @Override
    public <T extends ResourceReference> List<Pair<KmeliaPublication, KmeliaPublication>> getPublicationsForModification(List<T> references, String userId) {
        Map<PublicationPK, ResourceReference> indexedReferences = references.stream().collect(Collectors.toMap(r -> new PublicationPK(r.getId(), r.getInstanceId()), r -> r));
        AccessControlContext modificationContext = AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION});
        List authorizedReferences = PublicationAccessControl.get().filterAuthorizedByUser(indexedReferences.keySet(), userId, modificationContext).map(indexedReferences::get).collect(Collectors.toList());
        List<PublicationDetail> publications = this.getPublicationDetails(authorizedReferences);
        List pubIds = authorizedReferences.stream().map(WAPrimaryKey::getId).collect(Collectors.toList());
        Map locationsByPublication = this.publicationService.getAllLocationsByPublicationIds(pubIds);
        Map<PublicationPK, PublicationDetail> clones = this.getPublicationDetails(publications.stream().filter(HAS_CLONE).map(PublicationDetail::getClonePK).collect(Collectors.toList())).stream().collect(Collectors.toMap(PublicationDetail::getPK, k -> k));
        return publications.stream().map(p -> KmeliaPublication.fromDetail(p, null, locationsByPublication)).map(k -> Optional.ofNullable(HAS_CLONE.test(k.getDetail()) ? (PublicationDetail)clones.getOrDefault(k.getDetail().getClonePK(), null) : null).map(c -> Pair.of((Object)k, (Object)KmeliaPublication.fromDetail(c, (NodePK)k.getLocation(), locationsByPublication))).orElseGet(() -> Pair.of((Object)k, null))).collect(Collectors.toList());
    }

    @Override
    public List<KmeliaPublication> getLinkedPublications(KmeliaPublication publication, String userId) {
        List allLinks = publication.getCompleteDetail().getLinkedPublications(userId);
        ArrayList<KmeliaPublication> authorizedLinks = new ArrayList<KmeliaPublication>();
        for (PublicationLink link : allLinks) {
            authorizedLinks.add(KmeliaPublication.withPK(link.getPubPK()));
        }
        return authorizedLinks;
    }

    @Override
    public List<KmeliaPublication> getPublicationsToValidate(String componentId, String userId) {
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        try {
            SilverpeasList temp = this.publicationService.getPublicationsByCriteria(PublicationCriteria.onComponentInstanceIds((String[])new String[]{componentId}).ofStatus(new String[]{"ToValidate"}).orderByDescendingLastUpdateDate());
            for (PublicationDetail publi : temp) {
                this.addPublicationsToValidate(userId, publications, publi);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return this.asKmeliaPublication(publications);
    }

    private void addPublicationsToValidate(String userId, Collection<PublicationDetail> publications, PublicationDetail publi) {
        boolean isClone;
        boolean bl = isClone = publi.isValidationRequired() && !"-1".equals(publi.getCloneId());
        if (isClone) {
            if (this.isUserCanValidatePublication(publi.getPK(), userId)) {
                try {
                    PublicationDetail original = this.getPublicationDetail(new PublicationPK(publi.getCloneId(), (ResourceReference)publi.getPK()));
                    publications.add(original);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).warn("Original publication {0} of clone {1} not found", new Object[]{publi.getId(), publi.getCloneId()});
                }
            }
        } else if (this.isUserCanValidatePublication(publi.getPK(), userId)) {
            publications.add(publi);
        }
    }

    private void sendValidationNotification(NodePK fatherPK, PublicationDetail pubDetail, String refusalMotive, String userIdWhoRefuse) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaValidationPublicationUserNotification(fatherPK, pubDetail, refusalMotive, userIdWhoRefuse));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("User notification failure about publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
        }
    }

    private void sendAlertToSupervisors(NodePK fatherPK, PublicationDetail pubDetail) {
        if (pubDetail.isValid()) {
            try {
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaSupervisorPublicationUserNotification(fatherPK, pubDetail));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Supervisors notification failure about publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
            }
        }
    }

    private int getValidationType(String instanceId) {
        String sParam = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(instanceId, "targetValidation");
        if (StringUtil.isDefined((String)sParam)) {
            return Integer.parseInt(sParam);
        }
        return 0;
    }

    private boolean isTargetedValidationEnabled(String componentId) {
        int value = this.getValidationType(componentId);
        return value == 2 || value == 1;
    }

    @Override
    public ValidatorsList getAllValidators(PublicationPK pubPK) {
        ValidatorsList allValidators = new ValidatorsList(this.getValidationType(pubPK.getInstanceId()));
        if (this.isTargetedValidationEnabled(pubPK.getInstanceId())) {
            allValidators.addAll(this.getActiveValidatorIds(pubPK));
        } else {
            ArrayList<String> roles = new ArrayList<String>(2);
            roles.add(SilverpeasRole.ADMIN.getName());
            roles.add(SilverpeasRole.PUBLISHER.getName());
            if (KmeliaHelper.isKmax(pubPK.getInstanceId())) {
                allValidators.addAll(Arrays.asList(OrganizationControllerProvider.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), roles)));
            } else {
                this.addAdminAndPublishers(pubPK, allValidators, roles);
            }
        }
        return allValidators;
    }

    private void addAdminAndPublishers(PublicationPK pubPK, List<String> allValidators, List<String> roles) {
        NodePK father = this.getPublicationFatherPK(pubPK);
        if (father != null) {
            NodeDetail topic = this.getNodeHeader(father);
            if (!topic.haveRights()) {
                allValidators.addAll(Arrays.asList(OrganizationControllerProvider.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), roles)));
            } else {
                allValidators.addAll(Arrays.asList(OrganizationControllerProvider.getOrganisationController().getUsersIdsByRoleNames(pubPK.getInstanceId(), ProfiledObjectId.fromNode((String)topic.getRightsDependsOn()), roles)));
            }
        }
    }

    @Override
    public void setValidators(PublicationPK pubOrClonePK, String userIds) {
        PublicationDetail publication = this.getPublicationDetail(pubOrClonePK);
        Object[] validatorIds = StringUtil.split((String)userIds, (char)',');
        if (!ArrayUtil.isEmpty((Object[])validatorIds)) {
            publication.setTargetValidatorId(userIds);
            publication.setStatusMustBeChecked(false);
            publication.setIndexOperation(-1);
            this.publicationService.setDetail(publication);
            if (publication.isValidationRequired()) {
                this.sendValidationAlert(publication, (String[])validatorIds);
            }
        }
    }

    private boolean isValidationComplete(PublicationPK pubPK, List<String> allValidators) {
        List steps = this.publicationService.getValidationSteps(pubPK);
        ArrayList<String> stepUserIds = new ArrayList<String>();
        for (ValidationStep step : steps) {
            stepUserIds.add(step.getUserId());
        }
        boolean validationOK = true;
        for (int i = 0; validationOK && i < allValidators.size(); ++i) {
            String validatorId = allValidators.get(i);
            validationOK = stepUserIds.contains(validatorId);
        }
        return validationOK;
    }

    @Override
    public boolean validatePublication(PublicationPK pubPK, String userId, boolean force, boolean hasUserNoMoreValidationRight) {
        boolean validationComplete;
        try {
            PublicationDetail currentPubDetail;
            CompletePublication currentPub = this.publicationService.getCompletePublication(pubPK);
            PublicationDetail currentPubOrCloneDetail = currentPubDetail = currentPub.getPublicationDetail();
            boolean validationOnClone = currentPubDetail.haveGotClone();
            PublicationPK validatedPK = pubPK;
            if (validationOnClone) {
                validatedPK = currentPubDetail.getClonePK();
                currentPubOrCloneDetail = this.getPublicationDetail(validatedPK);
            }
            if (!hasUserNoMoreValidationRight && !this.isUserCanValidatePublication(validatedPK, userId)) {
                SilverLogger.getLogger((Object)this).debug("user ''{0}'' is not allowed to validate publication {1}", new Object[]{userId, pubPK.toString()});
                return false;
            }
            String validatorUserId = userId;
            Date validationDate = new Date();
            if (force) {
                validationComplete = true;
            } else if (!hasUserNoMoreValidationRight) {
                validationComplete = this.completeValidation(pubPK, validatedPK, userId, validationOnClone);
            } else {
                ValidationChecker validationChecker = new ValidationChecker().setPubPK(pubPK).setUserId(userId).setCurrentPubDetail(currentPubDetail).setCurrentPubOrCloneDetail(currentPubOrCloneDetail).setValidatedPK(validatedPK).setValidationDate(validationDate).setValidatorUserId(validatorUserId).check();
                validationComplete = validationChecker.isValidationComplete();
                validatorUserId = validationChecker.getValidatorUserId();
                validationDate = validationChecker.getValidationDate();
            }
            if (validationComplete) {
                this.applyValidation(pubPK, currentPub, currentPubDetail, validatedPK, validatorUserId, validationDate, validationOnClone);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return validationComplete;
    }

    private void applyValidation(PublicationPK pubPK, CompletePublication currentPub, PublicationDetail currentPubDetail, PublicationPK validatedPK, String validatorUserId, Date validationDate, boolean validationOnClone) {
        this.removeAllTodosForPublication(validatedPK);
        if (validationOnClone) {
            this.removeAllTodosForPublication(pubPK);
        }
        if (currentPubDetail.haveGotClone()) {
            currentPubDetail = this.mergeClone(currentPub, validatorUserId, validationDate);
        } else if (currentPubDetail.isValidationRequired()) {
            currentPubDetail.setValidatorId(validatorUserId);
            currentPubDetail.setValidateDate(validationDate);
            currentPubDetail.setStatus("Valid");
        }
        KmeliaHelper.checkIndex(currentPubDetail);
        this.publicationService.setDetail(currentPubDetail);
        this.updateSilverContentVisibility(currentPubDetail);
        this.indexExternalElementsOfPublication(currentPubDetail);
        NodePK oneFather = this.sendSubscriptionsNotification(currentPubDetail, NotifAction.PUBLISHED, false);
        this.sendValidationNotification(oneFather, currentPubDetail, null, validatorUserId);
        this.sendAlertToSupervisors(oneFather, currentPubDetail);
    }

    private boolean completeValidation(PublicationPK pubPK, PublicationPK validatedPK, String userId, boolean validationOnClone) {
        boolean validationComplete = false;
        int validationType = this.getValidationType(pubPK.getInstanceId());
        if (validationType == 0 || validationType == 1) {
            validationComplete = true;
        } else {
            if (validationType == 2) {
                PublicationDetail publi = this.publicationService.getDetail(validatedPK);
                boolean bl = validationComplete = !StringUtil.isDefined((String)publi.getTargetValidatorId());
            }
            if (!validationComplete) {
                ValidatorsList allValidators = this.getAllValidators(validatedPK);
                if (allValidators.size() == 1) {
                    validationComplete = true;
                } else if (allValidators.size() > 1) {
                    this.removeTodoForPublication(validatedPK, userId);
                    if (validationOnClone) {
                        this.removeTodoForPublication(pubPK, userId);
                    }
                    ValidationStep validation = new ValidationStep(validatedPK, userId, "Valid");
                    this.publicationService.addValidationStep(validation);
                    validationComplete = this.isValidationComplete(validatedPK, allValidators);
                }
            }
        }
        return validationComplete;
    }

    private PublicationDetail getClone(PublicationDetail refPub) {
        PublicationDetail copy = PublicationDetail.builder((String)refPub.getLanguage()).setPk(new PublicationPK(refPub.getPK().getId(), refPub.getPK().getInstanceId())).setNameAndDescription(refPub.getName(), refPub.getDescription()).build();
        copy.setAuthor(refPub.getAuthor());
        if (refPub.getBeginDate() != null) {
            copy.setBeginDate(new Date(refPub.getBeginDate().getTime()));
        }
        copy.setBeginHour(refPub.getBeginHour());
        copy.setContentPagePath(refPub.getContentPagePath());
        copy.setCreationDate(new Date(refPub.getCreationDate().getTime()));
        copy.setCreatorId(refPub.getCreatorId());
        if (refPub.getEndDate() != null) {
            copy.setEndDate(new Date(refPub.getEndDate().getTime()));
        }
        copy.setEndHour(refPub.getEndHour());
        copy.setImportance(refPub.getImportance());
        copy.setInfoId(refPub.getInfoId());
        copy.setKeywords(refPub.getKeywords());
        copy.setStatus(refPub.getStatus());
        copy.setTargetValidatorId(refPub.getTargetValidatorId());
        copy.setCloneId(refPub.getCloneId());
        if (refPub.getLastUpdateDate() != null) {
            copy.setUpdateDate(new Date(refPub.getLastUpdateDate().getTime()));
        }
        copy.setUpdaterId(refPub.getUpdaterId());
        if (refPub.getValidateDate() != null) {
            copy.setValidateDate(new Date(refPub.getValidateDate().getTime()));
        }
        copy.setValidatorId(refPub.getValidatorId());
        copy.setVersion(refPub.getVersion());
        return copy;
    }

    private PublicationDetail mergeClone(CompletePublication currentPub, String validatorUserId, Date validationDate) {
        PublicationDetail currentPubDetail = currentPub.getPublicationDetail();
        String memInfoId = currentPubDetail.getInfoId();
        PublicationPK pubPK = currentPubDetail.getPK();
        String cloneId = currentPubDetail.getCloneId();
        if (!"-1".equals(cloneId)) {
            PublicationDetail currentClonedPubDetail;
            currentPubDetail = currentClonedPubDetail = this.clonePublication(cloneId, pubPK, validatorUserId, validationDate);
            Transaction.getTransaction().performNew(() -> {
                String instanceId = pubPK.getInstanceId();
                ResourceReference pkFrom = new ResourceReference(pubPK.getId(), instanceId);
                ResourceReference pkTo = new ResourceReference(cloneId, instanceId);
                Map attachmentIds = AttachmentServiceProvider.getAttachmentService().mergeDocuments(pkFrom, pkTo, DocumentType.attachment);
                this.mergeXmlModelClone(pubPK, memInfoId, cloneId, currentClonedPubDetail, attachmentIds);
                this.mergeWysiwygClone(pubPK, cloneId, currentClonedPubDetail);
                return null;
            });
            this.deletePublication(new PublicationPK(cloneId, (ResourceReference)pubPK));
        }
        return currentPubDetail;
    }

    private void mergeXmlModelClone(PublicationPK originalPubPK, String originalInfoId, String cloneId, PublicationDetail currentClonedPubDetail, Map<String, String> attachmentIds) throws PublicationTemplateException, FormException {
        String infoId = currentClonedPubDetail.getInfoId();
        if (infoId != null && !"0".equals(infoId) && !StringUtil.isInteger((String)infoId)) {
            RecordSet set = this.getXMLFormFrom(infoId, originalPubPK);
            if (originalInfoId != null && !"0".equals(originalInfoId)) {
                set.merge(cloneId, originalPubPK.getInstanceId(), originalPubPK.getId(), originalPubPK.getInstanceId(), attachmentIds);
            } else {
                PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
                publicationTemplateManager.addDynamicPublicationTemplate(originalPubPK.getInstanceId() + ":" + infoId, infoId + ".xml");
                set.clone(cloneId, originalPubPK.getInstanceId(), originalPubPK.getId(), originalPubPK.getInstanceId(), attachmentIds);
            }
        }
    }

    private void mergeWysiwygClone(PublicationPK originalPubPK, String cloneId, PublicationDetail currentClonedPubDetail) {
        String language = currentClonedPubDetail.getLanguage();
        boolean cloneWysiwyg = WysiwygController.haveGotWysiwyg((String)originalPubPK.getInstanceId(), (String)cloneId, (String)language);
        if (cloneWysiwyg) {
            try {
                WysiwygController.deleteWysiwygAttachmentsOnly((String)originalPubPK.getInstanceId(), (String)originalPubPK.getId());
            }
            catch (WysiwygException e) {
                SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            }
            WysiwygController.copy((String)originalPubPK.getInstanceId(), (String)cloneId, (String)originalPubPK.getInstanceId(), (String)originalPubPK.getId(), (String)currentClonedPubDetail.getUpdaterId());
        }
    }

    @Override
    public void unvalidatePublication(PublicationPK pubPK, String userId, String refusalMotive, int validationType) {
        try {
            switch (validationType) {
                case 2: 
                case 3: {
                    this.publicationService.removeValidationSteps(pubPK);
                    break;
                }
            }
            PublicationDetail currentPubDetail = this.publicationService.getDetail(pubPK);
            if (currentPubDetail.haveGotClone()) {
                String cloneId = currentPubDetail.getCloneId();
                PublicationPK tempPK = new PublicationPK(cloneId, (ResourceReference)pubPK);
                PublicationDetail clone = this.publicationService.getDetail(tempPK);
                clone.setStatus("UnValidate");
                clone.setIndexOperation(-1);
                this.publicationService.setDetail(clone);
                currentPubDetail.setCloneStatus("Unvalidate");
                currentPubDetail.setUpdateDataMustBeSet(false);
                this.publicationService.setDetail(currentPubDetail);
                NodePK fatherPK = this.getPublicationFatherPK(pubPK);
                this.sendValidationNotification(fatherPK, clone, refusalMotive, userId);
                this.removeAllTodosForPublication(clone.getPK());
            } else {
                currentPubDetail.setStatus("UnValidate");
                KmeliaHelper.checkIndex(currentPubDetail);
                this.publicationService.setDetail(currentPubDetail);
                this.updateSilverContentVisibility(currentPubDetail);
                NodePK fatherPK = this.getPublicationFatherPK(pubPK);
                this.sendValidationNotification(fatherPK, currentPubDetail, refusalMotive, userId);
                this.removeAllTodosForPublication(currentPubDetail.getPK());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void suspendPublication(PublicationPK pubPK, String defermentMotive, String userId) {
        try {
            PublicationDetail currentPubDetail = this.publicationService.getDetail(pubPK);
            currentPubDetail.setStatus("ToValidate");
            KmeliaHelper.checkIndex(currentPubDetail);
            this.publicationService.setDetail(currentPubDetail);
            this.updateSilverContentVisibility(currentPubDetail);
            this.unIndexExternalElementsOfPublication(currentPubDetail.getPK());
            this.sendDefermentNotification(currentPubDetail, defermentMotive);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void sendDefermentNotification(PublicationDetail pubDetail, String defermentMotive) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaDefermentPublicationUserNotification(pubDetail, defermentMotive));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn("User notification failure about publication ''{0}'' (id={1})", new Object[]{pubDetail.getTitle(), pubDetail.getPK().getId()});
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile) {
        PublicationDetail pubDetail = this.draftOutPublicationWithoutNotifications(pubPK, topicPK, userProfile);
        this.indexExternalElementsOfPublication(pubDetail);
        this.sendTodosAndNotificationsOnDraftOut(pubDetail, topicPK, userProfile);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public PublicationDetail draftOutPublicationWithoutNotifications(PublicationPK pubPK, NodePK topicPK, String userProfile) {
        return this.draftOutPublication(pubPK, topicPK, userProfile, false, true);
    }

    @Override
    public void draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile, boolean forceUpdateDate) {
        this.draftOutPublication(pubPK, topicPK, userProfile, forceUpdateDate, false);
    }

    private PublicationDetail draftOutPublication(PublicationPK pubPK, NodePK topicPK, String userProfile, boolean forceUpdateDate, boolean inTransaction) {
        try {
            PublicationDetail changedPublication;
            CompletePublication currentPub = this.publicationService.getCompletePublication(pubPK);
            PublicationDetail pubDetail = currentPub.getPublicationDetail();
            if (userProfile.equals("publisher") || userProfile.equals(ADMIN_ROLE)) {
                if (pubDetail.haveGotClone()) {
                    pubDetail = this.mergeClone(currentPub, null, null);
                }
                pubDetail.setStatus("Valid");
                changedPublication = pubDetail;
            } else if (pubDetail.haveGotClone()) {
                PublicationDetail clone = this.publicationService.getDetail(pubDetail.getClonePK());
                clone.setStatus("ToValidate");
                clone.setIndexOperation(-1);
                clone.setUpdateDataMustBeSet(false);
                this.publicationService.setDetail(clone);
                changedPublication = clone;
                pubDetail.setUpdateDataMustBeSet(false);
                pubDetail.setCloneStatus("ToValidate");
            } else {
                pubDetail.setStatus("ToValidate");
                changedPublication = pubDetail;
            }
            KmeliaHelper.checkIndex(pubDetail);
            this.publicationService.setDetail(pubDetail, forceUpdateDate);
            if (!KmeliaHelper.isKmax(pubDetail.getInstanceId())) {
                this.updateSilverContentVisibility(pubDetail);
            }
            if (!inTransaction) {
                this.indexExternalElementsOfPublication(changedPublication);
                this.sendTodosAndNotificationsOnDraftOut(changedPublication, topicPK, userProfile);
            }
            return changedPublication;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void sendTodosAndNotificationsOnDraftOut(PublicationDetail pubDetail, NodePK topicPK, String userProfile) {
        if (SilverpeasRole.WRITER.isInRole(new String[]{userProfile})) {
            this.createTodosForPublication(pubDetail, true);
        }
        if (!KmeliaHelper.isKmax(pubDetail.getInstanceId())) {
            this.sendSubscriptionsNotification(pubDetail, NotifAction.PUBLISHED, false);
            if (topicPK != null) {
                this.sendAlertToSupervisors(topicPK, pubDetail);
            }
        }
    }

    @Override
    public void draftInPublication(PublicationPK pubPK) {
        this.draftInPublication(pubPK, null);
    }

    @Override
    public void draftInPublication(PublicationPK pubPK, String userId) {
        try {
            PublicationDetail pubDetail = this.publicationService.getDetail(pubPK);
            if (pubDetail.isRefused() || pubDetail.isValid()) {
                pubDetail.setStatus("Draft");
                pubDetail.setUpdaterId(userId);
                KmeliaHelper.checkIndex(pubDetail);
                this.publicationService.setDetail(pubDetail);
                this.updateSilverContentVisibility(pubDetail);
                this.unIndexExternalElementsOfPublication(pubDetail.getPK());
                this.removeAllTodosForPublication(pubPK);
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public UserNotification getUserNotification(PublicationPK pubPK, NodePK topicPK) {
        KmeliaPublication publication = KmeliaPublication.withPK(pubPK, topicPK);
        return new KmeliaNotifyPublicationUserNotification(topicPK, publication.getDetail()).build();
    }

    @Override
    public UserNotification getUserNotification(PublicationPK pubPK, SimpleDocumentPK documentPk, NodePK topicPK) {
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        documentPk.setComponentName(pubDetail.getInstanceId());
        SimpleDocument document = AttachmentServiceProvider.getAttachmentService().searchDocumentById(documentPk, null);
        SimpleDocument version = document.getLastPublicVersion();
        if (version == null) {
            version = document.getVersionMaster();
        }
        return new KmeliaNotifyPublicationDocumentUserNotification(topicPK, pubDetail, version).build();
    }

    @Override
    public void deleteAllReadingControlsByPublication(PublicationPK pubPK) {
        try {
            this.statisticService.deleteStats(new ResourceReference(pubPK.getId(), pubPK.getInstanceId()), PUBLICATION);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HistoryObjectDetail> getLastAccess(PublicationPK pk, NodePK nodePK, String excludedUserId, int maxResult) {
        SilverpeasList silverpeasList;
        HashSet<String> userIds = new HashSet<String>(this.getUserIdsOfFolder(nodePK));
        HashSet<String> readerIds = new HashSet<String>();
        readerIds.add(excludedUserId);
        Pagination pagination = new Pagination(new PaginationPage(1, maxResult)).limitDataSourceCallsTo(10).withMinPerPage(200).paginatedDataSource(p -> this.statisticService.getHistoryByAction(new ResourceReference((WAPrimaryKey)pk), 1, PUBLICATION, (Collection)readerIds, p.originalSizeIsNotRequired())).filter(r -> {
            SilverpeasArrayList currentLastAccess = new SilverpeasArrayList();
            for (HistoryObjectDetail access : r) {
                String readerId = access.getUserId();
                if (!CollectionUtil.isEmpty((Collection)userIds) && !userIds.contains(readerId) || readerIds.contains(readerId)) continue;
                readerIds.add(readerId);
                if (User.getById((String)readerId).isAnonymous()) continue;
                currentLastAccess.add((Object)access);
            }
            return currentLastAccess;
        });
        try {
            silverpeasList = pagination.execute();
        }
        catch (Throwable throwable) {
            if (pagination.isNbMaxDataSourceCallLimitReached()) {
                SilverLogger.getLogger((Object)this).warn("Performing too much paginated sql queries to retrieve last accesses from pub {0} on node {1}", new Object[]{pk, nodePK});
            }
            throw throwable;
        }
        if (pagination.isNbMaxDataSourceCallLimitReached()) {
            SilverLogger.getLogger((Object)this).warn("Performing too much paginated sql queries to retrieve last accesses from pub {0} on node {1}", new Object[]{pk, nodePK});
        }
        return silverpeasList;
    }

    @Override
    public List<String> getUserIdsOfFolder(NodePK pk) {
        if (!this.isRightsOnTopicsEnabled(pk.getInstanceId())) {
            return Collections.emptyList();
        }
        NodeDetail node = this.getNodeHeader(pk);
        if (node != null && node.haveRights()) {
            String rightsDependsOn = node.getRightsDependsOn();
            ArrayList<String> profileNames = new ArrayList<String>(4);
            profileNames.add(ADMIN_ROLE);
            profileNames.add("publisher");
            profileNames.add("writer");
            profileNames.add("user");
            String[] userIds = OrganizationControllerProvider.getOrganisationController().getUsersIdsByRoleNames(pk.getInstanceId(), ProfiledObjectId.fromNode((String)rightsDependsOn), profileNames);
            return Arrays.asList(userIds);
        }
        return Collections.emptyList();
    }

    @Override
    public void indexKmelia(String componentId) {
        this.indexTopics(new NodePK(USELESS, componentId));
        this.indexPublications(componentId);
    }

    private void indexPublications(String componentId) {
        Collection pubs;
        try {
            pubs = this.publicationService.getAllPublications(componentId);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        if (pubs != null) {
            for (PublicationDetail pub : pubs) {
                this.processPublicationIndexation(pub);
            }
        }
    }

    private void processPublicationIndexation(PublicationDetail pub) {
        PublicationPK pk = pub.getPK();
        try {
            if (pub.isValid() && !this.isPublicationInBasket(pub.getPK())) {
                this.indexPublication(pub);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Error during indexation of publication {0}", new Object[]{pk.getId(), e});
        }
    }

    private void indexPublication(PublicationDetail pub) {
        this.publicationService.createIndex(pub.getPK());
        this.indexExternalElementsOfPublication(pub);
    }

    private void indexTopics(NodePK nodePK) {
        try {
            Collection nodes = this.nodeService.getAllNodes(nodePK);
            if (nodes != null) {
                for (NodeDetail node : nodes) {
                    if (node.getNodePK().isRoot() || node.getNodePK().isTrash() || node.getNodePK().getId().equals("2")) continue;
                    this.nodeService.createIndex(node);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void createTodosForPublication(PublicationDetail pubDetail, boolean creation) {
        if (!creation) {
            this.removeAllTodosForPublication(pubDetail.getPK());
        }
        if (pubDetail.isValidationRequired() || "ToValidate".equalsIgnoreCase(pubDetail.getCloneStatus())) {
            int validationType = this.getValidationType(pubDetail.getPK().getInstanceId());
            if (validationType == 2 || validationType == 3) {
                this.publicationService.removeValidationSteps(pubDetail.getPK());
            }
            ValidatorsList validators = this.getAllValidators(pubDetail.getPK());
            this.addTodoAndSendNotificationToValidators(pubDetail, validators);
        }
    }

    private void addTodoAndSendNotificationToValidators(PublicationDetail pub, ValidatorsList validators) {
        if (CollectionUtil.isNotEmpty((Collection)validators)) {
            String[] users = validators.getUserIds();
            this.addTodo(pub, users);
            this.sendValidationAlert(pub, users);
        } else if (validators.isTargetedValidation()) {
            String profile = this.getProfileOnPublication(pub.getMostRecentUpdater(), pub.getPK());
            KmeliaNoMoreValidatorPublicationUserNotification notification = profile != null && SilverpeasRole.fromString((String)profile).isGreaterThanOrEquals(SilverpeasRole.WRITER) ? new KmeliaNoMoreValidatorPublicationUserNotification(null, pub) : new KmeliaNoMoreValidatorPublicationUserNotification(null, pub, User.getCurrentRequester().getId());
            UserNotificationHelper.buildAndSend((UserNotificationBuilder)notification);
        }
    }

    private void addTodo(PublicationDetail pubDetail, String[] users) {
        LocalizationBundle message = ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH);
        TodoDetail todo = new TodoDetail();
        todo.setId(pubDetail.getPK().getId());
        todo.setSpaceId(pubDetail.getPK().getSpace());
        todo.setComponentId(pubDetail.getPK().getComponentName());
        todo.setName(message.getString("ToValidateShort") + " : " + pubDetail.getName());
        ArrayList<Attendee> attendees = new ArrayList<Attendee>();
        for (String user : users) {
            if (user == null) continue;
            attendees.add(new Attendee(user));
        }
        todo.setAttendees(new ArrayList(attendees));
        todo.setDelegatorId(pubDetail.getMostRecentUpdater());
        todo.setExternalId(pubDetail.getPK().getId());
        this.calendar.addToDo(todo);
    }

    private void removeAllTodosForPublication(PublicationPK pubPK) {
        this.calendar.removeToDoFromExternal(USELESS, pubPK.getInstanceId(), pubPK.getId());
    }

    private void removeTodoForPublication(PublicationPK pubPK, List<String> userIds) {
        if (userIds != null) {
            for (String userId : userIds) {
                this.removeTodoForPublication(pubPK, userId);
            }
        }
    }

    private void removeTodoForPublication(PublicationPK pubPK, String userId) {
        this.calendar.removeAttendeeInToDoFromExternal(pubPK.getInstanceId(), pubPK.getId(), userId);
    }

    private void sendValidationAlert(PublicationDetail pubDetail, String[] users) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaPendingValidationPublicationUserNotification(pubDetail, users));
    }

    private void sendModificationAlert(int modificationScope, PublicationDetail pubDetail) {
        UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaModificationPublicationUserNotification(pubDetail, modificationScope));
    }

    @Override
    public void sendModificationAlert(int modificationScope, PublicationPK pubPK) {
        this.sendModificationAlert(modificationScope, this.getPublicationDetail(pubPK));
    }

    @Override
    public int getSilverObjectId(PublicationPK pubPK) {
        int silverObjectId;
        try {
            silverObjectId = this.kmeliaContentManager.getSilverContentId(pubPK.getId(), pubPK.getInstanceId());
            if (silverObjectId == -1) {
                PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
                silverObjectId = this.createSilverContent(pubDetail, pubDetail.getCreatorId());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return silverObjectId;
    }

    private int createSilverContent(PublicationDetail pubDetail, String creatorId) {
        Connection con = null;
        try {
            con = this.getConnection();
            int n = this.kmeliaContentManager.createSilverContent(con, (Contribution)pubDetail, creatorId);
            return n;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public void deleteSilverContent(PublicationPK pubPK) {
        Connection con = this.getConnection();
        try {
            this.kmeliaContentManager.deleteSilverContent(con, pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    private void updateSilverContentVisibility(PublicationDetail pubDetail) {
        try {
            this.kmeliaContentManager.updateSilverContentVisibility((Contribution)pubDetail);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void updateSilverContentVisibility(PublicationPK pubPK) {
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        try {
            this.kmeliaContentManager.updateSilverContentVisibility((Contribution)pubDetail, false);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void indexExternalElementsOfPublication(PublicationDetail pubDetail) {
        if (KmeliaHelper.isIndexable(pubDetail)) {
            try {
                SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listAllDocumentsByForeignKey(pubDetail.getPK().toResourceReference(), null);
                for (SimpleDocument doc : documents) {
                    if (doc.getDocumentType() == DocumentType.wysiwyg) continue;
                    AttachmentServiceProvider.getAttachmentService().createIndex(doc, pubDetail.getBeginDate(), pubDetail.getEndDate());
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Indexing versioning documents failed for publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
            }
            try {
                this.getCommentService().indexAllCommentsOnPublication(pubDetail.getContributionType(), new ResourceReference((WAPrimaryKey)pubDetail.getPK()));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Indexing comments failed for publication {0}", (Object[])new String[]{pubDetail.getPK().getId()}, (Throwable)e);
            }
        }
    }

    private void unIndexExternalElementsOfPublication(PublicationPK pubPK) {
        ResourceReference ref = new ResourceReference((WAPrimaryKey)pubPK);
        try {
            AttachmentServiceProvider.getAttachmentService().unindexAttachmentsOfExternalObject(ref);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Unindexing versioning documents failed for publication {0}", (Object[])new String[]{pubPK.getId()}, (Throwable)e);
        }
        try {
            this.getCommentService().unindexAllCommentsOnPublication(PublicationDetail.getResourceType(), ref);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Unindexing versioning documents failed for publication {0}", (Object[])new String[]{pubPK.getId()}, (Throwable)e);
        }
    }

    @Override
    public void removeContentOfPublication(PublicationPK pubPK) {
        PublicationDetail publication = this.getPublicationDetail(pubPK);
        if (!StringUtil.isInteger((String)publication.getInfoId())) {
            this.removeXMLContentOfPublication(pubPK);
        }
        publication.setInfoId("0");
        this.updatePublication(publication, 1, true);
    }

    private void removeXMLContentOfPublication(PublicationPK pubPK) {
        try {
            PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
            String infoId = pubDetail.getInfoId();
            if (!StringUtil.isInteger((String)infoId)) {
                PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(pubDetail.getPK().getInstanceId() + ":" + infoId);
                RecordSet set = pubTemplate.getRecordSet();
                set.delete(pubDetail.getPK().getId());
            }
        }
        catch (FormException | PublicationTemplateException e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private void freeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Connection freed failure", (Throwable)e);
            }
        }
    }

    @Override
    public void setModelUsed(String[] models, String instanceId, String nodeId) {
        Connection con = this.getConnection();
        try {
            ModelDAO.deleteModel((Connection)con, (String)instanceId, (String)nodeId);
            if (models != null) {
                for (String modelId : models) {
                    ModelDAO.addModel((Connection)con, (String)instanceId, (String)modelId, (String)nodeId);
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public Collection<String> getModelUsed(String instanceId, String nodeId) {
        Connection con = this.getConnection();
        try {
            Collection result = ModelDAO.getModelUsed((Connection)con, (String)instanceId, (String)nodeId);
            if (StringUtil.isDefined((String)nodeId) && result.isEmpty()) {
                NodePath parents = this.nodeService.getPath(new NodePK(nodeId, instanceId));
                Iterator iter = parents.iterator();
                while (iter.hasNext() && result.isEmpty()) {
                    NodeDetail parent = (NodeDetail)iter.next();
                    if (parent.isBin() || parent.isUnclassified() || "-1".equals(parent.getId()) || "notvisibleContributions".equals(parent.getId()) || "tovalidate".equals(parent.getId())) continue;
                    result = ModelDAO.getModelUsed((Connection)con, (String)instanceId, (String)parent.getNodePK().getId());
                }
            }
            Collection collection = result;
            return collection;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    private void copyUsedModel(NodePK from, NodePK to) {
        Connection con = this.getConnection();
        try {
            Collection modelIds = ModelDAO.getModelUsed((Connection)con, (String)from.getInstanceId(), (String)from.getId());
            for (String modelId : modelIds) {
                ModelDAO.addModel((Connection)con, (String)to.getInstanceId(), (String)modelId, (String)to.getId());
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
    }

    @Override
    public List<NodeDetail> getAxis(String componentId) {
        SettingBundle nodeSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.node.nodeSettings");
        String sortField = nodeSettings.getString("sortField", "nodepath");
        String sortOrder = nodeSettings.getString("sortOrder", "asc");
        ArrayList<NodeDetail> axis = new ArrayList<NodeDetail>();
        try {
            List<NodeDetail> headers = this.getAxisHeaders(componentId);
            for (NodeDetail header : headers) {
                if ("Invisible".equals(header.getStatus())) continue;
                axis.addAll(this.nodeService.getSubTree(header.getNodePK(), sortField + " " + sortOrder));
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return axis;
    }

    @Override
    public List<NodeDetail> getAxisHeaders(String componentId) {
        List axisHeaders;
        try {
            axisHeaders = this.nodeService.getHeadersByLevel(new NodePK(USELESS, componentId), 2);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return axisHeaders;
    }

    @Override
    public NodePK addAxis(NodeDetail axis, String componentId) {
        NodePK axisPK = new NodePK("toDefine", componentId);
        NodeDetail rootDetail = new NodeDetail("0", "Root", "desc", 1, "-1");
        rootDetail.getNodePK().setComponentName(componentId);
        rootDetail.setCreationDate(null);
        rootDetail.setCreatorId(UNKNOWN);
        rootDetail.setPath("/0");
        rootDetail.setStatus("Visible");
        axis.setNodePK(axisPK);
        CoordinatePK coordinatePK = new CoordinatePK(USELESS, (WAPrimaryKey)axisPK);
        try {
            NodeDetail createdAxis = this.nodeService.createNode(axis, rootDetail);
            axisPK = createdAxis.getNodePK();
            CoordinatePoint point = new CoordinatePoint(-1, Integer.parseInt(axisPK.getId()), true);
            this.coordinatesService.addPointToAllCoordinates(coordinatePK, point);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        return axisPK;
    }

    @Override
    public void updateAxis(NodeDetail axis, String componentId) {
        axis.getNodePK().setComponentName(componentId);
        NodeDetail previousNode = this.nodeService.getDetail(axis.getNodePK());
        axis.setOrder(previousNode.getOrder());
        try {
            this.nodeService.setDetail(axis);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public void deleteAxis(String axisId, String componentId) {
        NodePK pkToDelete = new NodePK(axisId, componentId);
        CoordinatePK coordinatePK = new CoordinatePK(USELESS, (WAPrimaryKey)pkToDelete);
        try {
            long nbAxisHeaders = this.getAxisHeaders(componentId).stream().map(NodeDetail::getNodePK).filter(n -> !n.isUnclassed() && !n.isTrash()).count();
            if (nbAxisHeaders == 1L) {
                PublicationPK pubPK = new PublicationPK(USELESS, componentId);
                List fatherIds = this.coordinatesService.getCoordinateIdsByNodeId(coordinatePK, axisId).stream().filter(f -> !"2".equals(f) && !"1".equals(f)).collect(Collectors.toList());
                if (!fatherIds.isEmpty()) {
                    this.publicationService.removeFathers(pubPK, fatherIds);
                }
            }
            List subComponents = this.nodeService.getDescendantDetails(pkToDelete);
            Iterator it = subComponents.iterator();
            ArrayList<NodePK> points = new ArrayList<NodePK>();
            points.add(pkToDelete);
            while (it.hasNext()) {
                points.add(((NodeDetail)it.next()).getNodePK());
            }
            this.removeCoordinatesByPoints(points, componentId);
            this.nodeService.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    private void removeCoordinatesByPoints(List<NodePK> nodePKs, String componentId) {
        Iterator<NodePK> it = nodePKs.iterator();
        ArrayList<String> coordinatePoints = new ArrayList<String>();
        while (it.hasNext()) {
            String nodeId = it.next().getId();
            coordinatePoints.add(nodeId);
        }
        CoordinatePK coordinatePK = new CoordinatePK(USELESS, USELESS, componentId);
        try {
            this.coordinatesService.deleteCoordinatesByPoints(coordinatePK, coordinatePoints);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public NodeDetail getNodeHeader(String id, String componentId) {
        NodePK pk = new NodePK(id, componentId);
        return this.getNodeHeader(pk);
    }

    private NodeDetail getNodeHeader(NodePK pk) {
        NodeDetail nodeDetail;
        try {
            nodeDetail = this.nodeService.getHeader(pk);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return nodeDetail;
    }

    @Override
    public void addPosition(String fatherId, NodeDetail position, String componentId, String userId) {
        position.getNodePK().setComponentName(componentId);
        position.setCreationDate(new Date());
        position.setCreatorId(userId);
        NodeDetail fatherDetail = this.getNodeHeader(fatherId, componentId);
        try {
            this.nodeService.createNode(position, fatherDetail);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public void updatePosition(NodeDetail position, String componentId) {
        position.getNodePK().setComponentName(componentId);
        try {
            this.nodeService.setDetail(position);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public void deletePosition(String positionId, String componentId) {
        NodePK pkToDelete = new NodePK(positionId, componentId);
        try {
            List subComponents = this.nodeService.getDescendantDetails(pkToDelete);
            Iterator it = subComponents.iterator();
            ArrayList<NodePK> points = new ArrayList<NodePK>();
            points.add(pkToDelete);
            while (it.hasNext()) {
                points.add(((NodeDetail)it.next()).getNodePK());
            }
            this.removeCoordinatesByPoints(points, componentId);
            this.nodeService.removeNode(pkToDelete);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public Collection<NodeDetail> getPath(String id, String componentId) {
        ArrayList<NodeDetail> newPath = new ArrayList<NodeDetail>();
        NodePK nodePK = new NodePK(id, componentId);
        try {
            NodePath pathInReverse = this.nodeService.getPath(nodePK);
            for (int i = pathInReverse.size() - 1; i >= 0; --i) {
                newPath.add((NodeDetail)pathInReverse.get(i));
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return newPath;
    }

    @Override
    public List<KmeliaPublication> search(List<String> combination, String componentId) {
        Collection<PublicationDetail> publications = this.searchPublications(combination, componentId);
        if (publications == null) {
            return new ArrayList<KmeliaPublication>();
        }
        return this.asKmeliaPublication(publications);
    }

    @Override
    public List<KmeliaPublication> search(List<String> combination, int nbDays, String componentId) {
        Collection<PublicationDetail> publications = this.searchPublications(combination, componentId);
        return this.asKmeliaPublication(this.filterPublicationsByBeginDate(publications, nbDays));
    }

    private Collection<PublicationDetail> searchPublications(List<String> combination, String componentId) {
        PublicationPK pk = new PublicationPK(USELESS, componentId);
        CoordinatePK coordinatePK = new CoordinatePK(UNKNOWN, (WAPrimaryKey)pk);
        Collection publications = null;
        try {
            for (int i = 0; i < combination.size(); ++i) {
                String axisValue = combination.get(i);
                StringTokenizer st = new StringTokenizer(axisValue, "/");
                int nodeLevel = st.countTokens();
                if (nodeLevel != 2) continue;
                combination.remove(i);
                --i;
            }
            if (combination.isEmpty()) {
                NodePK basketPK = new NodePK("1", componentId);
                publications = this.publicationService.getDetailsNotInFatherPK(basketPK);
            } else {
                Collection coordinates = this.coordinatesService.getCoordinatesByFatherPaths(combination, coordinatePK);
                if (coordinates != null && !coordinates.isEmpty()) {
                    publications = this.publicationService.getDetailsByFatherIds((List)((ArrayList)coordinates), componentId, false);
                }
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return publications;
    }

    @Override
    public Collection<KmeliaPublication> getUnbalancedPublications(String componentId) {
        Collection publications;
        try {
            publications = this.publicationService.getOrphanPublications(componentId);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return this.asKmeliaPublication(publications);
    }

    private Collection<PublicationDetail> filterPublicationsByBeginDate(Collection<PublicationDetail> publications, int nbDays) {
        ArrayList<PublicationDetail> pubOK = new ArrayList<PublicationDetail>();
        if (publications != null) {
            Calendar rightNow = Calendar.getInstance();
            if (nbDays == 0) {
                nbDays = 1;
            }
            rightNow.add(5, -nbDays);
            Date day = rightNow.getTime();
            for (PublicationDetail pub : publications) {
                Date dateToCompare = pub.getBeginDate() != null ? pub.getBeginDate() : pub.getCreationDate();
                if (dateToCompare.compareTo(day) < 0) continue;
                pubOK.add(pub);
            }
        }
        return pubOK;
    }

    @Override
    public void indexKmax(String componentId) {
        this.indexAxis(componentId);
        this.indexPublications(componentId);
    }

    private void indexAxis(String componentId) {
        NodePK nodePK = new NodePK(USELESS, componentId);
        try {
            Collection nodes = this.nodeService.getAllNodes(nodePK);
            if (nodes != null) {
                for (NodeDetail nodeDetail : nodes) {
                    if ("corbeille".equalsIgnoreCase(nodeDetail.getName()) && nodeDetail.getNodePK().isTrash()) continue;
                    this.nodeService.createIndex(nodeDetail);
                }
            }
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public KmeliaPublication getKmaxPublication(String pubId, String currentUserId) {
        CompletePublication completePublication;
        try {
            PublicationPK pubPK = new PublicationPK(pubId);
            completePublication = this.publicationService.getCompletePublication(pubPK);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return KmeliaPublication.aKmeliaPublicationFromCompleteDetail(completePublication);
    }

    @Override
    public Collection<Coordinate> getPublicationCoordinates(String pubId, String componentId) {
        try {
            return this.publicationService.getCoordinates(pubId, componentId);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public void addPublicationToCombination(String pubId, List<String> combination, String componentId) {
        PublicationPK pubPK = new PublicationPK(pubId, componentId);
        CoordinatePK coordinatePK = new CoordinatePK(UNKNOWN, (WAPrimaryKey)pubPK);
        try {
            Collection<Coordinate> coordinates = this.getPublicationCoordinates(pubId, componentId);
            if (!this.checkCombination(coordinates, combination)) {
                return;
            }
            Iterator<String> it = combination.iterator();
            ArrayList<CoordinatePoint> allnodes = new ArrayList<CoordinatePoint>();
            int i = 1;
            while (it.hasNext()) {
                String nodeId = it.next();
                NodePK nodePK = new NodePK(nodeId, componentId);
                NodePath path = this.nodeService.getPath(nodePK);
                Iterator iterator = path.iterator();
                while (iterator.hasNext()) {
                    NodeDetail aPath;
                    NodeDetail nodeDetail = aPath = (NodeDetail)iterator.next();
                    String anscestorId = nodeDetail.getNodePK().getId();
                    int nodeLevel = nodeDetail.getLevel();
                    if (nodeDetail.getNodePK().isRoot()) continue;
                    CoordinatePoint point = anscestorId.equals(nodeId) ? new CoordinatePoint(-1, Integer.parseInt(anscestorId), true, nodeLevel, i) : new CoordinatePoint(-1, Integer.parseInt(anscestorId), false, nodeLevel, i);
                    allnodes.add(point);
                }
                ++i;
            }
            int coordinateId = this.coordinatesService.addCoordinate(coordinatePK, allnodes);
            this.publicationService.addFather(pubPK, new NodePK(String.valueOf(coordinateId), (ResourceReference)pubPK));
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    protected boolean checkCombination(Collection<Coordinate> coordinates, List<String> combination) {
        for (Coordinate coordinate : coordinates) {
            Collection points = coordinate.getCoordinatePoints();
            if (points.isEmpty()) continue;
            boolean matchFound = false;
            for (CoordinatePoint point : points) {
                if (!this.checkPoint(point, combination)) {
                    matchFound = false;
                    break;
                }
                matchFound = true;
            }
            if (!matchFound) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPoint(CoordinatePoint point, List<String> combination) {
        for (String intVal : combination) {
            if (Integer.parseInt(intVal) != point.getNodeId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deletePublicationFromCombination(String pubId, String combinationId, String componentId) {
        PublicationPK pubPK = new PublicationPK(pubId, componentId);
        NodePK fatherPK = new NodePK(combinationId, componentId);
        CoordinatePK coordinatePK = new CoordinatePK(combinationId, (WAPrimaryKey)pubPK);
        try {
            this.publicationService.removeFather(pubPK, fatherPK);
            ArrayList<String> coordinateIds = new ArrayList<String>(1);
            coordinateIds.add(combinationId);
            this.coordinatesService.deleteCoordinates(coordinatePK, coordinateIds);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
    }

    @Override
    public String createKmaxPublication(PublicationDetail pubDetail) {
        PublicationPK pubPK;
        Connection con = this.getConnection();
        try {
            this.changePublicationStatusOnCreation(pubDetail, new NodePK(USELESS, (ResourceReference)pubDetail.getPK()));
            pubPK = this.publicationService.createPublication(pubDetail);
            pubDetail.getPK().setId(pubPK.getId());
            this.createTodosForPublication(pubDetail, true);
            this.createSilverContent(pubDetail, pubDetail.getCreatorId());
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
        finally {
            this.freeConnection(con);
        }
        return pubPK.getId();
    }

    @Override
    public Collection<Location> getAliases(PublicationPK pubPK) {
        try {
            return this.publicationService.getAllAliases(pubPK);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public Collection<Location> getLocations(PublicationPK pubPK) {
        try {
            PublicationDetail publication;
            boolean alwaysVisibleModeActivated;
            List locations = this.publicationService.getAllLocations(pubPK);
            if (locations.isEmpty() && (alwaysVisibleModeActivated = StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(pubPK.getInstanceId(), "publicationAlwaysVisible"))) && (publication = this.publicationService.getDetail(pubPK)) != null && this.isClone(publication)) {
                locations = this.publicationService.getAllLocations(publication.getClonePK());
            }
            return locations;
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    @Override
    public void setAliases(PublicationPK pubPK, List<Location> locations) {
        Pair result = this.publicationService.setAliases(pubPK, locations);
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)ALIASES_CACHE_KEY, result.getFirst());
        PublicationDetail pubDetail = this.getPublicationDetail(pubPK);
        this.sendSubscriptionsNotification(pubDetail, NotifAction.PUBLISHED, true);
    }

    @Override
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public void addAttachmentToPublication(PublicationPK pubPK, String userId, String filename, String description, byte[] contents) {
        try {
            HistorisedDocument document;
            Date creationDate = new Date();
            SimpleAttachment file = SimpleAttachment.builder((String)I18NHelper.DEFAULT_LANGUAGE).setFilename(FileUtil.getFilename((String)filename)).setTitle(filename).setDescription("").setSize((long)contents.length).setContentType(FileUtil.getMimeType((String)filename)).setCreationData(userId, creationDate).build();
            boolean versioningActive = StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(pubPK.getComponentName(), "versionControl"));
            if (versioningActive) {
                document = new HistorisedDocument(new SimpleDocumentPK(null, pubPK.getComponentName()), pubPK.getId(), 0, file);
                document.setPublicDocument(true);
                document.setDocumentType(DocumentType.attachment);
            } else {
                document = new SimpleDocument(new SimpleDocumentPK(null, pubPK.getComponentName()), pubPK.getId(), 0, false, file);
            }
            AttachmentServiceProvider.getAttachmentService().createAttachment((SimpleDocument)document, (InputStream)new ByteArrayInputStream(contents));
        }
        catch (AttachmentException fnfe) {
            throw new KmeliaRuntimeException(fnfe);
        }
    }

    @Override
    public NodeDetail createTopic(String componentId, String topicId, String spaceId, String userId, String name, String description) {
        NodeDetail topic = new NodeDetail("-1", name, description, 0, "X");
        topic.getNodePK().setSpace(spaceId);
        topic.getNodePK().setComponentName(componentId);
        topic.setCreatorId(userId);
        NodePK fatherPK = new NodePK(topicId, spaceId, componentId);
        String alertType = "None";
        return this.addSubTopic(fatherPK, topic, alertType);
    }

    @Override
    public String clonePublication(CompletePublication refPubComplete, PublicationDetail pubDetail, String nextStatus) {
        String cloneId;
        try {
            PublicationDetail refPub = refPubComplete.getPublicationDetail();
            String fromId = refPub.getPK().getId();
            String fromComponentId = refPub.getPK().getInstanceId();
            PublicationDetail clone = this.getClone(refPub);
            SettingBundle publicationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");
            String absolutePath = FileRepositoryManager.getAbsolutePath((String)fromComponentId);
            if (pubDetail != null) {
                clone.setAuthor(pubDetail.getAuthor());
                clone.setBeginDate(pubDetail.getBeginDate());
                clone.setBeginHour(pubDetail.getBeginHour());
                clone.setDescription(pubDetail.getDescription());
                clone.setEndDate(pubDetail.getEndDate());
                clone.setEndHour(pubDetail.getEndHour());
                clone.setImportance(pubDetail.getImportance());
                clone.setKeywords(pubDetail.getKeywords());
                clone.setName(pubDetail.getName());
                clone.setTargetValidatorId(pubDetail.getTargetValidatorId());
            }
            if (StringUtil.isInteger((String)refPub.getInfoId())) {
                clone.setInfoId(null);
            }
            clone.setStatus(nextStatus);
            clone.setCloneId(fromId);
            clone.setIndexOperation(-1);
            PublicationPK clonePK = this.publicationService.createPublication(clone);
            clonePK.setComponentName(fromComponentId);
            cloneId = clonePK.getId();
            SimpleDocumentList documents = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKey(new ResourceReference(fromId, fromComponentId), null);
            HashMap attachmentIds = new HashMap(documents.size());
            Collections.reverse(documents);
            for (SimpleDocument document : documents) {
                AttachmentServiceProvider.getAttachmentService().cloneDocument(document, cloneId);
            }
            String xmlFormShortName = refPub.getInfoId();
            if (xmlFormShortName != null && !"0".equals(xmlFormShortName) && !StringUtil.isInteger((String)xmlFormShortName)) {
                PublicationTemplateManager templateManager = PublicationTemplateManager.getInstance();
                templateManager.addDynamicPublicationTemplate(fromComponentId + ":" + xmlFormShortName, xmlFormShortName + ".xml");
                PublicationTemplate pubTemplate = templateManager.getPublicationTemplate(fromComponentId + ":" + xmlFormShortName);
                RecordSet set = pubTemplate.getRecordSet();
                set.clone(fromId, fromComponentId, cloneId, fromComponentId, attachmentIds);
            }
            WysiwygController.copy((String)fromComponentId, (String)fromId, (String)fromComponentId, (String)cloneId, (String)clone.getCreatorId());
            refPub.setCloneId(cloneId);
            refPub.setCloneStatus(nextStatus);
            refPub.setStatusMustBeChecked(false);
            refPub.setUpdateDataMustBeSet(false);
            this.updatePublication(refPub);
            String vignette = refPub.getImage();
            if (vignette != null) {
                ThumbnailDetail thumbDetail = new ThumbnailDetail(clone.getPK().getInstanceId(), Integer.parseInt(clone.getPK().getId()), 1);
                thumbDetail.setMimeType(refPub.getImageMimeType());
                if (vignette.startsWith("/")) {
                    thumbDetail.setOriginalFileName(vignette);
                } else {
                    String thumbnailsSubDirectory = publicationSettings.getString("imagesSubDirectory");
                    String from = absolutePath + thumbnailsSubDirectory + File.separator + vignette;
                    String type = FilenameUtils.getExtension((String)vignette);
                    String newVignette = System.currentTimeMillis() + "." + type;
                    String to = absolutePath + thumbnailsSubDirectory + File.separator + newVignette;
                    FileRepositoryManager.copyFile((String)from, (String)to);
                    thumbDetail.setOriginalFileName(newVignette);
                }
                ThumbnailServiceProvider.getThumbnailService().createThumbnail(thumbDetail);
            }
        }
        catch (IOException | FormException | PublicationTemplateException | ThumbnailException e) {
            throw new KmeliaRuntimeException(e);
        }
        return cloneId;
    }

    private CommentService getCommentService() {
        return this.commentService;
    }

    private LocalizationBundle getMultilang() {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH);
    }

    @Override
    public NodeDetail getRoot(String componentId, String userId) {
        return this.getRoot(componentId, userId, null);
    }

    private NodeDetail getRoot(String componentId, String userId, List<NodeDetail> treeview) {
        NodePK rootPK = new NodePK("0", componentId);
        NodeDetail root = this.nodeService.getDetail(rootPK);
        this.setRole(root, userId);
        root.setChildrenDetails(this.getRootChildren(root, userId, treeview));
        return root;
    }

    private List<NodeDetail> getRootChildren(NodeDetail root, String userId, List<NodeDetail> treeview) {
        String instanceId = root.getNodePK().getInstanceId();
        ArrayList<NodeDetail> children = new ArrayList<NodeDetail>();
        try {
            NodeDetail temp;
            this.setAllowedSubfolders(root, userId);
            List nodes = (List)root.getChildrenDetails();
            this.setNbItemsOfSubfolders(root, treeview, userId);
            NodeDetail trash = null;
            for (NodeDetail node : nodes) {
                if (node.getNodePK().isTrash()) {
                    trash = node;
                    continue;
                }
                if (node.getNodePK().isUnclassed()) continue;
                children.add(node);
            }
            if (this.isUserCanValidate(instanceId, userId)) {
                temp = new NodeDetail();
                temp.getNodePK().setId("tovalidate");
                temp.setName(this.getMultilang().getString("ToValidateShort"));
                if (this.isNbItemsDisplayed(instanceId)) {
                    int nbPublisToValidate = this.getPublicationsToValidate(instanceId, userId).size();
                    temp.setNbObjects(nbPublisToValidate);
                }
                children.add(temp);
            }
            if (this.isUserCanWrite(instanceId, userId)) {
                temp = new NodeDetail();
                temp.getNodePK().setId("notvisibleContributions");
                temp.setName(this.getMultilang().getString("kmelia.folder.nonvisiblepubs"));
                if (this.isNbItemsDisplayed(instanceId)) {
                    int nbPublis = this.getNonVisiblePublications(instanceId, userId).size();
                    temp.setNbObjects(nbPublis);
                }
                children.add(temp);
                if (trash != null) {
                    children.add(trash);
                }
            }
            root.setChildrenDetails(children);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return children;
    }

    @Override
    public NodeDetail getFolder(NodePK nodePK, String userId) {
        NodeDetail node = this.nodeService.getDetail(nodePK);
        if (node.getNodePK().isRoot()) {
            node.setChildrenDetails(this.getRootChildren(node, userId, null));
        } else {
            this.setAllowedSubfolders(node, userId);
        }
        List<NodeDetail> treeView = this.getTreeview(nodePK, userId);
        this.setNbItemsOfFolders(node.getNodePK().getInstanceId(), Collections.singletonList(node), treeView);
        this.setNbItemsOfSubfolders(node, treeView, userId);
        return node;
    }

    @Override
    public Collection<NodeDetail> getFolderChildren(NodePK nodePK, String userId) {
        NodeDetail node = this.getFolder(nodePK, userId);
        return node.getChildrenDetails();
    }

    private void setNbItemsOfSubfolders(NodeDetail node, List<NodeDetail> treeview, String userId) {
        String instanceId = node.getNodePK().getInstanceId();
        if (this.isNbItemsDisplayed(instanceId)) {
            if (treeview == null) {
                treeview = this.getTreeview(node.getNodePK(), userId);
            }
            this.setNbItemsOfFolders(instanceId, node.getChildrenDetails(), treeview);
        }
    }

    private List<NodeDetail> getTreeview(NodePK pk, String userId) {
        String instanceId = pk.getInstanceId();
        if (this.isUserComponentAdmin(instanceId, userId)) {
            return this.getTreeview(pk, ADMIN_ROLE, this.isCoWritingEnable(instanceId), this.isDraftVisibleWithCoWriting(), userId, this.isNbItemsDisplayed(instanceId), false);
        }
        return this.getTreeview(pk, this.getUserTopicProfile(pk, userId), this.isCoWritingEnable(instanceId), this.isDraftVisibleWithCoWriting(), userId, this.isNbItemsDisplayed(instanceId), this.isRightsOnTopicsEnabled(instanceId));
    }

    private void setNbItemsOfFolders(String componentId, Collection<NodeDetail> nodes, List<NodeDetail> treeview) {
        if (this.isNbItemsDisplayed(componentId)) {
            for (NodeDetail child : nodes) {
                int index = treeview.indexOf(child);
                if (index == -1) continue;
                child.setNbObjects(treeview.get(index).getNbObjects());
            }
        }
    }

    private void setAllowedSubfolders(NodeDetail node, String userId) {
        String instanceId = node.getNodePK().getInstanceId();
        if (this.isRightsOnTopicsEnabled(instanceId)) {
            if (this.isUserComponentAdmin(instanceId, userId) || SilverpeasRole.ADMIN.getName().equals(this.getUserTopicProfile(node.getNodePK(), userId))) {
                this.setRole(node.getChildrenDetails(), userId);
            } else {
                List<NodeDetail> allowedChildren = this.getAllowedSubfolders(node, userId);
                this.setRole(allowedChildren, userId);
                node.setChildrenDetails(allowedChildren);
            }
        }
    }

    private boolean isUserComponentAdmin(String componentId, String userId) {
        return ADMIN_ROLE.equalsIgnoreCase(KmeliaHelper.getProfile(this.getUserRoles(componentId, userId)));
    }

    private void setRole(NodeDetail node, String userId) {
        if (this.isRightsOnTopicsEnabled(node.getNodePK().getInstanceId())) {
            node.setUserRole(this.getUserTopicProfile(node.getNodePK(), userId));
        }
    }

    private void setRole(Collection<NodeDetail> nodes, String userId) {
        for (NodeDetail node : nodes) {
            this.setRole(node, userId);
        }
    }

    private boolean isRightsOnTopicsEnabled(String componentId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "rightsOnTopics"));
    }

    private boolean isNbItemsDisplayed(String componentId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "displayNB"));
    }

    private boolean isCoWritingEnable(String componentId) {
        return StringUtil.getBooleanValue((String)OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "coWriting"));
    }

    private boolean isDraftVisibleWithCoWriting() {
        return this.getComponentSettings().getBoolean("draftVisibleWithCoWriting", false);
    }

    @Override
    public String getUserTopicProfile(NodePK pk, String userId) {
        if (!this.isRightsOnTopicsEnabled(pk.getInstanceId()) || KmeliaHelper.isSpecialFolder(pk.getId())) {
            return KmeliaHelper.getProfile(this.getUserRoles(pk.getInstanceId(), userId));
        }
        NodeDetail node = this.getNodeHeader(pk.getId(), pk.getInstanceId());
        if (node != null && node.haveRights()) {
            String rightsDependsOn = node.getRightsDependsOn();
            return KmeliaHelper.getProfile(OrganizationControllerProvider.getOrganisationController().getUserProfiles(userId, pk.getInstanceId(), ProfiledObjectId.fromNode((String)rightsDependsOn)));
        }
        return KmeliaHelper.getProfile(this.getUserRoles(pk.getInstanceId(), userId));
    }

    private String[] getUserRoles(String componentId, String userId) {
        OrganizationController oc = OrganizationControllerProvider.getOrganisationController();
        Object[] profiles = oc.getUserProfiles(userId, componentId);
        if (ArrayUtil.isEmpty((Object[])profiles) && oc.getComponentInstLight(componentId).isPublic()) {
            profiles = new String[]{"user"};
        }
        return profiles;
    }

    private NodePK getRootPK(String componentId) {
        return new NodePK("0", componentId);
    }

    @Override
    public boolean isUserCanValidatePublication(PublicationPK pubPK, String userId) {
        PublicationDetail publi = this.getPublicationDetail(pubPK);
        if (!publi.isValidationRequired()) {
            return false;
        }
        ValidatorsList validators = this.getAllValidators(pubPK);
        if (!validators.contains(userId)) {
            return false;
        }
        if (validators.getValidationType() == 2) {
            ValidationStep validationStep = this.publicationService.getValidationStepByUser(pubPK, userId);
            return validationStep == null;
        }
        return true;
    }

    @Override
    public boolean isUserCanValidate(String componentId, String userId) {
        if (KmeliaHelper.isToolbox(componentId)) {
            return false;
        }
        return this.isUserCanPublish(componentId, userId);
    }

    @Override
    public boolean isUserCanWrite(String componentId, String userId) {
        String[] grantedRoles = new String[]{SilverpeasRole.ADMIN.getName(), SilverpeasRole.PUBLISHER.getName(), SilverpeasRole.WRITER.getName()};
        return this.checkUserRoles(componentId, userId, grantedRoles);
    }

    @Override
    public boolean isUserCanPublish(String componentId, String userId) {
        String[] grantedRoles = new String[]{SilverpeasRole.ADMIN.getName(), SilverpeasRole.PUBLISHER.getName()};
        return this.checkUserRoles(componentId, userId, grantedRoles);
    }

    private boolean checkUserRoles(String componentId, String userId, String ... roles) {
        SilverpeasRole userProfile = SilverpeasRole.fromString((String)KmeliaHelper.getProfile(this.getUserRoles(componentId, userId)));
        boolean checked = Objects.requireNonNull(userProfile).isInRole(roles);
        if (!checked && this.isRightsOnTopicsEnabled(componentId)) {
            Iterator descendants = this.nodeService.getDescendantDetails(this.getRootPK(componentId)).iterator();
            while (!checked && descendants.hasNext()) {
                String[] profiles;
                NodeDetail descendant = (NodeDetail)descendants.next();
                if (!descendant.haveLocalRights() || (profiles = this.adminController.getProfilesByObjectAndUserId(ProfiledObjectId.fromNode((String)descendant.getNodePK().getId()), componentId, userId)).length <= 0) continue;
                userProfile = SilverpeasRole.fromString((String)KmeliaHelper.getProfile(profiles));
                checked = Objects.requireNonNull(userProfile).isInRole(roles);
            }
        }
        return checked;
    }

    @Override
    public NodeDetail getExpandedPathToNode(NodePK pk, String userId) {
        String instanceId = pk.getInstanceId();
        ArrayList<NodeDetail> nodes = new ArrayList<NodeDetail>((Collection<NodeDetail>)this.nodeService.getPath(pk));
        Collections.reverse(nodes);
        nodes.remove(0);
        List<NodeDetail> treeview = null;
        if (this.isNbItemsDisplayed(instanceId)) {
            treeview = this.getTreeview(this.getRootPK(instanceId), userId);
        }
        NodeDetail root = this.getRoot(instanceId, userId, treeview);
        if (treeview != null) {
            root.setNbObjects(treeview.get(0).getNbObjects());
            this.setNbItemsOfFolders(instanceId, nodes, treeview);
        }
        NodeDetail currentNode = root;
        for (NodeDetail node : nodes) {
            Collection children = this.nodeService.getChildrenDetails(node.getNodePK());
            node.setChildrenDetails(children);
            this.setAllowedSubfolders(node, userId);
            if (treeview != null) {
                this.setNbItemsOfSubfolders(node, treeview, userId);
            }
            if (currentNode != null) {
                currentNode = this.find(currentNode.getChildrenDetails(), node);
            }
            if (currentNode == null) continue;
            currentNode.setChildrenDetails(node.getChildrenDetails());
        }
        return root;
    }

    private NodeDetail find(Collection<NodeDetail> nodes, NodeDetail toFind) {
        for (NodeDetail node : nodes) {
            if (!node.getNodePK().getId().equals(toFind.getNodePK().getId())) continue;
            return node;
        }
        return null;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public List<String> deletePublications(List<String> ids, NodePK nodePK, String userId) {
        ArrayList<String> removedIds = new ArrayList<String>();
        String profile = this.getProfile(userId, nodePK);
        for (String id : ids) {
            PublicationPK pk = new PublicationPK(id, (ResourceReference)nodePK);
            if (!this.isUserCanDeletePublication(new PublicationPK(id, (ResourceReference)nodePK), profile, userId)) continue;
            try {
                if (nodePK.isTrash() && this.isPublicationInBasket(pk)) {
                    this.deletePublication(pk);
                } else {
                    this.sendPublicationToBasket(pk);
                }
                removedIds.add(id);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Deletion of publication {0} failed", (Object[])new String[]{pk.getId()}, (Throwable)e);
            }
        }
        return removedIds;
    }

    private boolean isUserCanDeletePublication(PublicationPK pubPK, String profile, String userId) {
        User owner = this.getPublication(pubPK).getCreator();
        return KmeliaPublicationHelper.isRemovable(pubPK.getInstanceId(), userId, profile, owner);
    }

    @Override
    public Optional<KmeliaPublication> getContributionById(ContributionIdentifier contributionId) {
        return Optional.of(this.getPublication(new PublicationPK(contributionId.getLocalId(), contributionId.getComponentInstanceId())));
    }

    public SettingBundle getComponentSettings() {
        return settings;
    }

    public LocalizationBundle getComponentMessages(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("kmelia") || instanceId.startsWith("kmax") || instanceId.startsWith("toolbox");
    }

    @Override
    @SimulationActionProcess(elementLister=KmeliaNodeSimulationElementLister.class)
    @Action(value=ActionType.MOVE)
    public void moveNode(@SourcePK NodePK nodePK, @TargetPK NodePK to, KmeliaPasteDetail pasteContext) {
        List treeToPaste = this.nodeService.getSubTree(nodePK);
        boolean rightsOnTopicsEnabled = this.isRightsOnTopicsEnabled(to.getInstanceId());
        this.nodeService.moveNode(nodePK, to, rightsOnTopicsEnabled);
        for (NodeDetail fromNode : treeToPaste) {
            boolean movedToAnotherApp;
            if (fromNode == null) continue;
            NodePK toNodePK = new NodePK(fromNode.getNodePK().getId(), (ResourceReference)to);
            boolean bl = movedToAnotherApp = !nodePK.getInstanceId().equals(to.getInstanceId());
            if (movedToAnotherApp) {
                NodeDetail toNode = this.nodeService.getDetail(toNodePK);
                this.updateNodeRights(toNode, fromNode, rightsOnTopicsEnabled);
                if (!nodePK.getInstanceId().equals(to.getInstanceId())) {
                    WysiwygController.move((String)fromNode.getNodePK().getInstanceId(), (String)(NODE_PREFIX + fromNode.getId()), (String)to.getInstanceId(), (String)(NODE_PREFIX + toNodePK.getId()));
                }
            }
            this.movePublicationsOfTopic(fromNode.getNodePK(), toNodePK, pasteContext);
        }
        nodePK.setComponentName(to.getInstanceId());
    }

    private void updateNodeRights(NodeDetail node, NodeDetail fromNode, boolean rightsOnTopicsEnabled) {
        if (fromNode.haveLocalRights()) {
            List profiles = this.adminController.getProfilesByObject(ProfiledObjectId.fromNode((String)fromNode.getNodePK().getId()), fromNode.getNodePK().getInstanceId());
            if (rightsOnTopicsEnabled) {
                this.filterTopicProfiles(profiles, node, null, p -> this.adminController.deleteProfileInst(p.getId()));
            } else {
                for (ProfileInst profile : profiles) {
                    this.adminController.deleteProfileInst(profile.getId());
                }
            }
        }
    }

    private void movePublicationsOfTopic(NodePK fromPK, NodePK toPK, KmeliaPasteDetail pasteContext) {
        Collection publications = this.publicationService.getDetailsByFatherPK(fromPK);
        pasteContext.setFromPK(fromPK);
        for (PublicationDetail publi : publications) {
            this.movePublication(publi.getPK(), toPK, pasteContext);
        }
    }

    @Override
    @SimulationActionProcess(elementLister=KmeliaNodeSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    public NodeDetail copyNode(@SourcePK @TargetPK KmeliaCopyDetail copyDetail) {
        HashMap<String, String> oldAndNewIds = new HashMap<String, String>();
        return this.copyNode(copyDetail, oldAndNewIds);
    }

    private NodeDetail copyNode(KmeliaCopyDetail copyDetail, HashMap<String, String> oldAndNewIds) {
        NodePK nodePKToCopy = copyDetail.getFromNodePK();
        NodePK targetPK = copyDetail.getToNodePK();
        String userId = copyDetail.getUserId();
        NodeDetail nodeToCopy = this.nodeService.getDetail(nodePKToCopy);
        NodeDetail father = this.getNodeHeader(targetPK);
        boolean rightsOnTopicsEnabled = this.isRightsOnTopicsEnabled(targetPK.getInstanceId());
        NodePK nodePK = new NodePK(UNKNOWN, (ResourceReference)targetPK);
        NodeDetail node = new NodeDetail(nodeToCopy);
        node.setNodePK(nodePK);
        node.setCreatorId(userId);
        node.setRightsDependsOn("-1");
        node.setCreationDate(new Date());
        NodeDetail copiedNode = this.nodeService.createNode(node, father);
        this.copyNodePredefinedClassification(nodeToCopy.getNodePK(), copiedNode.getNodePK());
        if (rightsOnTopicsEnabled && copyDetail.isNodeRightsMustBeCopied()) {
            oldAndNewIds.put(nodePKToCopy.getId(), copiedNode.getId());
            this.setNodeRightsDependency(nodeToCopy, father, copiedNode);
            this.copyNodeRights(userId, nodeToCopy, copiedNode);
        }
        WysiwygController.copy((String)nodePKToCopy.getInstanceId(), (String)(NODE_PREFIX + nodePKToCopy.getId()), (String)copiedNode.getNodePK().getInstanceId(), (String)(NODE_PREFIX + copiedNode.getId()), (String)userId);
        this.copyUsedModel(nodePKToCopy, copiedNode.getNodePK());
        KmeliaCopyDetail folderContentCopy = new KmeliaCopyDetail((PasteDetail)copyDetail);
        folderContentCopy.setFromNodePK(nodePKToCopy);
        folderContentCopy.setToNodePK(copiedNode.getNodePK());
        if (copyDetail.isPublicationHeaderMustBeCopied()) {
            this.copyPublications(folderContentCopy);
        }
        Collection subtopics = nodeToCopy.getChildrenDetails();
        for (NodeDetail subTopic : subtopics) {
            if (subTopic == null) continue;
            folderContentCopy.setFromNodePK(subTopic.getNodePK());
            this.copyNode(folderContentCopy, oldAndNewIds);
        }
        return copiedNode;
    }

    private void copyNodeRights(String userId, NodeDetail sourceNode, NodeDetail targetNode) {
        if (sourceNode.haveLocalRights()) {
            List topicProfiles = this.adminController.getProfilesByObject(ProfiledObjectId.fromNode((String)sourceNode.getNodePK().getId()), sourceNode.getNodePK().getInstanceId());
            this.filterTopicProfiles(topicProfiles, targetNode, userId, p -> {});
        }
    }

    private void copyNodePredefinedClassification(NodePK nodeToCopy, NodePK nodePK) {
        PdcClassification nodeClassification = this.pdcClassificationService.getPreDefinedClassification(nodeToCopy.getId(), nodeToCopy.getComponentInstanceId());
        if (!nodeClassification.isEmpty() && nodeClassification.isPredefinedForANode()) {
            PdcClassification copy = nodeClassification.copy().forNode(nodePK.getId()).inComponentInstance(nodePK.getComponentInstanceId());
            this.pdcClassificationService.savePreDefinedClassification(copy);
        }
    }

    private void filterTopicProfiles(List<ProfileInst> profiles, NodeDetail node, String userId, Consumer<ProfileInst> preFiltering) {
        NodeDetail father = this.getNodeHeader(node.getFatherPK());
        ArrayList<ProfileInst> fatherProfiles = new ArrayList<ProfileInst>();
        if (father.haveRights()) {
            fatherProfiles.addAll(this.adminController.getProfilesByObject(ProfiledObjectId.fromNode((String)father.getRightsDependsOn()), father.getNodePK().getInstanceId()));
        }
        for (ProfileInst topicProfile : profiles) {
            preFiltering.accept(topicProfile);
            ProfileInst nodeProfileInst = new ProfileInst(topicProfile);
            this.filterUsersAndGroupsInNodeProfile(nodeProfileInst, fatherProfiles, node);
            this.adminController.addProfileInst(nodeProfileInst, userId);
        }
    }

    private void filterUsersAndGroupsInNodeProfile(ProfileInst profile, List<ProfileInst> fatherProfiles, NodeDetail node) {
        ArrayList verifiedUserIds = new ArrayList();
        ArrayList verifiedGroupIds = new ArrayList();
        String instanceId = node.getNodePK().getInstanceId();
        if (!fatherProfiles.isEmpty()) {
            fatherProfiles.stream().flatMap(p -> p.getAllUsers().stream()).distinct().filter(u -> profile.getAllUsers().contains(u)).forEach(verifiedUserIds::add);
            fatherProfiles.stream().flatMap(p -> p.getAllGroups().stream()).distinct().filter(g -> profile.getAllGroups().contains(g)).forEach(verifiedGroupIds::add);
        } else {
            ComponentAccessControl accessControl = ComponentAccessControl.get();
            profile.getAllUsers().stream().filter(u -> accessControl.isUserAuthorized(u, (Object)instanceId)).forEach(verifiedUserIds::add);
            profile.getAllGroups().stream().filter(g -> accessControl.isGroupAuthorized(g, (Object)instanceId)).forEach(verifiedGroupIds::add);
        }
        profile.setId("-1");
        profile.setUsers(verifiedUserIds);
        profile.setGroups(verifiedGroupIds);
        profile.setComponentFatherId(ComponentInst.getComponentLocalId((String)instanceId));
        profile.setObjectId(ProfiledObjectId.fromNode((String)node.getId()));
        profile.setParentObjectId(ProfiledObjectId.fromNode((String)node.getFatherPK().getId()));
    }

    private void setNodeRightsDependency(NodeDetail nodeToCopy, NodeDetail father, NodeDetail node) {
        if (nodeToCopy.haveRights()) {
            if (nodeToCopy.haveLocalRights()) {
                node.setRightsDependsOnMe();
            } else {
                node.setRightsDependsOn(father.getRightsDependsOn());
            }
            this.nodeService.updateRightsDependency(node);
        }
    }

    @Override
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void copyPublications(@SourcePK @TargetPK KmeliaCopyDetail copyDetail) {
        Collection publications = this.publicationService.getDetailsByFatherPK(copyDetail.getFromNodePK());
        for (PublicationDetail publi : publications) {
            this.copyPublication(publi, copyDetail);
        }
    }

    @Override
    @SimulationActionProcess(elementLister=KmeliaPublicationSimulationElementLister.class)
    @Action(value=ActionType.COPY)
    @Transactional(value=Transactional.TxType.REQUIRED)
    public PublicationDetail copyPublication(@SourcePK PublicationDetail publiToCopy, @TargetPK KmeliaCopyDetail copyDetail) {
        NodePK toNodePK = copyDetail.getToNodePK();
        String userId = copyDetail.getUserId();
        String toComponentId = toNodePK.getInstanceId();
        NodePK fromNodePK = copyDetail.getFromNodePK();
        KmeliaPublication publication = KmeliaPublication.fromDetail(publiToCopy, fromNodePK);
        try {
            if (publication.isAlias()) {
                Location location = new Location(copyDetail.getToNodePK().getId(), toComponentId);
                location.setAsAlias(userId);
                this.publicationService.addAliases(publiToCopy.getPK(), Collections.singletonList(location));
                return publiToCopy;
            }
            return this.copyPublication(publiToCopy, toNodePK, toComponentId, copyDetail, userId);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error("Publication copy failure", (Throwable)ex);
            return null;
        }
    }

    private PublicationDetail copyPublication(PublicationDetail publiToCopy, NodePK toNodePK, String toComponentId, KmeliaCopyDetail copyDetail, String userId) throws PdcException, PublicationTemplateException, FormException {
        ResourceReference toResourceReference = new ResourceReference("", toNodePK.getInstanceId());
        PublicationPK toPubPK = new PublicationPK(UNKNOWN, (ResourceReference)toNodePK);
        PublicationDetail newPubli = PublicationDetail.builder((String)publiToCopy.getLanguage()).setPk(toPubPK).setNameAndDescription(publiToCopy.getName(), publiToCopy.getDescription()).setVersion(publiToCopy.getVersion()).setKeywords(publiToCopy.getKeywords()).setBeginDateTime(publiToCopy.getBeginDate(), publiToCopy.getBeginHour()).setEndDateTime(publiToCopy.getEndDate(), publiToCopy.getEndHour()).setImportance(publiToCopy.getImportance()).build();
        newPubli.setTranslations(publiToCopy.getClonedTranslations());
        newPubli.setAuthor(publiToCopy.getAuthor());
        newPubli.setCreatorId(userId);
        if (copyDetail.isPublicationContentMustBeCopied()) {
            newPubli.setInfoId(publiToCopy.getInfoId());
        }
        if (copyDetail.isAdministrativeOperation()) {
            newPubli.setCreatorId(publiToCopy.getCreatorId());
            newPubli.setCreationDate(publiToCopy.getCreationDate());
            newPubli.setUpdaterId(publiToCopy.getUpdaterId());
            newPubli.setUpdateDate(publiToCopy.getLastUpdateDate());
            newPubli.setStatus(publiToCopy.getStatus());
            newPubli.setTargetValidatorId(publiToCopy.getTargetValidatorId());
        } else {
            newPubli.setTargetValidatorId(copyDetail.getPublicationValidatorIds());
            this.setToByPassDraftMode(copyDetail, toNodePK, newPubli, userId);
        }
        String fromId = publiToCopy.getPK().getId();
        String fromComponentId = publiToCopy.getPK().getInstanceId();
        ResourceReference fromResourceReference = new ResourceReference(publiToCopy.getPK().getId(), fromComponentId);
        PublicationPK fromPubPK = new PublicationPK(publiToCopy.getPK().getId(), fromComponentId);
        String id = this.createPublicationIntoTopic(newPubli, toNodePK);
        toPubPK.setId(id);
        toResourceReference.setId(id);
        ThumbnailController.copyThumbnail((ResourceReference)fromResourceReference, (ResourceReference)toResourceReference);
        if (copyDetail.isPublicationPositionsMustBeCopied()) {
            this.copyPdcPositions(fromPubPK, toPubPK);
        }
        HashMap<String, String> fileIds = new HashMap<String, String>();
        if (copyDetail.isPublicationFilesMustBeCopied()) {
            fileIds.putAll(this.copyFiles(fromPubPK, toPubPK));
        }
        if (copyDetail.isPublicationContentMustBeCopied()) {
            String xmlFormShortName = newPubli.getInfoId();
            if (xmlFormShortName != null && !"0".equals(xmlFormShortName)) {
                this.registerXmlForm(fromComponentId, fromResourceReference, toComponentId, toResourceReference, xmlFormShortName, fileIds);
            } else {
                WysiwygController.copy((String)fromComponentId, (String)fromId, (String)toPubPK.getInstanceId(), (String)id, (String)userId);
            }
        }
        this.publicationService.createIndex(toPubPK);
        return newPubli;
    }

    private void setToByPassDraftMode(@TargetPK KmeliaCopyDetail copyDetail, NodePK nodePK, PublicationDetail newPubli, String userId) {
        if (StringUtil.isDefined((String)copyDetail.getPublicationStatus())) {
            String profile = this.getProfile(userId, nodePK);
            if (!copyDetail.getPublicationStatus().equals("Draft")) {
                if (SilverpeasRole.fromString((String)profile).isGreaterThanOrEquals(SilverpeasRole.PUBLISHER)) {
                    newPubli.setStatus("Valid");
                } else {
                    newPubli.setStatus("ToValidate");
                }
            }
        }
    }

    private void registerXmlForm(String fromComponentId, ResourceReference fromResourceReference, String toComponentId, ResourceReference toResourceReference, String xmlFormShortName, Map<String, String> fileIds) throws PublicationTemplateException, FormException {
        PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
        GenericRecordSet toRecordset = publicationTemplateManager.addDynamicPublicationTemplate(toComponentId + ":" + xmlFormShortName, xmlFormShortName + ".xml");
        PublicationTemplate pubTemplate = publicationTemplateManager.getPublicationTemplate(fromComponentId + ":" + xmlFormShortName);
        RecordSet set = pubTemplate.getRecordSet();
        set.copy(fromResourceReference, toResourceReference, toRecordset.getRecordTemplate(), fileIds);
    }

    private Map<String, String> copyFiles(PublicationPK fromPK, PublicationPK toPK) {
        HashMap<String, String> fileIds = new HashMap<String, String>();
        SimpleDocumentList origins = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(fromPK.toResourceReference(), DocumentType.attachment, null);
        for (SimpleDocument origin : origins) {
            SimpleDocumentPK copyPk = AttachmentServiceProvider.getAttachmentService().copyDocument(origin, new ResourceReference((WAPrimaryKey)toPK));
            fileIds.put(origin.getId(), copyPk.getId());
        }
        return fileIds;
    }

    private void copyPdcPositions(PublicationPK fromPK, PublicationPK toPK) throws PdcException {
        int fromSilverObjectId = this.getSilverObjectId(fromPK);
        int toSilverObjectId = this.getSilverObjectId(toPK);
        this.pdcManager.copyPositions(fromSilverObjectId, fromPK.getInstanceId(), toSilverObjectId, toPK.getInstanceId());
    }

    @Override
    public List<KmeliaPublication> filterPublications(List<KmeliaPublication> publications, String instanceId, SilverpeasRole profile, String userId) {
        boolean coWriting = this.isCoWritingEnable(instanceId);
        RemovedSpaceAndComponentInstanceChecker checker = RemovedSpaceAndComponentInstanceChecker.create();
        Predicate<KmeliaPublication> removedComponentInstance = k -> checker.isRemovedComponentInstanceById(k.getComponentInstanceId());
        Predicate<KmeliaPublication> visiblePublication = k -> this.isPublicationVisible(k.getDetail(), profile, userId, coWriting);
        return publications.stream().filter(Predicate.not(removedComponentInstance).and(visiblePublication)).collect(Collectors.toList());
    }

    @Override
    public void userHaveBeenDeleted(String userId) {
        List publications = this.publicationService.removeUserFromTargetValidators(userId);
        SilverLogger.getLogger((Object)this).debug("User ''{0}'' have been removed from {1} publications as target validator", new Object[]{userId, publications.size()});
        KmeliaValidation.by(userId).validatorHasNoMoreRight().validate(publications);
    }

    private boolean isPublicationVisible(PublicationDetail detail, SilverpeasRole profile, String userId, boolean coWriting) {
        if (detail.getStatus() != null) {
            if (detail.isValid()) {
                return this.isVisible(detail, profile, userId, coWriting);
            }
            if (detail.isDraft()) {
                return this.isVisibleInDraft(detail, profile, userId, coWriting);
            }
            return this.isVisibleInPublished(detail, profile, userId, coWriting);
        }
        return false;
    }

    private boolean isVisibleInDraft(PublicationDetail detail, SilverpeasRole profile, String userId, boolean coWriting) {
        return userId.equals(detail.getCreatorId()) || userId.equals(detail.getUpdaterId()) || coWriting && this.isDraftVisibleWithCoWriting() && profile != SilverpeasRole.USER || detail.haveGotClone() && profile.isGreaterThanOrEquals(SilverpeasRole.PUBLISHER);
    }

    private boolean isVisibleInPublished(PublicationDetail detail, SilverpeasRole profile, String userId, boolean coWriting) {
        return profile == SilverpeasRole.ADMIN || profile == SilverpeasRole.PUBLISHER || userId.equals(detail.getCreatorId()) || userId.equals(detail.getUpdaterId()) || profile != SilverpeasRole.USER && coWriting;
    }

    private boolean isVisible(PublicationDetail detail, SilverpeasRole profile, String userId, boolean coWriting) {
        if (detail.isVisible()) {
            return true;
        }
        return profile == SilverpeasRole.ADMIN || userId.equals(detail.getUpdaterId()) || profile != SilverpeasRole.USER && coWriting;
    }

    private PublicationDetail clonePublication(String cloneId, PublicationPK pubPK, String validatorUserId, Date validationDate) {
        PublicationPK tempPK = new PublicationPK(cloneId, (ResourceReference)pubPK);
        CompletePublication publication = this.publicationService.getCompletePublication(tempPK);
        PublicationDetail clone = this.getClone(publication.getPublicationDetail());
        clone.setPk(pubPK);
        if (validatorUserId != null) {
            clone.setValidatorId(validatorUserId);
            clone.setValidateDate(validationDate != null ? validationDate : new Date());
        }
        clone.setStatus("Valid");
        clone.setCloneId("-1");
        clone.setCloneStatus(null);
        return clone;
    }

    private RecordSet getXMLFormFrom(String infoId, PublicationPK pubPK) throws PublicationTemplateException {
        PublicationTemplateManager publicationTemplateManager = PublicationTemplateManager.getInstance();
        PublicationTemplate pubTemplate = publicationTemplateManager.getPublicationTemplate(pubPK.getInstanceId() + ":" + infoId);
        return pubTemplate.getRecordSet();
    }

    protected void onDocumentDeletion(AttachmentRef attachment) {
        Optional<KmeliaOperationContext> context = KmeliaOperationContext.current();
        if (context.isEmpty() || !context.get().isAbout(KmeliaOperationContext.OperationType.DELETION)) {
            PublicationPK pubPK = new PublicationPK(attachment.getForeignId(), attachment.getInstanceId());
            this.externalElementsOfPublicationHaveChanged(pubPK, attachment.getUserId(), false);
        }
    }

    @Override
    public UserNotification getUserNotification(NodePK pk) {
        NodeDetail node = this.getNodeHeader(pk);
        return new KmeliaNotifyTopicUserNotification(node).build();
    }

    @Override
    public List<String> getActiveValidatorIds(PublicationPK pk) {
        PublicationDetail pub = this.getPublicationDetail(pk);
        return this.getActiveValidatorIds(pub);
    }

    private List<String> getActiveValidatorIds(PublicationDetail publication) {
        ArrayList<String> activeValidatorIds = new ArrayList<String>();
        String[] validatorIds = publication.getTargetValidatorIds();
        if (validatorIds == null) {
            return activeValidatorIds;
        }
        for (String userId : validatorIds) {
            String profile = this.getProfileOnPublication(userId, publication.getPK());
            if (profile == null || !SilverpeasRole.fromString((String)profile).isGreaterThanOrEquals(SilverpeasRole.PUBLISHER)) continue;
            activeValidatorIds.add(userId);
        }
        return activeValidatorIds;
    }

    @Override
    public void performReminder(Reminder reminder) {
        if (KmeliaDelayedVisibilityUserNotificationReminder.KMELIA_DELAYED_VISIBILITY_USER_NOTIFICATION.asString().equals(reminder.getProcessName())) {
            this.getContributionById(reminder.getContributionId()).filter(p -> !this.isPublicationInBasket(p.getPk())).map(KmeliaPublication::getDetail).ifPresent(p -> this.sendSubscriptionsNotification((PublicationDetail)p, NotifAction.PUBLISHED, false));
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteClone(PublicationPK pk) {
        PublicationDetail clone = this.getPublicationDetail(pk);
        PublicationDetail original = this.getPublicationDetail(clone.getClonePK());
        this.deletePublication(pk);
        original.setCloneId(null);
        original.setCloneStatus(null);
        original.setUpdateDataMustBeSet(false);
        original.setIndexOperation(-1);
        this.publicationService.setDetail(original);
    }

    @Override
    public List<KmeliaPublication> getNonVisiblePublications(String componentId, String userId) {
        try {
            SilverpeasList temp = this.publicationService.getPublicationsByCriteria(PublicationCriteria.onComponentInstanceIds((String[])new String[]{componentId}).ofStatus(new String[]{"Valid"}).nonVisibleAt(OffsetDateTime.now()).excludingNodes(new String[]{"1"}).orderByDescendingLastUpdateDate());
            List<PublicationDetail> publications = PublicationAccessControl.get().filterAuthorizedByUser(userId, (Collection)temp).collect(Collectors.toList());
            return this.asKmeliaPublication(publications);
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private class ValidationChecker {
        private PublicationPK pubPK;
        private String userId;
        private PublicationDetail currentPubDetail;
        private PublicationDetail currentPubOrCloneDetail;
        private PublicationPK validatedPK;
        private boolean validationComplete = false;
        private String validatorUserId;
        private Date validationDate;

        private ValidationChecker() {
        }

        public ValidationChecker setPubPK(PublicationPK pubPK) {
            this.pubPK = pubPK;
            return this;
        }

        public ValidationChecker setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public ValidationChecker setCurrentPubDetail(PublicationDetail currentPubDetail) {
            this.currentPubDetail = currentPubDetail;
            return this;
        }

        public ValidationChecker setCurrentPubOrCloneDetail(PublicationDetail currentPubOrCloneDetail) {
            this.currentPubOrCloneDetail = currentPubOrCloneDetail;
            return this;
        }

        public ValidationChecker setValidatedPK(PublicationPK validatedPK) {
            this.validatedPK = validatedPK;
            return this;
        }

        public ValidationChecker setValidatorUserId(String validatorUserId) {
            this.validatorUserId = validatorUserId;
            return this;
        }

        public ValidationChecker setValidationDate(Date validationDate) {
            this.validationDate = validationDate;
            return this;
        }

        public boolean isValidationComplete() {
            return this.validationComplete;
        }

        public String getValidatorUserId() {
            return this.validatorUserId;
        }

        public Date getValidationDate() {
            return this.validationDate;
        }

        public ValidationChecker check() {
            NodePK fatherPK;
            int validationType = DefaultKmeliaService.this.getValidationType(this.pubPK.getInstanceId());
            boolean alertPublicationOwnerThereIsNoMoreValidator = false;
            switch (validationType) {
                case 0: 
                case 1: {
                    alertPublicationOwnerThereIsNoMoreValidator = true;
                    break;
                }
                default: {
                    ValidatorsList allValidators = DefaultKmeliaService.this.getAllValidators(this.validatedPK);
                    if (allValidators.isEmpty()) {
                        alertPublicationOwnerThereIsNoMoreValidator = true;
                        break;
                    }
                    this.validationComplete = DefaultKmeliaService.this.isValidationComplete(this.validatedPK, allValidators);
                    if (this.validationComplete) {
                        this.findLastValidation();
                        break;
                    }
                    if (validationType != 2 || !StringUtil.isNotDefined((String)this.currentPubOrCloneDetail.getTargetValidatorId())) break;
                    alertPublicationOwnerThereIsNoMoreValidator = true;
                }
            }
            if (alertPublicationOwnerThereIsNoMoreValidator && (fatherPK = DefaultKmeliaService.this.getPublicationFatherPK(this.currentPubDetail.getPK())) != null) {
                this.sendNoMoreValidatorNotification(fatherPK, this.currentPubDetail);
            }
            return this;
        }

        private void findLastValidation() {
            this.validationDate = new Date(0L);
            for (ValidationStep validationStep : DefaultKmeliaService.this.publicationService.getValidationSteps(this.validatedPK)) {
                String validationStepUserId = validationStep.getUserId();
                if (validationStepUserId.equals(this.userId) || validationStep.getValidationDate().compareTo(this.validationDate) <= 0) continue;
                this.validationDate = validationStep.getValidationDate();
                this.validatorUserId = validationStepUserId;
            }
        }

        private void sendNoMoreValidatorNotification(NodePK fatherPK, PublicationDetail pubDetail) {
            if (pubDetail.isValidationRequired() || pubDetail.isValid()) {
                try {
                    UserNotificationHelper.buildAndSend((UserNotificationBuilder)new KmeliaNoMoreValidatorPublicationUserNotification(fatherPK, pubDetail));
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error("fatherId = {0}, pubPK = {1}", (Object[])new String[]{fatherPK.getId(), pubDetail.getPK().toString()}, (Throwable)e);
                }
            }
        }
    }

    private class PublicationConcernedByUpdate {
        private final PublicationPK pubPK;
        private PublicationDetail pubDetail;
        private boolean isPublicationInBasketBeforeUpdate;

        public PublicationConcernedByUpdate(PublicationPK pubPK) {
            this.pubPK = pubPK;
        }

        public PublicationDetail getPubDetail() {
            return this.pubDetail;
        }

        public boolean isPublicationInBasketBeforeUpdate() {
            return this.isPublicationInBasketBeforeUpdate;
        }

        public PublicationConcernedByUpdate invoke() {
            this.pubDetail = null;
            this.isPublicationInBasketBeforeUpdate = false;
            try {
                this.isPublicationInBasketBeforeUpdate = DefaultKmeliaService.this.isPublicationInBasket(this.pubPK);
                this.pubDetail = DefaultKmeliaService.this.getPublicationDetail(this.pubPK);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)DefaultKmeliaService.this).error("Impossible to get the publication {0}", new Object[]{this.pubPK.getId()});
            }
            return this;
        }

        public boolean isPublicationNotDefined() {
            return this.pubDetail == null || StringUtil.isDefined((String)this.pubPK.getInstanceId()) && !this.pubDetail.getInstanceId().equals(this.pubPK.getInstanceId());
        }
    }
}

